/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.tokenmgmt;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.sso.client.SamlToken;
import org.apache.commons.lang.Validate;

public class TokenEx {
    private final SamlToken _token;
    private final SsoDomain _domain;
    private volatile int _cachedHashCode;

    public TokenEx(SamlToken samlToken, SsoDomain ssoDomain) {
        Validate.notNull((Object)samlToken);
        Validate.notNull((Object)ssoDomain);
        this._token = samlToken;
        this._domain = ssoDomain;
    }

    public SamlToken getToken() {
        return this._token;
    }

    public SsoDomain getIssuerSsoDomain() {
        return this._domain;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TokenEx) {
            TokenEx tokenEx = (TokenEx)object;
            return this._token.equals((Object)tokenEx._token) && this._domain.equals(tokenEx._domain);
        }
        return false;
    }

    public int hashCode() {
        int n = this._cachedHashCode;
        if (n != 0) {
            return n;
        }
        n = 17;
        n = 31 * n + (this._token != null ? this._token.hashCode() : 0);
        this._cachedHashCode = n = 31 * n + (this._domain != null ? this._domain.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "[domain=" + this._domain + ", token=" + this._token + "]";
    }
}

