/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.tokenmgmt;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.sso.tokenmgmt.TokenEx;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.util.concurrent.annotation.Immutable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;

@Immutable
public class TokenFutureAndIssuerDomain
implements Future<TokenEx> {
    @Nonnull
    private final SsoDomain _issuerDomain;
    @Nonnull
    private final Future<SamlToken> _tokenFuture;

    public TokenFutureAndIssuerDomain(@Nonnull SsoDomain ssoDomain, @Nonnull Future<SamlToken> future) {
        Validate.notNull((Object)ssoDomain);
        Validate.notNull(future);
        this._issuerDomain = ssoDomain;
        this._tokenFuture = future;
    }

    @Override
    public TokenEx get() throws InterruptedException, ExecutionException {
        SamlToken samlToken = this._tokenFuture.get();
        return new TokenEx(samlToken, this._issuerDomain);
    }

    @Override
    public TokenEx get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        SamlToken samlToken = this._tokenFuture.get(l, timeUnit);
        return new TokenEx(samlToken, this._issuerDomain);
    }

    @Override
    public boolean isDone() {
        return this._tokenFuture.isDone();
    }

    @Override
    public boolean cancel(boolean bl) {
        return this._tokenFuture.cancel(bl);
    }

    @Override
    public boolean isCancelled() {
        return this._tokenFuture.isCancelled();
    }

    public SsoDomain getIssuerDomain() {
        return this._issuerDomain;
    }
}

