/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.tokenmgmt.impl;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.sso.tokenmgmt.TokenAcquisitionCallback;
import com.vmware.sso.tokenmgmt.TokenAcquisitionResult;
import com.vmware.sso.tokenmgmt.TokenEx;
import com.vmware.sso.tokenmgmt.TokenException;
import com.vmware.sso.tokenmgmt.TokenFutureAndIssuerDomain;
import com.vmware.sso.tokenmgmt.TokenManager;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.TokenSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;

public class NonAcquiringTokenManager
implements TokenManager {
    private final ConcurrentMap<SsoDomain, Future<TokenEx>> _tokensByDomain = new ConcurrentHashMap<SsoDomain, Future<TokenEx>>();

    public NonAcquiringTokenManager() {
    }

    public NonAcquiringTokenManager(@Nonnull SsoDomain ssoDomain, @Nonnull SsoDomain ssoDomain2, @Nonnull SamlToken samlToken) {
        this(ssoDomain, ssoDomain2, (Future<SamlToken>)Futures.immediateFuture((Object)Objects.requireNonNull(samlToken)));
    }

    public NonAcquiringTokenManager(@Nonnull SsoDomain ssoDomain, @Nonnull SsoDomain ssoDomain2, @Nonnull Future<SamlToken> future) {
        this.doSetTokenForSsoDomain(ssoDomain, ssoDomain2, future);
    }

    @Override
    public TokenEx getTokenForSsoDomain(SsoDomain ssoDomain) throws TokenException {
        Validate.notNull((Object)ssoDomain);
        Future future = (Future)this._tokensByDomain.get(ssoDomain);
        if (future == null) {
            throw new TokenException("There's no token for domain " + ssoDomain);
        }
        return NonAcquiringTokenManager.getTokenFromFuture(ssoDomain, future);
    }

    @Override
    public Collection<TokenAcquisitionResult> getAllTokens() {
        Set set = this._tokensByDomain.entrySet();
        if (set.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TokenAcquisitionResult> arrayList = new ArrayList<TokenAcquisitionResult>(set.size());
        for (Map.Entry entry : set) {
            SsoDomain ssoDomain = (SsoDomain)entry.getKey();
            Future future = (Future)entry.getValue();
            TokenEx tokenEx = NonAcquiringTokenManager.getTokenFromFuture(ssoDomain, future);
            arrayList.add(new TokenAcquisitionResult(ssoDomain, tokenEx, null));
        }
        return arrayList;
    }

    @Override
    public void setTokenForSsoDomain(@Nonnull SsoDomain ssoDomain, @Nonnull SsoDomain ssoDomain2, @Nonnull SamlToken samlToken) {
        Validate.notNull((Object)ssoDomain);
        Validate.notNull((Object)ssoDomain2);
        Validate.notNull((Object)samlToken);
        ListenableFuture listenableFuture = Futures.immediateFuture((Object)new TokenEx(samlToken, ssoDomain2));
        this._tokensByDomain.put(ssoDomain, (Future<TokenEx>)listenableFuture);
    }

    @Override
    public void setTokenForSsoDomain(@Nonnull SsoDomain ssoDomain, @Nonnull SsoDomain ssoDomain2, @Nonnull Future<SamlToken> future) {
        this.doSetTokenForSsoDomain(ssoDomain, ssoDomain2, future);
    }

    private void doSetTokenForSsoDomain(@Nonnull SsoDomain ssoDomain, @Nonnull SsoDomain ssoDomain2, @Nonnull Future<SamlToken> future) {
        Validate.notNull((Object)ssoDomain);
        Validate.notNull((Object)ssoDomain2);
        Validate.notNull(future);
        this._tokensByDomain.put(ssoDomain, new TokenFutureAndIssuerDomain(ssoDomain2, future));
    }

    @Override
    public void acquireAllTokensByToken(SsoDomain ssoDomain, SamlToken samlToken, TokenSpec tokenSpec, SsoDomain ssoDomain2, TokenAcquisitionCallback tokenAcquisitionCallback, Executor executor) throws TokenException {
    }

    @Nonnull
    private static TokenEx getTokenFromFuture(@Nonnull SsoDomain ssoDomain, @Nonnull Future<TokenEx> future) throws TokenException {
        try {
            TokenEx tokenEx = future.get();
            return tokenEx;
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new TokenException("Failed to retrieve token for domain " + ssoDomain, exception);
        }
    }
}

