/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.bindings.type;

import com.vmware.vapi.bindings.convert.ConverterException;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.bindings.type.TypeVisitor;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.data.ConstraintValidator;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructType
implements Type {
    private static final Logger logger = LoggerFactory.getLogger(StructType.class);
    private final String name;
    private final Map<String, Type> fields;
    private final Class<?> bindingClass;
    private final List<ConstraintValidator> validators;
    private final boolean isModel;
    private final List<String> modelKeyFields;
    private final Map<String, FieldInfo> fieldInfos;

    public StructType(String name, Map<String, Type> fields, Class<?> bindingClass, List<ConstraintValidator> validators, boolean isModel, List<String> modelKeyFields, Map<String, FieldNameDetails> fieldNameDetails) {
        Validate.notNull((Object)name);
        Validate.notNull(fields);
        Validate.notNull(bindingClass);
        this.name = name;
        this.fields = Collections.unmodifiableMap(fields);
        this.bindingClass = bindingClass;
        this.isModel = isModel;
        this.modelKeyFields = modelKeyFields;
        this.validators = validators == null ? Collections.emptyList() : validators;
        Map<Object, Object> map = this.fieldInfos = fieldNameDetails == null ? Collections.emptyMap() : this.buildFieldInfoMap(fieldNameDetails);
        if (!this.fieldInfos.isEmpty()) {
            Validate.isTrue((boolean)this.fields.keySet().equals(this.fieldInfos.keySet()));
        }
    }

    private Map<String, FieldInfo> buildFieldInfoMap(Map<String, FieldNameDetails> fieldNameDetails) {
        Method[] methods = this.bindingClass.getMethods();
        HashMap<String, FieldInfo> result = new HashMap<String, FieldInfo>();
        for (Map.Entry<String, FieldNameDetails> entry : fieldNameDetails.entrySet()) {
            Method getter = this.findMethodForName(entry.getValue().getGetterName(), methods);
            this.logWarnIfMethodNotFound(getter, entry.getValue().getGetterName());
            Method setter = this.findMethodForName(entry.getValue().getSetterName(), methods);
            this.logWarnIfMethodNotFound(setter, entry.getValue().getSetterName());
            result.put(entry.getKey(), new FieldInfo(entry.getValue(), getter, setter));
        }
        return result;
    }

    private void logWarnIfMethodNotFound(Method method, String expectedMethodName) {
        if (method == null) {
            logger.warn("Could not reflectively find getter/setter method {} in class {}", (Object)expectedMethodName, (Object)this.bindingClass.getCanonicalName());
        }
    }

    private Method findMethodForName(String methodName, Method[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            return methods[i];
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getFieldNames() {
        return this.fields.keySet();
    }

    public Type getField(String field) {
        Validate.notNull((Object)field);
        return this.fields.get(field);
    }

    public Type getFieldByJavaName(String javaName) {
        Validate.notNull((Object)javaName);
        for (FieldInfo fieldInfo : this.fieldInfos.values()) {
            if (!fieldInfo.getNameDetails().getMixedCaseName().equals(javaName)) continue;
            return this.getField(fieldInfo.getNameDetails().getCanonicalName());
        }
        return null;
    }

    public List<String> getModelKeyFields() {
        if (this.modelKeyFields == null) {
            return null;
        }
        return Collections.unmodifiableList(this.modelKeyFields);
    }

    public Method getGetterMethodForField(String fieldName) {
        Validate.notNull((Object)fieldName);
        FieldInfo fieldInfo = this.getFieldInfo(fieldName);
        if (fieldInfo.getGetterMethod() == null) {
            throw new ConverterException("vapi.bindings.structbinding.struct.missing.getter", fieldInfo.getNameDetails().getGetterName(), this.bindingClass.getClass().getCanonicalName());
        }
        return fieldInfo.getGetterMethod();
    }

    public Method getSetterMethodForField(String fieldName) {
        Validate.notNull((Object)fieldName);
        FieldInfo fieldInfo = this.getFieldInfo(fieldName);
        if (fieldInfo.getSetterMethod() == null) {
            throw new ConverterException("vapi.bindings.structbinding.struct.missing.setter", fieldInfo.getNameDetails().getSetterName(), this.bindingClass.getCanonicalName());
        }
        return fieldInfo.getSetterMethod();
    }

    FieldInfo getFieldInfo(String fieldName) {
        FieldInfo fieldInfo = this.fieldInfos.get(fieldName);
        if (fieldInfo == null) {
            throw new ConverterException("vapi.bindings.structbinding.struct.missing.field.details", fieldName, this.bindingClass.getCanonicalName());
        }
        return fieldInfo;
    }

    public void validate(StructValue structValue) {
        Validate.notNull((Object)structValue);
        for (ConstraintValidator validator : this.validators) {
            validator.validate(structValue);
        }
    }

    public void validate(StructValue structValue, MethodIdentifier methodId) {
        Validate.notNull((Object)methodId);
        this.validate(structValue);
    }

    public Class<?> getBindingClass() {
        return this.bindingClass;
    }

    public boolean isModel() {
        return this.isModel;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    public FieldNameDetails getFieldNameDetails(String canonicalName) {
        FieldInfo fieldInfo = this.fieldInfos.get(canonicalName);
        if (fieldInfo == null) {
            return null;
        }
        return fieldInfo.getNameDetails();
    }

    private static class FieldInfo {
        private FieldNameDetails nameDetails;
        private Method getterMethod;
        private Method setterMethod;

        FieldInfo(FieldNameDetails nameDetails, Method getterMethod, Method setterMethod) {
            this.nameDetails = nameDetails;
            this.getterMethod = getterMethod;
            this.setterMethod = setterMethod;
        }

        FieldNameDetails getNameDetails() {
            return this.nameDetails;
        }

        Method getGetterMethod() {
            return this.getterMethod;
        }

        Method getSetterMethod() {
            return this.setterMethod;
        }
    }

    public static class FieldNameDetails {
        private final String canonicalName;
        private final String mixedCaseName;
        private final String getterName;
        private final String setterName;

        public FieldNameDetails(String canonicalName, String mixedCaseName, String getterName, String setterName) {
            Validate.notEmpty((String)canonicalName);
            Validate.notEmpty((String)mixedCaseName);
            Validate.notEmpty((String)getterName);
            Validate.notEmpty((String)setterName);
            this.canonicalName = canonicalName;
            this.mixedCaseName = mixedCaseName;
            this.getterName = getterName;
            this.setterName = setterName;
        }

        public String getCanonicalName() {
            return this.canonicalName;
        }

        public String getMixedCaseName() {
            return this.mixedCaseName;
        }

        public String getGetterName() {
            return this.getterName;
        }

        public String getSetterName() {
            return this.setterName;
        }
    }
}

