/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.core;

import com.vmware.vapi.core.InterfaceIdentifier;
import org.apache.commons.lang.Validate;

public class MethodIdentifier {
    private static final String METHOD_NAME_DELIMITER = ".";
    private InterfaceIdentifier iface;
    private String method;

    public MethodIdentifier(String path) {
        Validate.notNull((Object)path);
        int index = path.lastIndexOf(METHOD_NAME_DELIMITER);
        if (index == 0) {
            this.iface = new InterfaceIdentifier("");
            this.method = "";
        } else if (index > 0) {
            this.iface = new InterfaceIdentifier(path.substring(0, index));
            this.method = path.substring(index + 1);
        } else {
            this.iface = new InterfaceIdentifier("");
            this.method = path;
        }
    }

    public MethodIdentifier(InterfaceIdentifier iface, String method) {
        Validate.notNull((Object)iface);
        Validate.notNull((Object)method);
        this.iface = iface;
        this.method = method;
    }

    public String getName() {
        return this.method;
    }

    public InterfaceIdentifier getInterfaceIdentifier() {
        return this.iface;
    }

    public String getFullyQualifiedName() {
        return this.iface + METHOD_NAME_DELIMITER + this.method;
    }

    public boolean equals(Object o) {
        if (o instanceof MethodIdentifier) {
            MethodIdentifier tmp = (MethodIdentifier)o;
            return this.method.equals(tmp.method) && this.iface.equals(tmp.iface);
        }
        return false;
    }

    public int hashCode() {
        return this.iface.hashCode() + this.method.hashCode();
    }

    public String toString() {
        return this.iface + METHOD_NAME_DELIMITER + this.method;
    }
}

