/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.data;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.data.BooleanValue;
import com.vmware.vapi.data.DataType;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DoubleValue;
import com.vmware.vapi.data.IntegerValue;
import com.vmware.vapi.data.ListValue;
import com.vmware.vapi.data.SecretValue;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.ValueVisitor;

public final class OptionalValue
implements DataValue {
    public static final OptionalValue UNSET = new OptionalValue();
    private static final long serialVersionUID = 1L;
    private DataValue value;

    private void init(DataValue value) {
        this.value = value;
    }

    public OptionalValue() {
        this.init(null);
    }

    public OptionalValue(DataValue value) {
        this.init(value);
    }

    public OptionalValue(boolean value) {
        this.init(BooleanValue.getInstance(value));
    }

    public OptionalValue(long value) {
        this.init(new IntegerValue(value));
    }

    public OptionalValue(double value) {
        this.init(new DoubleValue(value));
    }

    public OptionalValue(String value) {
        if (value == null) {
            this.init(null);
        } else {
            this.init(new StringValue(value));
        }
    }

    public OptionalValue(char[] value) {
        if (value == null) {
            this.init(null);
        } else {
            this.init(new SecretValue(value));
        }
    }

    public OptionalValue(Boolean value) {
        if (value == null) {
            this.init(null);
        } else {
            this.init(BooleanValue.getInstance(value));
        }
    }

    public OptionalValue(Long value) {
        if (value == null) {
            this.init(null);
        } else {
            this.init(new IntegerValue(value));
        }
    }

    public OptionalValue(Double value) {
        if (value == null) {
            this.init(null);
        } else {
            this.init(new DoubleValue(value));
        }
    }

    @Override
    public DataType getType() {
        return DataType.OPTIONAL;
    }

    public boolean isSet() {
        return this.value != null;
    }

    public DataValue getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o instanceof OptionalValue) {
            OptionalValue opt = (OptionalValue)o;
            if (this.isSet() && opt.isSet()) {
                return this.value.equals(opt.value);
            }
            if (!this.isSet() && !opt.isSet()) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.value != null) {
            return this.value.hashCode();
        }
        return 0;
    }

    public String toString() {
        if (this.value == null) {
            return "<unset>";
        }
        return this.value.toString();
    }

    private long getIntegerInternal(boolean throwOnUnset, long orElse) {
        DataValue value = this.getValue();
        if (this.isSet()) {
            if (value instanceof IntegerValue) {
                IntegerValue tmp = (IntegerValue)value;
                return tmp.getValue();
            }
            throw new CoreException("vapi.data.optional.getvalue.mismatch", "Integer", value.getType().toString());
        }
        if (throwOnUnset) {
            throw new CoreException("vapi.data.optional.getvalue.unset", new String[0]);
        }
        return orElse;
    }

    public long getInteger() {
        return this.getIntegerInternal(true, 0L);
    }

    public long getIntegerOrElse(long orElse) {
        return this.getIntegerInternal(false, orElse);
    }

    public Long getIntegerOrNull() {
        return this.isSet() ? new Long(this.getInteger()) : null;
    }

    private double getDoubleInternal(boolean throwOnUnset, double orElse) {
        DataValue value = this.getValue();
        if (this.isSet()) {
            if (value instanceof DoubleValue) {
                DoubleValue tmp = (DoubleValue)value;
                return tmp.getValue();
            }
            throw new CoreException("vapi.data.optional.getvalue.mismatch", "Double", value.getType().toString());
        }
        if (throwOnUnset) {
            throw new CoreException("vapi.data.optional.getvalue.unset", new String[0]);
        }
        return orElse;
    }

    public double getDouble() {
        return this.getDoubleInternal(true, 0.0);
    }

    public double getDoubleOrElse(double orElse) {
        return this.getDoubleInternal(false, orElse);
    }

    public Double getDoubleOrNull() {
        return this.isSet() ? new Double(this.getDouble()) : null;
    }

    private boolean getBooleanInternal(boolean throwOnUnset, boolean orElse) {
        DataValue value = this.getValue();
        if (this.isSet()) {
            if (value instanceof BooleanValue) {
                BooleanValue tmp = (BooleanValue)value;
                return tmp.getValue();
            }
            throw new CoreException("vapi.data.optional.getvalue.mismatch", "Boolean", value.getType().toString());
        }
        if (throwOnUnset) {
            throw new CoreException("vapi.data.optional.getvalue.unset", new String[0]);
        }
        return orElse;
    }

    public boolean getBoolean() {
        return this.getBooleanInternal(true, true);
    }

    public boolean getBooleanOrElse(boolean orElse) {
        return this.getBooleanInternal(false, orElse);
    }

    public Boolean getBooleanOrNull() {
        return this.isSet() ? Boolean.valueOf(this.getBoolean()) : null;
    }

    private String getStringInternal(boolean throwOnUnset, String orElse) {
        DataValue value = this.getValue();
        if (this.isSet()) {
            if (value instanceof StringValue) {
                return ((StringValue)value).getValue();
            }
            throw new CoreException("vapi.data.optional.getvalue.mismatch", "String", value.getType().toString());
        }
        if (throwOnUnset) {
            throw new CoreException("vapi.data.optional.getvalue.unset", new String[0]);
        }
        return orElse;
    }

    public String getString() {
        return this.getStringInternal(true, "");
    }

    public String getStringOrElse(String orElse) {
        return this.getStringInternal(false, orElse);
    }

    public String getStringOrNull() {
        return this.getStringOrElse(null);
    }

    private char[] getSecretInternal(boolean throwOnUnset, char[] orElse) {
        DataValue value = this.getValue();
        if (this.isSet()) {
            if (value instanceof SecretValue) {
                return ((SecretValue)value).getValue();
            }
            throw new CoreException("vapi.data.optional.getvalue.mismatch", "Secret", value.getType().toString());
        }
        if (throwOnUnset) {
            throw new CoreException("vapi.data.optional.getvalue.unset", new String[0]);
        }
        return orElse;
    }

    public char[] getSecret() {
        return this.getSecretInternal(true, new char[0]);
    }

    public char[] getSecretOrElse(char[] orElse) {
        return this.getSecretInternal(false, orElse);
    }

    public char[] getSecretOrNull() {
        return this.getSecretOrElse(null);
    }

    public OptionalValue getOptional() {
        DataValue value = this.getValue();
        if (!this.isSet()) {
            throw new CoreException("vapi.data.optional.getvalue.unset", new String[0]);
        }
        if (value instanceof OptionalValue) {
            return (OptionalValue)value;
        }
        throw new CoreException("vapi.data.optional.getvalue.mismatch", "Optional", value.getType().toString());
    }

    public ListValue getList() {
        DataValue value = this.getValue();
        if (!this.isSet()) {
            throw new CoreException("vapi.data.optional.getvalue.unset", new String[0]);
        }
        if (value instanceof ListValue) {
            return (ListValue)value;
        }
        throw new CoreException("vapi.data.optional.getvalue.mismatch", "List", value.getType().toString());
    }

    public StructValue getStruct() {
        DataValue value = this.getValue();
        if (!this.isSet()) {
            throw new CoreException("vapi.data.optional.getvalue.unset", new String[0]);
        }
        if (value instanceof StructValue) {
            return (StructValue)value;
        }
        throw new CoreException("vapi.data.optional.getvalue.mismatch", "Struct", value.getType().toString());
    }

    @Override
    public void accept(ValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public OptionalValue copy() {
        return this.value == null ? this : new OptionalValue(this.value.copy());
    }

    private Object readResolve() {
        return this.value == null ? UNSET : this;
    }
}

