/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings;

import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.bindings.convert.ConverterException;
import com.vmware.vapi.bindings.type.OptionalType;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.TypeConverter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class StructValueBuilder {
    private final StructType structType;
    private final TypeConverter converter;
    private final Map<String, Object> fields = new HashMap<String, Object>();

    public StructValueBuilder(StructType structType, TypeConverter converter) {
        Validate.notNull((Object)structType);
        Validate.notNull((Object)converter);
        this.structType = structType;
        this.converter = converter;
    }

    public void addStructField(String name, Object value) {
        this.fields.put(name, value);
    }

    public StructValue getStructValue() {
        StructValue structValue = new StructValue(this.structType.getName());
        for (String name : this.structType.getFieldNames()) {
            Type fieldType = this.structType.getField(name);
            Object fieldBinding = this.fields.get(name);
            if (fieldBinding == null && !(fieldType instanceof OptionalType)) {
                throw new ConverterException(MessageFactory.getMessage("vapi.bindings.structvaluebuilder.operation.parameter.missing", name));
            }
            try {
                DataValue fieldVal = this.converter.convertToVapi(fieldBinding, fieldType);
                structValue.setField(name, fieldVal);
            }
            catch (RuntimeException ex) {
                throw new ConverterException(MessageFactory.getMessage("vapi.bindings.structvaluebuilder.operation.parameter.error", name), (Throwable)ex);
            }
        }
        return structValue;
    }
}

