/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings.convert.impl;

import com.vmware.vapi.bindings.convert.ConverterException;
import com.vmware.vapi.bindings.type.MapType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ListValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.convert.UniTypeConverter;
import com.vmware.vapi.internal.bindings.convert.impl.ConvertUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class JavaUtilMapMapConverter
implements UniTypeConverter<DataValue, MapType> {
    private static final Set<String> MAP_ENTRY_VALUE_FIELDS = new HashSet<String>(Arrays.asList("key", "value"));

    @Override
    public Object fromValue(DataValue value, MapType declaredType, TypeConverter typeConverter) {
        ListValue listValue = ConvertUtil.narrowType(value, ListValue.class);
        Type keyType = declaredType.getKeyType();
        Type valueType = declaredType.getValueType();
        HashMap mapBinding = new HashMap();
        for (DataValue elementVal : listValue) {
            if (!(elementVal instanceof StructValue)) {
                throw new ConverterException("vapi.bindings.typeconverter.map.unexpected.key.value.entry", new String[0]);
            }
            StructValue structVal = (StructValue)elementVal;
            if (!MAP_ENTRY_VALUE_FIELDS.equals(structVal.getFieldNames())) {
                throw new ConverterException("vapi.bindings.typeconverter.map.unexpected.key.value.entry", new String[0]);
            }
            Object key = typeConverter.convertToJava(structVal.getField("key"), keyType);
            Object val = typeConverter.convertToJava(structVal.getField("value"), valueType);
            if (mapBinding.containsKey(key)) {
                throw new ConverterException("vapi.bindings.typeconverter.map.duplicate.element", new String[0]);
            }
            mapBinding.put(key, val);
        }
        return mapBinding;
    }

    @Override
    public DataValue toValue(Object binding, MapType declaredType, TypeConverter typeConverter) {
        Map mapBinding = ConvertUtil.narrowType(binding, Map.class);
        Type keyType = declaredType.getKeyType();
        Type valueType = declaredType.getValueType();
        ListValue mapValue = new ListValue();
        for (Map.Entry elem : mapBinding.entrySet()) {
            StructValue entry = new StructValue("map-entry");
            DataValue key = typeConverter.convertToVapi(elem.getKey(), keyType);
            DataValue val = typeConverter.convertToVapi(elem.getValue(), valueType);
            entry.setField("key", key);
            entry.setField("value", val);
            mapValue.add(entry);
        }
        return mapValue;
    }
}

