/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings.convert.impl;

import com.vmware.vapi.bindings.convert.ConverterException;
import com.vmware.vapi.bindings.type.EnumType;
import com.vmware.vapi.bindings.type.IdType;
import com.vmware.vapi.bindings.type.MapType;
import com.vmware.vapi.bindings.type.StringType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.bindings.type.UriType;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.convert.UniTypeConverter;
import com.vmware.vapi.internal.bindings.convert.impl.ConvertUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaUtilMapStructValueMapConverter
implements UniTypeConverter<DataValue, MapType> {
    private final List<Class<? extends Type>> supportedKeyTypes = Arrays.asList(StringType.class, IdType.class, EnumType.class, UriType.class);

    @Override
    public Object fromValue(DataValue value, MapType declaredType, TypeConverter typeConverter) {
        StructValue structValue = ConvertUtil.narrowType(value, StructValue.class);
        this.ensureStringKeyType(declaredType.getKeyType());
        Type valueType = declaredType.getValueType();
        HashMap mapBinding = new HashMap();
        for (String fieldName : structValue.getFieldNames()) {
            Object val = typeConverter.convertToJava(structValue.getField(fieldName), valueType);
            mapBinding.put(fieldName, val);
        }
        return mapBinding;
    }

    @Override
    public DataValue toValue(Object binding, MapType declaredType, TypeConverter typeConverter) {
        Map mapBinding = ConvertUtil.narrowType(binding, Map.class);
        this.ensureStringKeyType(declaredType.getKeyType());
        Type valueType = declaredType.getValueType();
        StructValue mapValue = new StructValue("map-struct");
        for (Map.Entry elem : mapBinding.entrySet()) {
            String key = ConvertUtil.narrowType(elem.getKey(), String.class);
            DataValue val = typeConverter.convertToVapi(elem.getValue(), valueType);
            mapValue.setField(key, val);
        }
        return mapValue;
    }

    private void ensureStringKeyType(Type keyType) {
        if (!this.supportedKeyTypes.contains(keyType.getClass())) {
            StringBuilder supportedTypes = new StringBuilder();
            supportedTypes.append(StringType.class.getSimpleName()).append(", ");
            supportedTypes.append(IdType.class.getSimpleName()).append(", ");
            supportedTypes.append(EnumType.class.getSimpleName()).append(" or ");
            supportedTypes.append(UriType.class.getSimpleName());
            throw new ConverterException("vapi.bindings.typeconverter.unexpected.type", supportedTypes.toString(), keyType.getClass().getSimpleName());
        }
    }
}

