/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.dsig.json;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.dsig.json.SignatureException;
import com.vmware.vapi.internal.dsig.json.CanonicalizationUtil;
import com.vmware.vapi.internal.dsig.json.Canonicalizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.Validate;

public final class JsonCanonicalizer
implements Canonicalizer {
    private static final Message CANONICALIZATION_ERROR = MessageFactory.getMessage("vapi.signature.canonicalization", new String[0]);

    @Override
    public String asCanonicalString(String message) {
        JsonNode root;
        Validate.notNull((Object)message);
        ObjectMapper m = new ObjectMapper();
        SimpleModule module = new SimpleModule("Custom serializer", new Version(1, 0, 0, null, null, null));
        module.addSerializer((JsonSerializer)new DoubleSerializer());
        m.registerModule((Module)module);
        Object canonicalizedForm = root = this.parseToTree(message, m);
        if (root.isObject()) {
            canonicalizedForm = this.canonicalizeObject(root);
        } else if (root.isArray()) {
            canonicalizedForm = this.canonicalizeArray(root);
        }
        return this.serializeToString(m, canonicalizedForm);
    }

    private TreeMap<String, Object> canonicalizeObject(JsonNode jsonObject) {
        assert (jsonObject != null);
        TreeMap<String, Object> sorted = new TreeMap<String, Object>();
        Iterator fieldsIterator = jsonObject.fields();
        while (fieldsIterator.hasNext()) {
            Map.Entry nextField = (Map.Entry)fieldsIterator.next();
            String key = (String)nextField.getKey();
            JsonNode value = (JsonNode)nextField.getValue();
            if (value.isArray()) {
                sorted.put(key, this.canonicalizeArray(value));
                continue;
            }
            if (value.isObject()) {
                sorted.put(key, this.canonicalizeObject(value));
                continue;
            }
            sorted.put(key, value);
        }
        return sorted;
    }

    private List<Object> canonicalizeArray(JsonNode jsonArray) {
        assert (jsonArray != null);
        ArrayList<Object> sorted = new ArrayList<Object>();
        for (JsonNode element : jsonArray) {
            if (element.isArray()) {
                sorted.add(this.canonicalizeArray(element));
                continue;
            }
            if (element.isObject()) {
                sorted.add(this.canonicalizeObject(element));
                continue;
            }
            sorted.add(element);
        }
        return sorted;
    }

    private String serializeToString(ObjectMapper mapper, Object canonicalizedForm) {
        String result;
        assert (mapper != null && canonicalizedForm != null);
        try {
            result = mapper.writeValueAsString(canonicalizedForm);
        }
        catch (JsonGenerationException e) {
            throw new SignatureException(CANONICALIZATION_ERROR, (Throwable)e);
        }
        catch (JsonMappingException e) {
            throw new SignatureException(CANONICALIZATION_ERROR, (Throwable)e);
        }
        catch (IOException e) {
            throw new SignatureException(CANONICALIZATION_ERROR, (Throwable)e);
        }
        return result;
    }

    private JsonNode parseToTree(String message, ObjectMapper mapper) {
        JsonNode root;
        assert (message != null && mapper != null);
        try {
            root = mapper.readTree(message);
        }
        catch (IOException e) {
            throw new SignatureException(CANONICALIZATION_ERROR, (Throwable)e);
        }
        return root;
    }

    private static final class DoubleSerializer
    extends StdSerializer<DoubleNode> {
        protected DoubleSerializer() {
            super(DoubleNode.class);
        }

        public void serialize(DoubleNode value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            double doubleValue = value.asDouble();
            jgen.writeNumber(CanonicalizationUtil.canonicalizeDouble(doubleValue));
        }
    }
}

