/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http;

import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheClientHeadersProvider;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheHttpUtil;
import com.vmware.vapi.internal.protocol.client.rpc.http.SslClientUtil;
import com.vmware.vapi.protocol.HttpConfiguration;
import com.vmware.vise.aspect.vapi.runtime.thread.ApacheBioHttpClientBuilderAspect;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;

public class ApacheBioHttpClientBuilder {
    private static final String HTTP_SHEME = "http";
    private static final String HTTPS_SHEME = "https";
    private PoolingHttpClientConnectionManager connManager;

    public Thread buildConnectionMonitorThread(Logger logger) {
        return new ConnectionMonitor(this.connManager, logger);
    }

    public CloseableHttpClient buildAndConfigure(final HttpConfiguration httpConfig) {
        this.connManager = this.createConnectionManager(httpConfig);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(httpConfig.getSoTimeout()).setConnectTimeout(httpConfig.getConnectTimeout()).build();
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connManager).setUserAgent(ApacheHttpUtil.VAPI_USER_AGENT).setDefaultRequestConfig(requestConfig);
        builder.setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                return httpConfig.getKeepAlivePeriod();
            }
        });
        builder.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        HttpConfiguration.HeadersProvider headersProvider = httpConfig.getHeadersProvider();
        if (headersProvider != null) {
            builder.addInterceptorFirst((HttpRequestInterceptor)new ApacheClientHeadersProvider(headersProvider));
        }
        return builder.build();
    }

    private PoolingHttpClientConnectionManager createConnectionManager(HttpConfiguration httpConfig) {
        Registry<ConnectionSocketFactory> registry = this.createConnectionSocketFactoryRegistry(httpConfig.getSslConfiguration());
        PoolingHttpClientConnectionManager result = new PoolingHttpClientConnectionManager(registry);
        result.setMaxTotal(httpConfig.getMaxConnections());
        result.setDefaultMaxPerRoute(httpConfig.getMaxConnections());
        return result;
    }

    private Registry<ConnectionSocketFactory> createConnectionSocketFactoryRegistry(HttpConfiguration.SslConfiguration sslConfig) {
        X509HostnameVerifier hostnameVerifier = SslClientUtil.createHostnameVerifier(sslConfig.isHostnameVerificationDisabled(), SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER);
        return RegistryBuilder.create().register(HTTP_SHEME, (Object)PlainConnectionSocketFactory.INSTANCE).register(HTTPS_SHEME, (Object)new SSLConnectionSocketFactory(SslClientUtil.createSslContext(sslConfig), sslConfig.getEnabledProtocols(), sslConfig.getEnabledCipherSuites(), hostnameVerifier)).build();
    }

    public static final class ConnectionMonitor
    extends Thread {
        private static final String THREAD_NAME = "vAPI-client-connection-monitor-%d";
        private static final AtomicInteger threadCount;
        private final PoolingHttpClientConnectionManager connManager;
        private final Logger logger;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        ConnectionMonitor(PoolingHttpClientConnectionManager connManager, Logger logger) {
            super(String.format(THREAD_NAME, threadCount.getAndIncrement()));
            PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = connManager;
            Logger logger2 = logger;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)poolingHttpClientConnectionManager, (Object)logger2);
            assert (connManager != null);
            this.connManager = connManager;
            this.logger = logger;
            this.setDaemon(true);
            ApacheBioHttpClientBuilderAspect.aspectOf().logStackTrace(joinPoint);
        }

        @Override
        public void run() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            ConnectionMonitor.run_aroundBody1$advice(this, joinPoint, ApacheBioHttpClientBuilderAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
        }

        static {
            ConnectionMonitor.ajc$preClinit();
            threadCount = new AtomicInteger();
        }

        private static final /* synthetic */ void run_aroundBody0(ConnectionMonitor ajc$this, JoinPoint joinPoint) {
            try {
                while (!ajc$this.isInterrupted()) {
                    ConnectionMonitor.sleep(10000L);
                    ajc$this.connManager.closeExpiredConnections();
                }
            }
            catch (InterruptedException e) {
                ajc$this.logger.debug("Interrupted, no more connection pool cleanups will be performed.");
            }
        }

        private static final /* synthetic */ Object run_aroundBody1$advice(ConnectionMonitor ajc$this, JoinPoint thisJoinPoint, ApacheBioHttpClientBuilderAspect ajc$aspectInstance, ProceedingJoinPoint joinPoint) {
            String threadName = Thread.currentThread().getName();
            try {
                Object result;
                ApacheBioHttpClientBuilderAspect.ajc$inlineAccessFieldGet$com_vmware_vise_aspect_vapi_runtime_thread_ApacheBioHttpClientBuilderAspect$com_vmware_vise_aspect_vapi_runtime_thread_ApacheBioHttpClientBuilderAspect$_logger().info((Object)(String.valueOf(threadName) + " thread started..."));
                ProceedingJoinPoint proceedingJoinPoint = joinPoint;
                ConnectionMonitor.run_aroundBody0(ajc$this, (JoinPoint)proceedingJoinPoint);
                Object var7_7 = result = null;
                return var7_7;
            }
            finally {
                ApacheBioHttpClientBuilderAspect.ajc$inlineAccessFieldGet$com_vmware_vise_aspect_vapi_runtime_thread_ApacheBioHttpClientBuilderAspect$com_vmware_vise_aspect_vapi_runtime_thread_ApacheBioHttpClientBuilderAspect$_logger().info((Object)(String.valueOf(threadName) + " thread ended."));
            }
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("ApacheBioHttpClientBuilder.java", ConnectionMonitor.class);
            ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("0", "com.vmware.vapi.internal.protocol.client.rpc.http.ApacheBioHttpClientBuilder$ConnectionMonitor", "org.apache.http.impl.conn.PoolingHttpClientConnectionManager:org.slf4j.Logger", "connManager:logger", ""), 152);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "com.vmware.vapi.internal.protocol.client.rpc.http.ApacheBioHttpClientBuilder$ConnectionMonitor", "", "", "", "void"), 161);
        }
    }
}

