/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http;

import com.vmware.vapi.internal.protocol.client.rpc.HttpResponse;
import com.vmware.vapi.internal.protocol.client.rpc.http.Utils;
import com.vmware.vapi.internal.util.io.IoUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;

public class ApacheHttpResponse
implements HttpResponse {
    private final org.apache.http.HttpResponse response;

    public ApacheHttpResponse(org.apache.http.HttpResponse response) {
        this.response = response;
    }

    @Override
    public int getStatusCode() {
        StatusLine statusLine = this.response.getStatusLine();
        if (statusLine != null) {
            return statusLine.getStatusCode();
        }
        throw new RuntimeException();
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        for (Header header : this.response.getAllHeaders()) {
            Utils.addListEntryToMapOfLists(header.getName(), header.getValue(), headers);
        }
        return headers;
    }

    @Override
    public byte[] getBody() {
        HttpEntity entity = this.response.getEntity();
        if (entity != null) {
            try {
                return IoUtil.readAll(entity.getContent());
            }
            catch (IllegalStateException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

