/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http;

import com.vmware.vapi.internal.protocol.client.rpc.HttpRequest;
import com.vmware.vapi.internal.protocol.client.rpc.http.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class HttpRequestImpl
implements HttpRequest {
    private String url;
    private HttpRequest.HttpMethod method;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private byte[] body;

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        Validate.notNull((Object)url);
        this.url = url;
    }

    @Override
    public HttpRequest.HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(HttpRequest.HttpMethod method) {
        Validate.notNull((Object)((Object)method));
        this.method = method;
    }

    @Override
    public byte[] getBody() {
        return this.body;
    }

    @Override
    public void setBody(byte[] body) {
        this.body = body;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    @Override
    public void addHeader(String name, String value) {
        Validate.notNull((Object)name);
        Validate.notNull((Object)value);
        Utils.addListEntryToMapOfLists(name, value, this.headers);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.body);
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpRequestImpl other = (HttpRequestImpl)obj;
        if (!Arrays.equals(this.body, other.body)) {
            return false;
        }
        if (this.headers == null ? other.headers != null : !this.headers.equals(other.headers)) {
            return false;
        }
        if (this.method != other.method) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }
}

