/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http;

import com.vmware.vapi.client.exception.SslException;
import com.vmware.vapi.internal.protocol.client.rpc.http.AllowAllHostnameVerifier;
import com.vmware.vapi.internal.protocol.client.rpc.http.KeyManagerWrapper;
import com.vmware.vapi.internal.protocol.client.rpc.http.TrustAllX509TrustManager;
import com.vmware.vapi.internal.protocol.client.rpc.http.VapiHostnameVerifier;
import com.vmware.vapi.protocol.HttpConfiguration;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.PKIXBuilderParameters;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.commons.lang.Validate;
import org.apache.http.conn.ssl.X509HostnameVerifier;

public final class SslClientUtil {
    private SslClientUtil() {
    }

    public static SSLContext createSslContext(HttpConfiguration.SslConfiguration sslConfig) {
        Validate.notNull((Object)sslConfig);
        try {
            SSLContext sslCtx = SSLContext.getInstance("TLS");
            KeyManager[] keyManagers = SslClientUtil.createKeyManagers(sslConfig);
            TrustManager[] trustManagers = null;
            if (sslConfig.isCertificateValidationDisabled()) {
                trustManagers = new TrustManager[]{new TrustAllX509TrustManager()};
            } else {
                String trustAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
                TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(trustAlgorithm);
                if (sslConfig.getCrlCertStore() == null) {
                    trustFactory.init(sslConfig.getTrustStore());
                } else {
                    PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(sslConfig.getTrustStore(), null);
                    pkixParams.setRevocationEnabled(true);
                    pkixParams.addCertStore(sslConfig.getCrlCertStore());
                    trustFactory.init(new CertPathTrustManagerParameters(pkixParams));
                }
                trustManagers = trustFactory.getTrustManagers();
            }
            sslCtx.init(keyManagers, trustManagers, null);
            return sslCtx;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SslException(ex);
        }
        catch (KeyStoreException ex) {
            throw new SslException(ex);
        }
        catch (KeyManagementException ex) {
            throw new SslException(ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new SslException(ex);
        }
    }

    protected static KeyManager[] createKeyManagers(HttpConfiguration.SslConfiguration sslConfig) {
        if (sslConfig.getKeyStore() == null || sslConfig.getKeyStoreConfig() == null) {
            return null;
        }
        String password = sslConfig.getKeyStoreConfig().getKeyStorePassword();
        String alias = sslConfig.getKeyStoreConfig().getKeyAlias();
        try {
            if (password != null && alias != null) {
                KeyStore store = sslConfig.getKeyStore();
                KeyManagerFactory keyMngrFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyMngrFactory.init(store, password.toCharArray());
                KeyManager[] keyManagers = keyMngrFactory.getKeyManagers();
                for (int i = 0; i < keyManagers.length; ++i) {
                    if (!(keyManagers[i] instanceof X509KeyManager)) continue;
                    keyManagers[i] = new KeyManagerWrapper((X509KeyManager)keyManagers[i], alias);
                }
                return keyManagers;
            }
        }
        catch (Exception e) {
            throw new SslException("Unable to create KeyManagers", e);
        }
        return null;
    }

    static String stripHostnameBrackets(String hostname) {
        if (hostname != null && hostname.startsWith("[") && hostname.endsWith("]")) {
            try {
                return InetAddress.getByName(hostname).getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return hostname;
    }

    static X509HostnameVerifier createHostnameVerifier(boolean isHostnameVerificationDisabled, X509HostnameVerifier delegate) {
        return isHostnameVerificationDisabled ? new AllowAllHostnameVerifier() : new VapiHostnameVerifier(delegate);
    }
}

