/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.server.rpc.http.util;

import com.vmware.vapi.internal.protocol.server.rpc.http.common.impl.ThumbprintTrustManager;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;

public final class SslUtil {
    private SslUtil() {
    }

    public static void addCertTrustedAttribute(HttpServletRequest request, ThumbprintTrustManager trustManager) {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        boolean isTrusted = false;
        if (null != certs && certs.length > 0 && trustManager != null) {
            isTrusted = trustManager.isClientTrusted(certs, SslUtil.determineAuthType(certs[0]));
        }
        request.setAttribute("javax.servlet.request.X509CertificateIsTrusted", (Object)isTrusted);
    }

    private static String determineAuthType(X509Certificate cert) {
        PublicKey key = cert.getPublicKey();
        return key.getAlgorithm();
    }
}

