/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.provider.introspection;

import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ErrorValueException;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.InterfaceDefinition;
import com.vmware.vapi.core.InterfaceIdentifier;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataDefinition;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ListDefinition;
import com.vmware.vapi.data.StringDefinition;
import com.vmware.vapi.data.StructDefinition;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.provider.introspection.ApiIntrospectionMethodBase;
import com.vmware.vapi.internal.provider.introspection.IntrospectionAsyncHandle;
import com.vmware.vapi.internal.provider.introspection.IntrospectionDataFactory;
import com.vmware.vapi.internal.provider.introspection.SyncToAsyncApiIntrospectionAdapter;
import com.vmware.vapi.provider.ApiMethodBasedApiInterface;
import com.vmware.vapi.provider.introspection.ApiIntrospection;
import com.vmware.vapi.provider.introspection.IntrospectionConstants;
import com.vmware.vapi.provider.introspection.SyncApiIntrospection;
import com.vmware.vapi.std.StandardDataFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.lang.Validate;

public class OperationIntrospectionService
extends ApiMethodBasedApiInterface {
    public OperationIntrospectionService(ApiIntrospection introspection) {
        super(IntrospectionConstants.OPERATION_INTROSPECTION_SERVICE_ID);
        Validate.notNull((Object)introspection);
        this.registerMethod(new GetApiMethod(introspection));
        this.registerMethod(new ListApiMethod(introspection));
    }

    public OperationIntrospectionService(SyncApiIntrospection introspection) {
        this(new SyncToAsyncApiIntrospectionAdapter(introspection));
    }

    private static class ListApiMethod
    extends ApiIntrospectionMethodBase {
        private static final DataDefinition INPUT_DEF = new StructDefinition("operation-input", Collections.singletonMap("service_id", StringDefinition.getInstance()));
        private static final DataDefinition OUTPUT_DEF = new ListDefinition(StringDefinition.getInstance());

        public ListApiMethod(ApiIntrospection introspection) {
            super(IntrospectionDataFactory.OPERATION_LIST_METHOD_ID, INPUT_DEF, OUTPUT_DEF, Collections.singleton(IntrospectionDataFactory.NOT_FOUND_ERROR_INFO_DEF), introspection);
        }

        @Override
        public void invoke(InvocationContext invocationContext, DataValue input, AsyncHandle<MethodResult> asyncHandle) {
            StructValue inputStruct = (StructValue)input;
            final String ifaceId = inputStruct.getString("service_id");
            ExecutionContext executionContext = invocationContext.getExecutionContext();
            this.introspection.getInterface(executionContext, new InterfaceIdentifier(ifaceId), (AsyncHandle<InterfaceDefinition>)new IntrospectionAsyncHandle<InterfaceDefinition>(asyncHandle){

                @Override
                protected DataValue convert(InterfaceDefinition result) {
                    if (result != null) {
                        return IntrospectionDataFactory.toMethodIdList(result);
                    }
                    Message errorMsg = MessageFactory.getMessage("vapi.introspection.operation.service.not_found", ifaceId);
                    throw new ErrorValueException(StandardDataFactory.createErrorValueForMessages(IntrospectionDataFactory.NOT_FOUND_ERROR_INFO_DEF, Arrays.asList(errorMsg)));
                }
            });
        }
    }

    private static class GetApiMethod
    extends ApiIntrospectionMethodBase {
        private static final DataDefinition INPUT_DEF;
        private static final DataDefinition OUTPUT_DEF;

        public GetApiMethod(ApiIntrospection introspection) {
            super(IntrospectionDataFactory.OPERATION_GET_METHOD_ID, INPUT_DEF, OUTPUT_DEF, Collections.singleton(IntrospectionDataFactory.NOT_FOUND_ERROR_INFO_DEF), introspection);
        }

        @Override
        public void invoke(InvocationContext invocationContext, DataValue input, AsyncHandle<MethodResult> asyncHandle) {
            final ExecutionContext executionContext = invocationContext.getExecutionContext();
            StructValue inputStruct = (StructValue)input;
            final String ifaceId = inputStruct.getString("service_id");
            final String methodId = inputStruct.getString("operation_id");
            final InterfaceIdentifier serviceId = new InterfaceIdentifier(ifaceId);
            MethodIdentifier method = new MethodIdentifier(serviceId, methodId);
            final IntrospectionAsyncHandle<InterfaceDefinition> ifaceCb = new IntrospectionAsyncHandle<InterfaceDefinition>(asyncHandle){

                @Override
                public void updateProgress(DataValue progress) {
                }

                @Override
                protected DataValue convert(InterfaceDefinition result) {
                    if (result == null) {
                        Message errorMsg = MessageFactory.getMessage("vapi.introspection.operation.service.not_found", ifaceId);
                        throw new ErrorValueException(StandardDataFactory.createErrorValueForMessages(IntrospectionDataFactory.NOT_FOUND_ERROR_INFO_DEF, Arrays.asList(errorMsg)));
                    }
                    Message errorMsg = MessageFactory.getMessage("vapi.introspection.operation.not_found", methodId, ifaceId);
                    throw new ErrorValueException(StandardDataFactory.createErrorValueForMessages(IntrospectionDataFactory.NOT_FOUND_ERROR_INFO_DEF, Arrays.asList(errorMsg)));
                }
            };
            IntrospectionAsyncHandle<MethodDefinition> methodCb = new IntrospectionAsyncHandle<MethodDefinition>(asyncHandle){

                @Override
                protected DataValue convert(MethodDefinition result) {
                    if (result != null) {
                        return IntrospectionDataFactory.toOperationInfo(result);
                    }
                    GetApiMethod.this.introspection.getInterface(executionContext, serviceId, ifaceCb);
                    return null;
                }
            };
            this.introspection.getMethod(executionContext, method, (AsyncHandle<MethodDefinition>)methodCb);
        }

        static {
            HashMap<String, DataDefinition> fields = new HashMap<String, DataDefinition>();
            fields.put("service_id", StringDefinition.getInstance());
            fields.put("operation_id", StringDefinition.getInstance());
            INPUT_DEF = new StructDefinition("operation-input", fields);
            OUTPUT_DEF = IntrospectionDataFactory.OPERATION_INFO_DEF;
        }
    }
}

