/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.provider.introspection;

import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.core.ProviderDefinition;
import com.vmware.vapi.data.DataDefinition;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.StructDefinition;
import com.vmware.vapi.internal.provider.introspection.ApiIntrospectionMethodBase;
import com.vmware.vapi.internal.provider.introspection.IntrospectionAsyncHandle;
import com.vmware.vapi.internal.provider.introspection.IntrospectionDataFactory;
import com.vmware.vapi.internal.provider.introspection.SyncToAsyncApiIntrospectionAdapter;
import com.vmware.vapi.provider.ApiMethodBasedApiInterface;
import com.vmware.vapi.provider.introspection.ApiIntrospection;
import com.vmware.vapi.provider.introspection.IntrospectionConstants;
import com.vmware.vapi.provider.introspection.SyncApiIntrospection;
import java.util.Collections;
import org.apache.commons.lang.Validate;

public class ProviderIntrospectionService
extends ApiMethodBasedApiInterface {
    public ProviderIntrospectionService(ApiIntrospection introspection) {
        super(IntrospectionConstants.PROVIDER_INTROSPECTION_SERVICE_ID);
        Validate.notNull((Object)introspection);
        this.registerMethod(new GetApiMethod(introspection));
    }

    public ProviderIntrospectionService(SyncApiIntrospection introspection) {
        this(new SyncToAsyncApiIntrospectionAdapter(introspection));
    }

    private static class GetApiMethod
    extends ApiIntrospectionMethodBase {
        private static final DataDefinition INPUT_DEF = new StructDefinition("operation-input", Collections.emptyMap());
        private static final DataDefinition OUTPUT_DEF = IntrospectionDataFactory.PROVIDER_INFO_DEF;

        public GetApiMethod(ApiIntrospection introspection) {
            super(IntrospectionDataFactory.PROVIDER_GET_METHOD_ID, INPUT_DEF, OUTPUT_DEF, null, introspection);
        }

        @Override
        public void invoke(InvocationContext invocationContext, DataValue input, AsyncHandle<MethodResult> asyncHandle) {
            ExecutionContext executionContext = invocationContext.getExecutionContext();
            this.introspection.getDefinition(executionContext, (AsyncHandle<ProviderDefinition>)new IntrospectionAsyncHandle<ProviderDefinition>(asyncHandle){

                @Override
                protected DataValue convert(ProviderDefinition result) {
                    return IntrospectionDataFactory.toProviderInfo(result);
                }
            });
        }
    }
}

