/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.protocol.server.rpc.http.impl;

import com.vmware.vapi.internal.diagnostics.DiagnosticsKey;
import com.vmware.vapi.internal.protocol.common.http.FrameSerializer;
import com.vmware.vapi.internal.protocol.common.http.impl.ChunkedTransferEncodingFrameSerializer;
import com.vmware.vapi.internal.util.io.IoUtil;
import com.vmware.vapi.protocol.server.rpc.RequestReceiver;
import com.vmware.vapi.protocol.server.rpc.http.MediaTypeResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpStreamingServlet
extends HttpServlet {
    private static final long serialVersionUID = 0L;
    private static final Logger logger = LoggerFactory.getLogger(HttpStreamingServlet.class);
    private static final String NUM_REQUESTS_COUNTER = "numRequestsCounter";
    private final MediaTypeResolver mediaTypeResolver;
    private final long asyncTimeout;

    public HttpStreamingServlet(MediaTypeResolver mediaTypeResolver) {
        this(mediaTypeResolver, -1L);
    }

    public HttpStreamingServlet(MediaTypeResolver mediaTypeResolver, long asyncTimeout) {
        Validate.notNull((Object)mediaTypeResolver);
        this.mediaTypeResolver = mediaTypeResolver;
        this.asyncTimeout = asyncTimeout;
        DiagnosticsKey key = new DiagnosticsKey(((Object)((Object)this)).getClass().getName(), new String[]{NUM_REQUESTS_COUNTER});
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.doPostImpl(request, response);
        }
        catch (ServletException ex) {
            logger.error("Servlet error while processing POST request", (Throwable)ex);
            throw ex;
        }
        catch (IOException ex) {
            logger.error("I/O error while processing POST request", (Throwable)ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            logger.error("Unexpected error while processing POST request", (Throwable)ex);
            throw ex;
        }
    }

    private void doPostImpl(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logRequest(request);
        String contentType = request.getContentType();
        if (contentType == null) {
            throw new ServletException("Missing Content-Type header");
        }
        String mediaType = HttpStreamingServlet.getMediaType(contentType);
        RequestReceiver msgProtocol = this.mediaTypeResolver.getHandler(mediaType);
        if (msgProtocol == null) {
            throw new ServletException("Unexpected Content-Type: " + request.getContentType());
        }
        AsyncContext servletAsyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        servletAsyncContext.setTimeout(this.asyncTimeout);
        msgProtocol.requestReceived((InputStream)request.getInputStream(), HttpStreamingServlet.createTransport(request, servletAsyncContext));
    }

    static String getMediaType(String contentType) {
        String mediaType = contentType;
        int semicolon = mediaType.indexOf(59);
        if (semicolon >= 0) {
            mediaType = mediaType.substring(0, semicolon).trim();
        }
        return mediaType;
    }

    private void logRequest(HttpServletRequest request) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        logger.debug(String.format("Received request from agent '%s' with content-length %s, content-type '%s' and accept header '%s'", request.getHeader("User-Agent"), request.getContentLength(), request.getContentType(), request.getHeader("Accept")));
    }

    private static RequestReceiver.TransportContext createTransport(HttpServletRequest request, AsyncContext servletAsyncContext) {
        RequestReceiver.RequestContext requestContext = HttpStreamingServlet.buildRequestContext(request);
        String acceptHeader = request.getHeader("Accept");
        if (acceptHeader == null) {
            acceptHeader = "application/json";
        }
        boolean clientAcceptsSingleFrame = acceptHeader.contains("application/json");
        boolean clientAcceptsMultiFrame = acceptHeader.contains("application/vnd.vmware.vapi.framed");
        if (clientAcceptsSingleFrame && clientAcceptsMultiFrame) {
            return new AdaptiveTransport(servletAsyncContext, requestContext);
        }
        if (clientAcceptsMultiFrame) {
            return new MultiFrameTransport(servletAsyncContext, requestContext);
        }
        return new SingleFrameTransport(servletAsyncContext, requestContext);
    }

    private static RequestReceiver.RequestContext buildRequestContext(HttpServletRequest servletRequest) {
        final String userAgent = servletRequest.getHeader("User-Agent");
        return new RequestReceiver.RequestContext(){

            @Override
            public String getUserAgent() {
                return userAgent;
            }
        };
    }

    private static class AdaptiveTransport
    extends BaseTransport {
        private RequestReceiver.TransportContext decorated;

        public AdaptiveTransport(AsyncContext servletAsyncContext, RequestReceiver.RequestContext requestContext) {
            super(servletAsyncContext, requestContext);
        }

        @Override
        public synchronized void send(InputStream response, int responseLength, boolean isFinal) throws IOException {
            if (this.decorated == null) {
                this.decorated = isFinal ? new SingleFrameTransport(this.servletAsyncContext, this.getRequestContext()) : new MultiFrameTransport(this.servletAsyncContext, this.getRequestContext());
            }
            this.decorated.send(response, responseLength, isFinal);
        }
    }

    private static class MultiFrameTransport
    extends BaseTransport {
        private static final FrameSerializer frameSerializer = new ChunkedTransferEncodingFrameSerializer();

        public MultiFrameTransport(AsyncContext servletAsyncContext, RequestReceiver.RequestContext requestContext) {
            super(servletAsyncContext, requestContext);
        }

        @Override
        public synchronized void send(InputStream response, int responseLength, boolean isFinal) throws IOException {
            this.servletAsyncContext.getResponse().setContentType("application/vnd.vmware.vapi.framed");
            ServletOutputStream out = this.servletAsyncContext.getResponse().getOutputStream();
            byte[] responseFrame = IoUtil.readAll(response);
            frameSerializer.writeFrame((OutputStream)out, responseFrame);
            out.flush();
            if (isFinal) {
                this.servletAsyncContext.complete();
            }
        }
    }

    private static class SingleFrameTransport
    extends BaseTransport {
        public SingleFrameTransport(AsyncContext servletAsyncContext, RequestReceiver.RequestContext requestContext) {
            super(servletAsyncContext, requestContext);
        }

        @Override
        public synchronized void send(InputStream response, int responseLength, boolean isFinal) throws IOException {
            if (!isFinal) {
                return;
            }
            this.servletAsyncContext.getResponse().setContentType("application/json");
            ServletOutputStream out = this.servletAsyncContext.getResponse().getOutputStream();
            IoUtil.copy(response, (OutputStream)out);
            out.flush();
            this.servletAsyncContext.complete();
        }
    }

    private static abstract class BaseTransport
    implements RequestReceiver.TransportContext {
        protected final AsyncContext servletAsyncContext;
        protected final RequestReceiver.RequestContext requestContext;

        protected BaseTransport(AsyncContext servletAsyncContext, RequestReceiver.RequestContext requestContext) {
            this.servletAsyncContext = servletAsyncContext;
            this.requestContext = requestContext;
        }

        @Override
        public RequestReceiver.RequestContext getRequestContext() {
            return this.requestContext;
        }
    }
}

