/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis;

import com.vmware.cis.TasksDefinitions;
import com.vmware.cis.TasksProvider;
import com.vmware.cis.TasksTypes;
import com.vmware.cis.task.Info;
import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class TasksApiInterface
extends ApiInterfaceSkeleton {
    private TasksProvider impl;

    public TasksApiInterface() {
        this((Class<? extends TasksProvider>)null);
    }

    public TasksApiInterface(Class<? extends TasksProvider> implClass) {
        this((TasksProvider)TasksApiInterface.createImplInstance(implClass, (String)"com.vmware.cis.impl.TasksImpl", TasksProvider.class));
    }

    public TasksApiInterface(TasksProvider impl) {
        super("com.vmware.cis.tasks");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new CancelApiMethod());
    }

    private class CancelApiMethod
    extends ApiMethodSkeleton {
        public CancelApiMethod() {
            super(TasksApiInterface.this.getIdentifier(), "cancel", TasksDefinitions.__cancelInput, TasksDefinitions.__cancelOutput, TasksApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.error;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.resourceInaccessible;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.serviceUnavailable;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthenticated;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unsupported;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, TasksDefinitions.__cancelInput, TasksApiInterface.this.getTypeConverter());
            String task = (String)extr.valueForField("task");
            TasksApiInterface.this.impl.cancel(task, (AsyncContext<Void>)new AsyncContextImpl(TasksApiInterface.this.getTypeConverter(), TasksDefinitions.__cancelOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(TasksApiInterface.this.getIdentifier(), "list", TasksDefinitions.__listInput, TasksDefinitions.__listOutput, TasksApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.resourceInaccessible;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.serviceUnavailable;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthenticated;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, TasksDefinitions.__listInput, TasksApiInterface.this.getTypeConverter());
            TasksTypes.FilterSpec filterSpec = (TasksTypes.FilterSpec)extr.valueForField("filter_spec");
            TasksTypes.GetSpec resultSpec = (TasksTypes.GetSpec)extr.valueForField("result_spec");
            TasksApiInterface.this.impl.list(filterSpec, resultSpec, (AsyncContext<Map<String, Info>>)new AsyncContextImpl(TasksApiInterface.this.getTypeConverter(), TasksDefinitions.__listOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(TasksApiInterface.this.getIdentifier(), "get", TasksDefinitions.__getInput, TasksDefinitions.__getOutput, TasksApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.error;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.resourceInaccessible;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.serviceUnavailable;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthenticated;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, TasksDefinitions.__getInput, TasksApiInterface.this.getTypeConverter());
            String task = (String)extr.valueForField("task");
            TasksTypes.GetSpec spec = (TasksTypes.GetSpec)extr.valueForField("spec");
            TasksApiInterface.this.impl.get(task, spec, (AsyncContext<Info>)new AsyncContextImpl(TasksApiInterface.this.getTypeConverter(), TasksDefinitions.__getOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }
}

