/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.admin;

import com.vmware.vapi.admin.InterposerDefinitions;
import com.vmware.vapi.admin.InterposerProvider;
import com.vmware.vapi.admin.InterposerTypes;
import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;

public class InterposerApiInterface
extends ApiInterfaceSkeleton {
    private InterposerProvider impl;

    public InterposerApiInterface() {
        this((Class<? extends InterposerProvider>)null);
    }

    public InterposerApiInterface(Class<? extends InterposerProvider> implClass) {
        this((InterposerProvider)InterposerApiInterface.createImplInstance(implClass, (String)"com.vmware.vapi.admin.impl.InterposerImpl", InterposerProvider.class));
    }

    public InterposerApiInterface(InterposerProvider impl) {
        super("com.vmware.vapi.admin.interposer");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new AddApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new RemoveApiMethod());
    }

    private class RemoveApiMethod
    extends ApiMethodSkeleton {
        public RemoveApiMethod() {
            super(InterposerApiInterface.this.getIdentifier(), "remove", InterposerDefinitions.__removeInput, InterposerDefinitions.__removeOutput, InterposerApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, InterposerDefinitions.__removeInput, InterposerApiInterface.this.getTypeConverter());
            String interposerId = (String)extr.valueForField("interposer_id");
            InterposerApiInterface.this.impl.remove(interposerId, (AsyncContext<Void>)new AsyncContextImpl(InterposerApiInterface.this.getTypeConverter(), InterposerDefinitions.__removeOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(InterposerApiInterface.this.getIdentifier(), "get", InterposerDefinitions.__getInput, InterposerDefinitions.__getOutput, InterposerApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, InterposerDefinitions.__getInput, InterposerApiInterface.this.getTypeConverter());
            String interposerId = (String)extr.valueForField("interposer_id");
            InterposerApiInterface.this.impl.get(interposerId, (AsyncContext<InterposerTypes.InterposerInfo>)new AsyncContextImpl(InterposerApiInterface.this.getTypeConverter(), InterposerDefinitions.__getOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(InterposerApiInterface.this.getIdentifier(), "list", InterposerDefinitions.__listInput, InterposerDefinitions.__listOutput, InterposerApiInterface.this.getTypeConverter(), null, MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            InterposerApiInterface.this.impl.list((AsyncContext<List<String>>)new AsyncContextImpl(InterposerApiInterface.this.getTypeConverter(), InterposerDefinitions.__listOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class AddApiMethod
    extends ApiMethodSkeleton {
        public AddApiMethod() {
            super(InterposerApiInterface.this.getIdentifier(), "add", InterposerDefinitions.__addInput, InterposerDefinitions.__addOutput, InterposerApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, InterposerDefinitions.__addInput, InterposerApiInterface.this.getTypeConverter());
            InterposerTypes.InterposerInfo spec = (InterposerTypes.InterposerInfo)extr.valueForField("spec");
            InterposerApiInterface.this.impl.add(spec, (AsyncContext<String>)new AsyncContextImpl(InterposerApiInterface.this.getTypeConverter(), InterposerDefinitions.__addOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }
}

