/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.admin;

import com.vmware.vapi.admin.InterposerDefinitions;
import com.vmware.vapi.admin.InterposerSyncProvider;
import com.vmware.vapi.admin.InterposerTypes;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class InterposerSyncApiInterface
extends ApiInterfaceSkeleton {
    private InterposerSyncProvider impl;

    public InterposerSyncApiInterface() {
        this((Class<? extends InterposerSyncProvider>)null);
    }

    public InterposerSyncApiInterface(Class<? extends InterposerSyncProvider> implClass) {
        this((InterposerSyncProvider)InterposerSyncApiInterface.createImplInstance(implClass, (String)"com.vmware.vapi.admin.impl.InterposerImpl", InterposerSyncProvider.class));
    }

    public InterposerSyncApiInterface(InterposerSyncProvider impl) {
        super("com.vmware.vapi.admin.interposer");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new AddApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new RemoveApiMethod());
    }

    private class RemoveApiMethod
    extends ApiMethodSkeleton {
        public RemoveApiMethod() {
            super(InterposerSyncApiInterface.this.getIdentifier(), "remove", InterposerDefinitions.__removeInput, InterposerDefinitions.__removeOutput, InterposerSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, InterposerDefinitions.__removeInput, InterposerSyncApiInterface.this.getTypeConverter());
            String interposerId = (String)extr.valueForField("interposer_id");
            try {
                InterposerSyncApiInterface.this.impl.remove(interposerId, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(InterposerSyncApiInterface.this.getIdentifier(), "get", InterposerDefinitions.__getInput, InterposerDefinitions.__getOutput, InterposerSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, InterposerDefinitions.__getInput, InterposerSyncApiInterface.this.getTypeConverter());
            String interposerId = (String)extr.valueForField("interposer_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)InterposerSyncApiInterface.this.getTypeConverter().convertToVapi((Object)InterposerSyncApiInterface.this.impl.get(interposerId, invocationContext), InterposerDefinitions.__getOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(InterposerSyncApiInterface.this.getIdentifier(), "list", InterposerDefinitions.__listInput, InterposerDefinitions.__listOutput, InterposerSyncApiInterface.this.getTypeConverter(), null, MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)InterposerSyncApiInterface.this.getTypeConverter().convertToVapi(InterposerSyncApiInterface.this.impl.list(invocationContext), InterposerDefinitions.__listOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class AddApiMethod
    extends ApiMethodSkeleton {
        public AddApiMethod() {
            super(InterposerSyncApiInterface.this.getIdentifier(), "add", InterposerDefinitions.__addInput, InterposerDefinitions.__addOutput, InterposerSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, InterposerDefinitions.__addInput, InterposerSyncApiInterface.this.getTypeConverter());
            InterposerTypes.InterposerInfo spec = (InterposerTypes.InterposerInfo)extr.valueForField("spec");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)InterposerSyncApiInterface.this.getTypeConverter().convertToVapi((Object)InterposerSyncApiInterface.this.impl.add(spec, invocationContext), InterposerDefinitions.__addOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }
}

