/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.admin.interposer.impl;

import com.vmware.vapi.admin.impl.InterposerImpl;
import com.vmware.vapi.admin.interposer.impl.InterposerHandler;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.util.async.DecoratorAsyncHandle;
import java.util.Iterator;
import java.util.List;

public class VetoInterposerHandler
extends InterposerHandler {
    private final InterposerHandler nextHandler;

    public VetoInterposerHandler(List<InterposerImpl.InterposerDefinition> vetoInterposers, MethodIdentifier method, ExecutionContext context, DataValue input, InterposerHandler nextHandler, AsyncHandle<MethodResult> originalBack) {
        super(vetoInterposers, method, context, input, originalBack);
        this.nextHandler = nextHandler;
    }

    @Override
    public void execute() {
        final Iterator<InterposerImpl.InterposerDefinition> iter = this.interposers.iterator();
        if (!iter.hasNext()) {
            this.nextHandler.execute();
            return;
        }
        DecoratorAsyncHandle<MethodResult> handler = new DecoratorAsyncHandle<MethodResult>(this.callback){

            public void setResult(MethodResult result) {
                ErrorValue error = result.getError();
                if (error != null) {
                    InterposerHandler.logger.debug("Veto the call because of " + error.toString());
                    VetoInterposerHandler.this.callback.setResult((Object)result);
                } else if (iter.hasNext()) {
                    VetoInterposerHandler.this.executeNextInterposer(iter, (AsyncHandle<MethodResult>)this);
                } else {
                    VetoInterposerHandler.this.nextHandler.execute();
                }
            }

            public void setError(RuntimeException error) {
                InterposerHandler.logger.debug("Veto the call because of " + error.getLocalizedMessage());
                VetoInterposerHandler.this.callback.setError(error);
            }
        };
        this.executeNextInterposer(iter, (AsyncHandle<MethodResult>)handler);
    }
}

