/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.interposition;

import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.internal.interposition.InterposerUtil;
import com.vmware.vapi.internal.util.async.CompositeOperation;
import com.vmware.vapi.internal.util.async.TimeBoundOperationHandle;
import com.vmware.vapi.interposition.OperationInvocationInfo;
import com.vmware.vapi.interposition.VetoInterposerConfig;
import com.vmware.vapi.std.StandardDataFactory;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VetoInterposition
implements ApiProvider {
    private static final Logger logger = LoggerFactory.getLogger(VetoInterposition.class);
    private static final MessageFactory msgFactory = new MessageFactory(ResourceBundle.getBundle("common"));
    private final ApiProvider operationProvider;
    private final List<VetoInterposerConfig> interposers;
    private final ScheduledExecutorService scheduledExecutor;

    public VetoInterposition(ApiProvider operationProvider, List<VetoInterposerConfig> interposers, ScheduledExecutorService scheduledExecutor) {
        Validate.notNull((Object)operationProvider);
        Validate.notNull(interposers);
        this.operationProvider = operationProvider;
        this.interposers = interposers;
        this.scheduledExecutor = scheduledExecutor;
    }

    public void invoke(String serviceId, String operationId, DataValue input, ExecutionContext ctx, AsyncHandle<MethodResult> asyncHandle) {
        OperationInvocationInfo operationInfo = new OperationInvocationInfo(serviceId, operationId, ctx, input);
        CompositeOperation interposition = new CompositeOperation(this.interposers.size(), new InterpositionComplete(this.interposers, asyncHandle, this.operationProvider, operationInfo));
        List<AsyncHandle<MethodResult>> callbacks = interposition.getCallbacks();
        for (int i = 0; i < this.interposers.size(); ++i) {
            this.invokeInterposer(this.interposers.get(i), callbacks.get(i), operationInfo);
        }
    }

    private void invokeInterposer(VetoInterposerConfig interposer, AsyncHandle<MethodResult> interposerHandle, OperationInvocationInfo operationInfo) {
        if (interposer.getTimeoutMs() > 0L) {
            if (this.scheduledExecutor != null) {
                TimeBoundOperationHandle timedHandle;
                interposerHandle = timedHandle = new TimeBoundOperationHandle(interposerHandle, this.scheduledExecutor, interposer.getTimeoutMs());
            } else {
                logger.error("Could not track timeout for veto interposer '{}' because there is no configured ScheduledExecutorService", (Object)InterposerUtil.getOperationQualifiedId(interposer));
            }
        }
        interposer.getProvider().invoke(interposer.getServiceId(), interposer.getOperationId(), (DataValue)InterposerUtil.createInterposerInput(operationInfo, interposer), interposer.getExecutionContext(), interposerHandle);
    }

    private static ErrorValue getBlockingErrorForTimeout(OperationInvocationInfo operationInfo, VetoInterposerConfig interposer) {
        ErrorValue error = null;
        if (interposer.getRejectOnFailure()) {
            logger.error("Reject operation '{}' because veto interposer '{}' timed out", (Object)operationInfo.getOperationQualifiedId(), (Object)InterposerUtil.getOperationQualifiedId(interposer));
            Message msg = msgFactory.buildMessage("vapi.interposition.veto.interposer.timeout", new String[]{operationInfo.getOperationQualifiedId(), InterposerUtil.getOperationQualifiedId(interposer)});
            error = StandardDataFactory.createErrorValueForMessages((String)"com.vmware.vapi.std.errors.timed_out", Collections.singletonList(msg));
        } else {
            logger.debug("Ignore timed out veto interposer '{}' for operation '{}'", (Object)InterposerUtil.getOperationQualifiedId(interposer), (Object)operationInfo.getOperationQualifiedId());
        }
        return error;
    }

    private static ErrorValue getBlockingErrorForClientSideFailure(OperationInvocationInfo operationInfo, VetoInterposerConfig interposer, RuntimeException ex) {
        ErrorValue error = null;
        if (TimeBoundOperationHandle.TimedOutException.class == ex.getClass()) {
            error = VetoInterposition.getBlockingErrorForTimeout(operationInfo, interposer);
        } else if (interposer.getRejectOnFailure()) {
            logger.error(String.format("Reject operation '%s' because failed to invoke veto interposer '%s'", operationInfo.getOperationQualifiedId(), InterposerUtil.getOperationQualifiedId(interposer)), (Throwable)ex);
            Message msg = msgFactory.buildMessage("vapi.interposition.veto.interposer.exception", new String[]{operationInfo.getOperationQualifiedId(), InterposerUtil.getOperationQualifiedId(interposer)});
            error = StandardDataFactory.createErrorValueForMessages((String)"com.vmware.vapi.std.errors.service_unavailable", Collections.singletonList(msg));
        } else if (logger.isDebugEnabled()) {
            logger.debug(String.format("Ignore failure to invoke veto interposer '%s' for operation '%s'", InterposerUtil.getOperationQualifiedId(interposer), operationInfo.getOperationQualifiedId()), (Throwable)ex);
        }
        return error;
    }

    private static ErrorValue getBlockingError(OperationInvocationInfo operationInfo, VetoInterposerConfig interposer, CompositeOperation.OperationOutcome vetoOutcome) {
        if (vetoOutcome.getError() != null) {
            return VetoInterposition.getBlockingErrorForClientSideFailure(operationInfo, interposer, vetoOutcome.getError());
        }
        if (vetoOutcome.getResult().getError() != null) {
            logger.error(String.format("Reject operation '%s' because veto interposer '%s' returned error '%s'", operationInfo.getOperationQualifiedId(), InterposerUtil.getOperationQualifiedId(interposer), vetoOutcome.getResult().getError()));
            return vetoOutcome.getResult().getError();
        }
        logger.debug("Veto interposer '{}' accepted operation '{}'", (Object)InterposerUtil.getOperationQualifiedId(interposer), (Object)operationInfo.getOperationQualifiedId());
        return null;
    }

    private static class InterpositionComplete
    implements CompositeOperation.CompletionCallback {
        private final List<VetoInterposerConfig> interposers;
        private final AsyncHandle<MethodResult> operationHandle;
        private final ApiProvider operationProvider;
        private final OperationInvocationInfo operationInfo;

        public InterpositionComplete(List<VetoInterposerConfig> interposers, AsyncHandle<MethodResult> operationHandle, ApiProvider operationProvider, OperationInvocationInfo operationInfo) {
            this.interposers = interposers;
            this.operationHandle = operationHandle;
            this.operationProvider = operationProvider;
            this.operationInfo = operationInfo;
        }

        @Override
        public void onComplete(CompositeOperation.OperationOutcome[] outcomes) {
            for (int i = 0; i < outcomes.length; ++i) {
                ErrorValue blocker = VetoInterposition.getBlockingError(this.operationInfo, this.interposers.get(i), outcomes[i]);
                if (blocker == null) continue;
                this.operationHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)blocker));
                return;
            }
            this.operationProvider.invoke(this.operationInfo.getServiceId(), this.operationInfo.getOperationId(), this.operationInfo.getInput(), this.operationInfo.getExecutionContext(), this.operationHandle);
        }
    }
}

