/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.interposition;

import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.data.DataValue;
import org.apache.commons.lang.Validate;

public final class OperationInvocationInfo {
    private final String serviceId;
    private final String operationId;
    private final String operationQualifiedId;
    private final ExecutionContext executionContext;
    private final DataValue input;

    public OperationInvocationInfo(String serviceId, String operationId, ExecutionContext executionContext, DataValue input) {
        Validate.notEmpty((String)serviceId);
        Validate.notEmpty((String)operationId);
        Validate.notNull((Object)executionContext);
        Validate.notNull((Object)input);
        this.serviceId = serviceId;
        this.operationId = operationId;
        this.operationQualifiedId = serviceId + "." + operationId;
        this.executionContext = executionContext;
        this.input = input;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public String getOperationQualifiedId() {
        return this.operationQualifiedId;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public DataValue getInput() {
        return this.input;
    }
}

