/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.metadata.cli;

import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl;
import com.vmware.vapi.metadata.cli.NamespaceDefinitions;
import com.vmware.vapi.metadata.cli.NamespaceProvider;
import com.vmware.vapi.metadata.cli.NamespaceTypes;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;

public class NamespaceApiInterface
extends ApiInterfaceSkeleton {
    private NamespaceProvider impl;

    public NamespaceApiInterface() {
        this((Class<? extends NamespaceProvider>)null);
    }

    public NamespaceApiInterface(Class<? extends NamespaceProvider> implClass) {
        this((NamespaceProvider)NamespaceApiInterface.createImplInstance(implClass, (String)"com.vmware.vapi.metadata.cli.impl.NamespaceImpl", NamespaceProvider.class));
    }

    public NamespaceApiInterface(NamespaceProvider impl) {
        super("com.vmware.vapi.metadata.cli.namespace");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new FingerprintApiMethod());
    }

    private class FingerprintApiMethod
    extends ApiMethodSkeleton {
        public FingerprintApiMethod() {
            super(NamespaceApiInterface.this.getIdentifier(), "fingerprint", NamespaceDefinitions.__fingerprintInput, NamespaceDefinitions.__fingerprintOutput, NamespaceApiInterface.this.getTypeConverter(), null, MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            NamespaceApiInterface.this.impl.fingerprint((AsyncContext<String>)new AsyncContextImpl(NamespaceApiInterface.this.getTypeConverter(), NamespaceDefinitions.__fingerprintOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(NamespaceApiInterface.this.getIdentifier(), "get", NamespaceDefinitions.__getInput, NamespaceDefinitions.__getOutput, NamespaceApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, NamespaceDefinitions.__getInput, NamespaceApiInterface.this.getTypeConverter());
            NamespaceTypes.Identity identity = (NamespaceTypes.Identity)extr.valueForField("identity");
            NamespaceApiInterface.this.impl.get(identity, (AsyncContext<NamespaceTypes.Info>)new AsyncContextImpl(NamespaceApiInterface.this.getTypeConverter(), NamespaceDefinitions.__getOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(NamespaceApiInterface.this.getIdentifier(), "list", NamespaceDefinitions.__listInput, NamespaceDefinitions.__listOutput, NamespaceApiInterface.this.getTypeConverter(), null, MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            NamespaceApiInterface.this.impl.list((AsyncContext<List<NamespaceTypes.Identity>>)new AsyncContextImpl(NamespaceApiInterface.this.getTypeConverter(), NamespaceDefinitions.__listOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }
}

