/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.metadata.cli;

import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.metadata.cli.NamespaceDefinitions;
import com.vmware.vapi.metadata.cli.NamespaceSyncProvider;
import com.vmware.vapi.metadata.cli.NamespaceTypes;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class NamespaceSyncApiInterface
extends ApiInterfaceSkeleton {
    private NamespaceSyncProvider impl;

    public NamespaceSyncApiInterface() {
        this((Class<? extends NamespaceSyncProvider>)null);
    }

    public NamespaceSyncApiInterface(Class<? extends NamespaceSyncProvider> implClass) {
        this((NamespaceSyncProvider)NamespaceSyncApiInterface.createImplInstance(implClass, (String)"com.vmware.vapi.metadata.cli.impl.NamespaceImpl", NamespaceSyncProvider.class));
    }

    public NamespaceSyncApiInterface(NamespaceSyncProvider impl) {
        super("com.vmware.vapi.metadata.cli.namespace");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new FingerprintApiMethod());
    }

    private class FingerprintApiMethod
    extends ApiMethodSkeleton {
        public FingerprintApiMethod() {
            super(NamespaceSyncApiInterface.this.getIdentifier(), "fingerprint", NamespaceDefinitions.__fingerprintInput, NamespaceDefinitions.__fingerprintOutput, NamespaceSyncApiInterface.this.getTypeConverter(), null, MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)NamespaceSyncApiInterface.this.getTypeConverter().convertToVapi((Object)NamespaceSyncApiInterface.this.impl.fingerprint(invocationContext), NamespaceDefinitions.__fingerprintOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(NamespaceSyncApiInterface.this.getIdentifier(), "get", NamespaceDefinitions.__getInput, NamespaceDefinitions.__getOutput, NamespaceSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, NamespaceDefinitions.__getInput, NamespaceSyncApiInterface.this.getTypeConverter());
            NamespaceTypes.Identity identity = (NamespaceTypes.Identity)extr.valueForField("identity");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)NamespaceSyncApiInterface.this.getTypeConverter().convertToVapi((Object)NamespaceSyncApiInterface.this.impl.get(identity, invocationContext), NamespaceDefinitions.__getOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(NamespaceSyncApiInterface.this.getIdentifier(), "list", NamespaceDefinitions.__listInput, NamespaceDefinitions.__listOutput, NamespaceSyncApiInterface.this.getTypeConverter(), null, MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)NamespaceSyncApiInterface.this.getTypeConverter().convertToVapi(NamespaceSyncApiInterface.this.impl.list(invocationContext), NamespaceDefinitions.__listOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }
}

