/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.util.test;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class TestSslUtil {
    private TestSslUtil() {
    }

    public static KeyStore createTrustStoreForServer(String url) {
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
        String host = uri.getHost();
        int port = uri.getPort();
        if (port == -1) {
            port = 443;
        }
        return TestSslUtil.createTrustStoreForServer(host, port);
    }

    public static KeyStore createTrustStoreForServer(String host, int port) {
        X509TrustManager trustAll = new X509TrustManager(){

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, new TrustManager[]{trustAll}, null);
            SSLSocket s = (SSLSocket)ctx.getSocketFactory().createSocket(host, port);
            Certificate[] chain = s.getSession().getPeerCertificates();
            Certificate rootCert = chain[chain.length - 1];
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            trustStore.setCertificateEntry(host, rootCert);
            return trustStore;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

