/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.common.impl;

import com.vmware.vim.vmomi.client.common.impl.StackContext;
import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.soap.Unmarshaller;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.impl.VmodlContextImpl;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

class HeaderParamContext
implements StackContext {
    private Object _value;
    private boolean _mustUnderstand;
    private Unmarshaller _unmarshaller;
    private String _type;

    public HeaderParamContext(boolean mustUnderstand, String type, Unmarshaller unmarshaller) {
        this._type = type;
        this._mustUnderstand = mustUnderstand;
        this._unmarshaller = unmarshaller;
    }

    @Override
    public StackContext getNestedContext(QName name, Map<QName, String> attrs) throws UnmarshallException {
        throw new UnmarshallException(String.format("Unsupported nested context '%1$s'", name));
    }

    @Override
    public Object getValue() {
        return this._value;
    }

    @Override
    public void setChildValue(QName name, Object value) throws UnmarshallException {
        throw new UnmarshallException(String.format("Unsupported child context '%1$s'", name));
    }

    @Override
    public void setValue(Object value) throws UnmarshallException {
        try {
            this._value = this._unmarshaller.unmarshal(null, (XMLStreamReader)value);
            if (null != this._type) {
                VmodlType type = VmodlContextImpl.getCoreContext().getVmodlTypeMap().getVmodlType(this._type);
                if (type == null) {
                    throw new UnmarshallException(String.format("Type %1$s is not available in the core VmodlContext.", this._type));
                }
                if (type.getKind() != VmodlType.Kind.STRING && this._mustUnderstand) {
                    throw new UnmarshallException(String.format("Unexpected type in request context: %1$s. Expected type is String", type.getKind()));
                }
            }
        }
        catch (XMLStreamException e) {
            throw new UnmarshallException("Error setting value in header", (Throwable)e);
        }
    }
}

