/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.common.impl;

import com.vmware.vim.binding.vmodl.MethodName;
import com.vmware.vim.binding.vmodl.PropertyPath;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vim.binding.vmodl.fault.SystemError;
import com.vmware.vim.vmomi.client.ClientFuture;
import com.vmware.vim.vmomi.client.common.Response;
import com.vmware.vim.vmomi.client.common.impl.LoggingFilterInputStream;
import com.vmware.vim.vmomi.client.common.impl.ResponseUnmarshaller;
import com.vmware.vim.vmomi.client.ext.InvocationContext;
import com.vmware.vim.vmomi.client.ext.ResultInterceptor;
import com.vmware.vim.vmomi.client.http.impl.ClientExceptionTranslator;
import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.impl.XMLFactories;
import com.vmware.vim.vmomi.core.soap.Unmarshaller;
import com.vmware.vim.vmomi.core.types.ManagedObjectFactory;
import com.vmware.vim.vmomi.core.types.Util;
import com.vmware.vim.vmomi.core.types.VmodlArrayType;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ResponseImpl
implements Response {
    private static final ResultInterceptor IDENTITY_INTERCEPTOR = new ResultInterceptor(){

        @Override
        public Exception handleException(Exception ex, InvocationContext context) {
            return ex;
        }

        @Override
        public Exception handleSoapFault(Exception fault, InvocationContext context) {
            return fault;
        }

        @Override
        public Object handleReturnVal(Object result, InvocationContext context) {
            return result;
        }
    };
    private final VmodlField _field;
    private final boolean _isFetch;
    private final ClientFuture<Object> _future;
    private final Unmarshaller _unmarshal;
    private final String _debugFile;
    private final VmodlContext _context;
    private InvocationContext _invocationContext;
    private ResultInterceptor _resultInterceptor = IDENTITY_INTERCEPTOR;

    public ResponseImpl(VmodlField field, boolean isFetch, VmodlVersion version, ManagedObjectFactory factory, ResultInterceptor resultInterceptor, InvocationContext invocationContext, ClientFuture<Object> future, VmodlContext context) {
        this._field = field;
        this._isFetch = isFetch;
        this._future = future;
        if (resultInterceptor != null) {
            this._resultInterceptor = resultInterceptor;
        }
        this._invocationContext = invocationContext;
        this._debugFile = System.getProperty("vlsi.debug.client.responseLog");
        this._unmarshal = context.createResponseUnmarshaller(version, factory);
        this._context = context;
    }

    @Deprecated
    public ResponseImpl(VmodlField field, boolean isFetch, VmodlVersion version, ManagedObjectFactory factory, ResultInterceptor resultInterceptor, InvocationContext invocationContext, ClientFuture<Object> future) {
        this(field, isFetch, version, factory, resultInterceptor, invocationContext, future, VmodlContext.getContext());
    }

    private TypeName convertTypeName(Object obj) {
        return Util.createTypeName((Object)obj, (VmodlContext)this._context);
    }

    private MethodName convertMethodName(Object obj) {
        return Util.createMethodName((Object)obj, (VmodlContext)this._context);
    }

    private TypeName[] convertTypeNameArray(Object result) {
        Object[] array = (Object[])result;
        int length = array.length;
        TypeName[] arr = new TypeName[length];
        for (int i = 0; i < length; ++i) {
            arr[i] = this.convertTypeName(array[i]);
        }
        return arr;
    }

    private MethodName[] convertMethodNameArray(Object result) {
        Object[] array = (Object[])result;
        int length = array.length;
        MethodName[] arr = new MethodName[length];
        for (int i = 0; i < length; ++i) {
            arr[i] = this.convertMethodName(array[i]);
        }
        return arr;
    }

    private PropertyPath[] convertPropertyPathArray(Object result) {
        Object[] array = (Object[])result;
        int length = array.length;
        PropertyPath[] ret = new PropertyPath[array.length];
        for (int i = 0; i < length; ++i) {
            ret[i] = new PropertyPath(array[i].toString());
        }
        return ret;
    }

    private Object convertManagedObjectArray(Object result) {
        VmodlType type = ((VmodlArrayType)this._field.getType()).getComponentType();
        Class clazz = type.getTypeClass();
        Object[] array = (Object[])result;
        int length = array.length;
        Object out = Array.newInstance(clazz, length);
        System.arraycopy(result, 0, out, 0, length);
        return out;
    }

    private Object convertResult(Object result) throws Exception {
        if (result == null) {
            return null;
        }
        switch (this._field.getType().getKind()) {
            case TYPE_NAME: {
                result = this.convertTypeName(result);
                break;
            }
            case METHOD_NAME: {
                result = this.convertMethodName(result);
                break;
            }
            case PROPERTY_PATH: {
                result = new PropertyPath(result.toString());
                break;
            }
            case ARRAY: {
                VmodlType.Kind elementKind = ((VmodlArrayType)this._field.getType()).getComponentType().getKind();
                switch (elementKind) {
                    case TYPE_NAME: {
                        result = this.convertTypeNameArray(result);
                        break;
                    }
                    case METHOD_NAME: {
                        result = this.convertMethodNameArray(result);
                        break;
                    }
                    case PROPERTY_PATH: {
                        result = this.convertPropertyPathArray(result);
                        break;
                    }
                    case MANAGED_OBJECT: {
                        result = this.convertManagedObjectArray(result);
                    }
                }
                break;
            }
        }
        return result;
    }

    @Override
    public void setResponse(Response.Status status, InputStream body) {
        try {
            if (status == Response.Status.Ok) {
                Object result = this.unmarshalResponse(body);
                if (this._isFetch) {
                    result = this.convertResult(result);
                }
                this.checkNonOptionalValueProvided(result);
                this._future.set(this._resultInterceptor.handleReturnVal(result, this._invocationContext));
            } else if (status == Response.Status.Fault) {
                this._future.setException(this._resultInterceptor.handleSoapFault((Exception)this.unmarshalResponse(body), this._invocationContext));
            }
        }
        catch (Exception ex) {
            this.setError(ex);
        }
    }

    private void checkNonOptionalValueProvided(Object result) throws SystemError {
        if (result == null && this._field.getType() != null && !this._field.isOptional()) {
            SystemError err = new SystemError();
            err.setReason("Missing non-optional return value");
            throw err;
        }
    }

    @Override
    public void setError(Exception e) {
        e = ClientExceptionTranslator.translate(e);
        try {
            e = this._resultInterceptor.handleException(e, this._invocationContext);
        }
        catch (Exception ex) {
            e = ex;
        }
        this._future.setException(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object unmarshalResponse(InputStream body) throws XMLStreamException, UnmarshallException, IOException {
        if (this._debugFile != null) {
            body = new LoggingFilterInputStream(body, this._debugFile);
        }
        try {
            XMLStreamReader input = XMLFactories.getInputFactory().createXMLStreamReader(body, "utf-8");
            ResponseUnmarshaller response = new ResponseUnmarshaller(this._field, this._unmarshal, this._isFetch, input, this._context);
            Object retObject = response.unmarshal();
            this._future.setResponseContext(response.getResponseContext());
            Object object = retObject;
            return object;
        }
        finally {
            if (this._debugFile != null) {
                ((LoggingFilterInputStream)body).closeLog();
            }
        }
    }

    public InvocationContext getInvocationContext() {
        return this._invocationContext;
    }

    public ClientFuture<Object> getFuture() {
        return this._future;
    }
}

