/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.ClientFuture;
import com.vmware.vim.vmomi.client.common.Request;
import com.vmware.vim.vmomi.client.common.Response;
import com.vmware.vim.vmomi.client.common.impl.ResponseImpl;
import com.vmware.vim.vmomi.client.exception.TransportProtocolException;
import com.vmware.vim.vmomi.client.ext.InvocationInterceptor;
import com.vmware.vim.vmomi.client.http.CompiledHttpConfiguration;
import com.vmware.vim.vmomi.client.http.impl.ApacheClientRequestConfigurationMerger;
import com.vmware.vim.vmomi.client.http.impl.HttpAsyncProtocolBindingImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpExchangeBase;
import com.vmware.vim.vmomi.client.http.impl.InetAddressSniffingResponseConsumer;
import com.vmware.vim.vmomi.core.SyncFuture;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;

public class HttpAsyncExchange
extends HttpExchangeBase {
    private final HttpAsyncClient _client;
    private final HttpAsyncProtocolBindingImpl _binding;
    private final boolean _sync;
    private HttpClientContext httpContext;

    public HttpAsyncExchange(Request request, Response response, CompiledHttpConfiguration compiledHttpConfig, HttpAsyncClient client, ApacheClientRequestConfigurationMerger configMerger, URI endpoint, boolean enableCompression, InvocationInterceptor invocationInterceptor, HttpAsyncProtocolBindingImpl binding, boolean sync) {
        super(request, response, compiledHttpConfig, configMerger, endpoint, enableCompression, invocationInterceptor);
        this._client = client;
        this._binding = binding;
        this._sync = sync;
    }

    @Override
    public void run() {
        HttpPost post;
        this.beginInvocation();
        try {
            post = this.prepareRequest();
            this.httpContext = this.prepareContext();
        }
        catch (Exception e) {
            this.getResponse().setError(e);
            return;
        }
        InetAddressSniffingResponseConsumer responseConsumer = new InetAddressSniffingResponseConsumer((HttpAsyncResponseConsumer<HttpResponse>)HttpAsyncMethods.createConsumer(), this);
        this._client.execute(HttpAsyncMethods.create((HttpUriRequest)post), (HttpAsyncResponseConsumer)responseConsumer, (HttpContext)this.httpContext, this.createCallback());
    }

    private HttpClientContext prepareContext() {
        HttpClientContext result = this.prepareLocalContext();
        result.setCookieStore(this._binding.getCookieStore());
        return result;
    }

    private void execute(Runnable runnable) {
        ClientFuture<Object> future;
        Response response;
        if (this._sync && (response = this.getResponse()) instanceof ResponseImpl && (future = ((ResponseImpl)response).getFuture()) instanceof SyncFuture) {
            ((SyncFuture)future).executeInBlockedThread(runnable);
            return;
        }
        this._binding.executeRunnable(runnable, false);
    }

    private FutureCallback<HttpResponse> createCallback() {
        return new FutureCallback<HttpResponse>(){

            public void failed(final Exception e) {
                HttpAsyncExchange.this.execute(new Runnable(){

                    @Override
                    public void run() {
                        HttpAsyncExchange.this.getResponse().setError(e);
                        HttpAsyncExchange.this.completeInvocation(false);
                    }
                });
            }

            public void completed(final HttpResponse response) {
                HttpAsyncExchange.this.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean success = true;
                        try {
                            HttpAsyncExchange.this.extractUserToken(HttpAsyncExchange.this.httpContext);
                            HttpAsyncExchange.this.parseResponse(response);
                        }
                        catch (Exception e) {
                            success = false;
                            HttpAsyncExchange.this.getResponse().setError(e);
                        }
                        catch (Throwable e) {
                            success = false;
                            HttpAsyncExchange.this.getResponse().setError(new RuntimeException(e));
                        }
                        finally {
                            HttpAsyncExchange.this.completeInvocation(success);
                        }
                    }
                });
            }

            public void cancelled() {
                HttpAsyncExchange.this.execute(new Runnable(){

                    @Override
                    public void run() {
                        HttpAsyncExchange.this.getResponse().setError(new TransportProtocolException("Http exchange canceled."));
                        HttpAsyncExchange.this.completeInvocation(false);
                    }
                });
            }
        };
    }
}

