/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.http.CompiledHttpConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.impl.CompiledHttpConfigurationImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationCompilerBase;
import com.vmware.vim.vmomi.client.http.impl.ThumbprintTrustManager;
import com.vmware.vim.vmomi.client.http.impl.VlsiSslSocketFactory;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpConfigurationCompilerImpl
extends HttpConfigurationCompilerBase {
    @Override
    protected CompiledHttpConfiguration doCompile(HttpConfiguration config) {
        PoolingHttpClientConnectionManager connManager = this.createClientConnectionManager(config);
        return new CompiledHttpConfigurationImpl((HttpClientConnectionManager)connManager, config.getCompressionSupport(), config.getKeepAlivePeriod());
    }

    protected PoolingHttpClientConnectionManager createClientConnectionManager(HttpConfiguration config) {
        Registry<ConnectionSocketFactory> registry = this.createConnectionSocketFactoryRegistry(config);
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(registry);
        connManager.setMaxTotal(config.getMaxConnections());
        connManager.setDefaultMaxPerRoute(config.getDefaultMaxConnectionsPerRoute());
        for (HttpConfiguration.RouteConfiguration route : config.getRouteConfigurations()) {
            HttpHost host = new HttpHost(route.getHostName(), route.getPort(), route.getScheme());
            connManager.setMaxPerRoute(new HttpRoute(host), route.getMaxConnections());
        }
        return connManager;
    }

    protected Registry<ConnectionSocketFactory> createConnectionSocketFactoryRegistry(HttpConfiguration config) {
        ThumbprintTrustManager trustManager = this.createThumbprintTrustManager(config);
        SSLContext sslContext = this.createSSLContext(config, trustManager);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new VlsiSslSocketFactory(sslContext, config.getEnabledProtocols(), null, trustManager.new ThumbprintTrustManager.HostnameVerifier())).build();
        return socketFactoryRegistry;
    }
}

