/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.common.Request;
import com.vmware.vim.vmomi.client.common.Response;
import com.vmware.vim.vmomi.client.ext.ServerEndpointProvider;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.impl.ApacheClientRequestConfigurationMerger;
import com.vmware.vim.vmomi.client.http.impl.ClientExceptionTranslator;
import com.vmware.vim.vmomi.client.http.impl.CompiledHttpConfigurationImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpExchange;
import com.vmware.vim.vmomi.client.http.impl.HttpProtocolBindingBase;
import com.vmware.vim.vmomi.client.http.impl.VlsiRequestRetryHandler;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Executor;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;

public class HttpProtocolBindingImpl
extends HttpProtocolBindingBase {
    private final CloseableHttpClient _client;
    private final ApacheClientRequestConfigurationMerger _requestConfigurationMerger;

    public HttpProtocolBindingImpl(URI serverUri, Executor executor, ServerEndpointProvider endpointProvider, HttpConfiguration config) {
        super(serverUri, executor, endpointProvider, config);
        if (config == null) {
            throw new IllegalArgumentException("Client HTTP configuration is required");
        }
        if (!(this.getConfiguration().getCompiledConfiguration() instanceof CompiledHttpConfigurationImpl)) {
            throw new IllegalArgumentException("Configuration used for async clients can not be used for sync clients");
        }
        CompiledHttpConfigurationImpl compiledConfig = (CompiledHttpConfigurationImpl)this.getConfiguration().getCompiledConfiguration();
        final long keepAlivePeriod = this.getConfiguration().getKeepAlivePeriod();
        RequestConfig defaultRequestConfig = RequestConfig.custom().setExpectContinueEnabled(false).setStaleConnectionCheckEnabled(config.getCheckStaleConnection()).setSocketTimeout(config.getTimeoutMs()).setConnectTimeout(config.getConnectTimeoutMs()).setCookieSpec("standard").build();
        this._requestConfigurationMerger = new ApacheClientRequestConfigurationMerger(defaultRequestConfig);
        SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(config.getDisableNagle()).build();
        HttpClientBuilder builder = HttpClients.custom().setUserAgent(this.getConfiguration().getUserAgent()).setConnectionManager(compiledConfig.getConnectionManager()).setDefaultRequestConfig(defaultRequestConfig).setDefaultSocketConfig(socketConfig).setDefaultCookieSpecRegistry(HttpProtocolBindingImpl.createCookieSpecProviderRegistry()).setDefaultCookieStore(this._cookieStore).setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                return keepAlivePeriod;
            }
        }).setRetryHandler((HttpRequestRetryHandler)new VlsiRequestRetryHandler(this.getConfiguration().getRetryLimit()));
        if (config.getDefaultProxyHost() != null) {
            builder.setProxy(new HttpHost(config.getDefaultProxyHost(), config.getDefaultProxyPort(), config.getDefaultProxyScheme()));
        }
        this._client = builder.build();
        this.setCompressionSupport(this.resolveServerCompressionSupport());
    }

    @Override
    public void send(Request request, Response response, boolean sync) {
        HttpExchange exchange = new HttpExchange(request, response, this.getConfiguration().getCompiledConfiguration(), (HttpClient)this._client, this._requestConfigurationMerger, this.getEndpointUri(), this.getServerCompressionSupport() == HttpConfiguration.CompressionSupport.ENABLE, this.getInvocationInterceptor());
        this.executeRunnable(exchange, sync);
    }

    @Override
    public Object getImpl() {
        return this._client;
    }

    @Override
    protected HttpResponse executeRequest(HttpUriRequest options) {
        try {
            return this._client.execute(options);
        }
        catch (IOException e) {
            throw ClientExceptionTranslator.translateAny(e);
        }
    }
}

