/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.core.impl.SslUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TrustFirstKeystoreThumbprintVerifier
implements ThumbprintVerifier {
    private final ThreadSafeKeyStore _trustStore;
    private final String _trustedAlias;
    private AtomicReference<String> _requiredThumbprint = new AtomicReference();
    private static final Log _log = LogFactory.getLog(TrustFirstKeystoreThumbprintVerifier.class);

    public TrustFirstKeystoreThumbprintVerifier(ThreadSafeKeyStore trustStore, String trustedAlias) throws KeyStoreException, NoSuchAlgorithmException, CertificateEncodingException {
        this(trustStore, trustedAlias, "SHA-1");
    }

    public TrustFirstKeystoreThumbprintVerifier(ThreadSafeKeyStore trustStore, String trustedAlias, String digestAlgorithm) throws KeyStoreException, NoSuchAlgorithmException, CertificateEncodingException {
        if (trustStore == null || trustedAlias == null) {
            throw new IllegalArgumentException("Trust store and trusted alias are required");
        }
        this._trustStore = trustStore;
        this._trustedAlias = trustedAlias;
        X509Certificate trustedCert = null;
        trustedCert = (X509Certificate)trustStore.getCertificate(trustedAlias);
        if (trustedCert != null) {
            this._requiredThumbprint.set(SslUtil.computeCertificateThumbprint((X509Certificate)trustedCert, (String)digestAlgorithm));
        }
    }

    @Override
    public ThumbprintVerifier.Result verify(String thumbprint) {
        if (thumbprint == null) {
            return ThumbprintVerifier.Result.MISMATCH;
        }
        String expected = this._requiredThumbprint.get();
        if (expected != null) {
            if (thumbprint.equals(expected)) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Accepting connection with thumbprint " + thumbprint));
                }
                return ThumbprintVerifier.Result.MATCH;
            }
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Mismatched thumbprint " + thumbprint + ", rejecting connection"));
            }
            return ThumbprintVerifier.Result.MISMATCH;
        }
        return ThumbprintVerifier.Result.MATCH;
    }

    @Override
    public void onSuccess(X509Certificate[] chain, String thumbprint, ThumbprintVerifier.Result verifyResult, boolean trustedChain, boolean verifiedAssertion) {
        block4: {
            if (this._requiredThumbprint.compareAndSet(null, thumbprint)) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)String.format("Adding %s to trust store with alias '%s'", thumbprint, this._trustedAlias));
                }
                try {
                    this._trustStore.setCertificateEntry(this._trustedAlias, chain[0]);
                }
                catch (KeyStoreException e) {
                    if (!_log.isErrorEnabled()) break block4;
                    _log.error((Object)"Failed to store trusted certificate", (Throwable)e);
                }
            }
        }
    }

    public String getThumbprint() {
        return this._requiredThumbprint.get();
    }

    public static class ThreadSafeKeyStore {
        private final KeyStore _keyStore;
        private Lock _lock = new ReentrantLock();

        public ThreadSafeKeyStore(KeyStore keyStore) {
            this._keyStore = keyStore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Certificate getCertificate(String alias) throws KeyStoreException {
            this._lock.lock();
            try {
                Certificate certificate = this._keyStore.getCertificate(alias);
                return certificate;
            }
            finally {
                this._lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
            this._lock.lock();
            try {
                this._keyStore.setCertificateEntry(alias, cert);
            }
            finally {
                this._lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void store(OutputStream os, char[] password) throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
            this._lock.lock();
            try {
                this._keyStore.store(os, password);
            }
            finally {
                this._lock.unlock();
            }
        }
    }
}

