/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.core.dump;

import com.vmware.vise.util.common.Environment;
import com.vmware.vise.util.core.dump.CoreDumpLocator;
import com.vmware.vise.util.io.StreamUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CoreDumpLocatorImpl
implements CoreDumpLocator {
    private static final String MEDIC_CONFIG_FILE = "configuration" + Environment.fileSeparator() + "org.eclipse.virgo.medic.properties";
    private static final Log _logger = LogFactory.getLog(CoreDumpLocatorImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCoreDumpDirectory() {
        FileInputStream fileInputStream = null;
        Properties properties = new Properties();
        File file = new File(MEDIC_CONFIG_FILE);
        if (!file.exists()) {
            return System.getProperty("user.dir") + Environment.fileSeparator() + "logs";
        }
        try {
            fileInputStream = new FileInputStream(MEDIC_CONFIG_FILE);
            properties.load(fileInputStream);
        }
        catch (Exception exception) {
            String string;
            try {
                _logger.error((Object)("Error while loading " + MEDIC_CONFIG_FILE));
                string = null;
            }
            catch (Throwable throwable) {
                StreamUtil.close(fileInputStream);
                throw throwable;
            }
            StreamUtil.close((Closeable)fileInputStream);
            return string;
        }
        StreamUtil.close((Closeable)fileInputStream);
        String string = properties.getProperty("dump.root.directory", "serviceability/dump");
        if (SystemUtils.IS_OS_WINDOWS) {
            string.replace("/", Environment.fileSeparator());
        }
        return string;
    }
}

