/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.error;

import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vsphere.client.common.error.ErrorReportArgs;
import com.vmware.vsphere.client.common.error.ErrorReportData;
import com.vmware.vsphere.client.common.error.ErrorReportService;
import com.vmware.vsphere.client.common.error.ErrorStack;
import com.vmware.vsphere.client.error.ApplicationException;
import com.vmware.vsphere.client.error.ErrorReportUtil;
import com.vmware.vsphere.client.error.I18nUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.HttpRequestHandler;

public class ErrorReportServlet
implements HttpRequestHandler {
    private static final Log _logger = LogFactory.getLog(ErrorReportServlet.class);
    private final ErrorReportService _errorReportService;

    public ErrorReportServlet(ErrorReportService errorReportService) {
        this._errorReportService = errorReportService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ErrorReportArgs errorReportArgs = this.getArgs(httpServletRequest);
        SessionUtil.setHttpRequest((HttpServletRequest)httpServletRequest);
        try {
            ErrorReportData errorReportData = this._errorReportService.getReportData(errorReportArgs);
            ErrorReportServlet.htmlEncode(errorReportData);
            httpServletRequest.setAttribute("reportData", (Object)errorReportData);
            RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher("/errorReport/errorReport.jsp");
            requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (ApplicationException applicationException) {
            this.fowardError(httpServletRequest, httpServletResponse, applicationException.getMessage());
        }
        catch (Exception exception) {
            _logger.error((Object)"Unexpected error", (Throwable)exception);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            httpServletRequest.setAttribute("errorDetails", (Object)ErrorReportUtil.htmlEncode(stringWriter.toString()));
            String string = I18nUtil.text("ErrorMessages.unexpectedError", new String[0]);
            this.fowardError(httpServletRequest, httpServletResponse, string);
        }
        finally {
            SessionUtil.setHttpRequest(null);
        }
    }

    private void fowardError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws ServletException, IOException {
        httpServletRequest.setAttribute("errorMessage", (Object)ErrorReportUtil.htmlEncode(string));
        RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher("/errorReport/error.jsp");
        requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private ErrorReportArgs getArgs(HttpServletRequest httpServletRequest) {
        ErrorReportArgs errorReportArgs = new ErrorReportArgs();
        errorReportArgs.eventId = httpServletRequest.getParameter("eventId");
        errorReportArgs.taskId = httpServletRequest.getParameter("taskId");
        errorReportArgs.parentTaskId = httpServletRequest.getParameter("parentTaskId");
        errorReportArgs.serverGuid = httpServletRequest.getParameter("serverGuid");
        return errorReportArgs;
    }

    private static void htmlEncode(ErrorReportData errorReportData) {
        ErrorReportServlet.htmlEncode(errorReportData.eventItemList);
        ErrorReportServlet.htmlEncode(errorReportData.eventDetailList);
        ErrorReportServlet.htmlEncode(errorReportData.taskItemList);
        ErrorReportServlet.htmlEncode(errorReportData.taskDetailList);
        ErrorReportServlet.htmlEncode(errorReportData.faultItemList);
        ErrorReportServlet.htmlEncode(errorReportData.faultDetailList);
        ErrorReportServlet.htmlEncode(errorReportData.errorStack);
    }

    private static void htmlEncode(NameValuePair[] nameValuePairArray) {
        for (NameValuePair nameValuePair : nameValuePairArray) {
            nameValuePair.name = ErrorReportUtil.htmlEncode(nameValuePair.name);
            if (!(nameValuePair.value instanceof String)) continue;
            nameValuePair.value = ErrorReportUtil.htmlEncode((String)nameValuePair.value);
        }
    }

    private static void htmlEncode(ErrorStack errorStack) {
        errorStack.message = ErrorReportUtil.htmlEncode(errorStack.message);
        if (errorStack.messages != null) {
            for (LocalizableMessage localizableMessage : errorStack.messages) {
                localizableMessage.setMessage(ErrorReportUtil.htmlEncode(localizableMessage.getMessage()));
            }
        }
        if (errorStack.cause != null) {
            for (LocalizableMessage localizableMessage : errorStack.cause) {
                ErrorReportServlet.htmlEncode((ErrorStack)localizableMessage);
            }
        }
    }
}

