/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.error;

import com.vmware.vim.binding.impl.vmodl.KeyAnyValueImpl;
import com.vmware.vim.binding.impl.vmodl.LocalizableMessageImpl;
import com.vmware.vim.binding.vim.vm.Message;
import com.vmware.vim.binding.vmodl.DataObject;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.common.error.ErrorStack;
import com.vmware.vsphere.client.error.impl.ErrorStackResolverRegistrar;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ErrorStackUtil {
    private static final Log _logger = LogFactory.getLog(ErrorStackUtil.class);

    public static ErrorStack toErrorStack(VcService vcService, ErrorStackResolverRegistrar errorStackResolverRegistrar, Object object) {
        ErrorStack errorStack = ErrorStackUtil.toErrorStackImpl(vcService, errorStackResolverRegistrar, object);
        if (errorStack != null) {
            errorStack.source = object;
        }
        return errorStack;
    }

    private static ErrorStack toErrorStackImpl(VcService vcService, ErrorStackResolverRegistrar errorStackResolverRegistrar, Object object) {
        Object object2;
        if (object == null) {
            return null;
        }
        if (errorStackResolverRegistrar != null && (object2 = errorStackResolverRegistrar.getErrorStackResolver(object.getClass().getName())) != null) {
            return object2.resolve(vcService, object);
        }
        object2 = null;
        if (object instanceof Exception) {
            object2 = (Exception)object;
        }
        if (!(object instanceof DataObject) && object2 == null) {
            return null;
        }
        ErrorStack errorStack = null;
        Object object3 = null;
        ErrorStack errorStack2 = null;
        ErrorStack[] errorStackArray = null;
        if (object2 != null) {
            Object[] objectArray = null;
            if (object2 instanceof RuntimeFault) {
                objectArray = ((RuntimeFault)object2).getFaultMessage();
            } else if (object2 instanceof MethodFault) {
                objectArray = ((MethodFault)object2).getFaultMessage();
            }
            errorStack = !ArrayUtil.isNullOrEmpty((Object[])objectArray) ? ErrorStackUtil.newErrorStack((LocalizableMessage[])objectArray) : ErrorStackUtil.newErrorStack(null);
            String string = ((Throwable)object2).getMessage();
            if (!StringUtil.isNullOrEmpty((String)string)) {
                boolean bl = false;
                if (objectArray != null) {
                    for (Object object4 : objectArray) {
                        if (!string.equals(object4.getMessage())) continue;
                        bl = true;
                    }
                }
                if (!bl) {
                    errorStack.message = string;
                }
            }
        }
        if ((object3 = ErrorStackUtil.findCause(vcService, errorStackResolverRegistrar, object)) instanceof ErrorStack) {
            errorStack2 = (ErrorStack)object3;
        } else if (object3 instanceof ErrorStack[]) {
            errorStackArray = (ErrorStack[])object3;
        }
        if (errorStack != null) {
            if (errorStack.messages == null && errorStack2 != null) {
                errorStack.messages = errorStack2.messages;
                errorStack.cause = errorStack2.cause;
            } else if (errorStack2 != null) {
                errorStack.cause = new ErrorStack[]{errorStack2};
            } else if (errorStackArray != null) {
                errorStack.cause = errorStackArray;
            }
        } else {
            if (errorStack2 != null) {
                return errorStack2;
            }
            if (errorStackArray != null) {
                errorStack = ErrorStackUtil.newErrorStack(null);
                errorStack.cause = errorStackArray;
            }
        }
        return errorStack;
    }

    private static Object findCause(VcService vcService, ErrorStackResolverRegistrar errorStackResolverRegistrar, Object object) {
        if (object == null) {
            return null;
        }
        ErrorStack errorStack = null;
        ArrayList<ErrorStack> arrayList = new ArrayList<ErrorStack>();
        Method[] methodArray = object.getClass().getMethods();
        boolean bl = true;
        for (Method method : methodArray) {
            String string = method.getName();
            if (!string.startsWith("get")) continue;
            Object object2 = null;
            try {
                object2 = method.invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                _logger.error((Object)("Error retrieving value for " + object.getClass().getName() + "." + string), (Throwable)exception);
                continue;
            }
            if (object2 == null) continue;
            errorStack = ErrorStackUtil.tryVmMessageToErrorStack(object, object2, method);
            if (errorStack != null) {
                return errorStack;
            }
            if (object2.getClass().isArray()) {
                int n = Array.getLength(object2);
                for (int i = 0; i < n; ++i) {
                    Object object3 = Array.get(object2, i);
                    errorStack = ErrorStackUtil.toErrorStackImpl(vcService, errorStackResolverRegistrar, object3);
                    if (errorStack == null) continue;
                    arrayList.add(errorStack);
                    bl = false;
                }
                continue;
            }
            if (object2 == object || (errorStack = ErrorStackUtil.toErrorStackImpl(vcService, errorStackResolverRegistrar, object2)) == null) continue;
            arrayList.add(errorStack);
        }
        if (bl && arrayList.size() == 1) {
            return arrayList.get(0);
        }
        if (arrayList.size() > 0) {
            return arrayList.toArray(new ErrorStack[0]);
        }
        return null;
    }

    private static ErrorStack tryVmMessageToErrorStack(Object object, Object object2, Method method) {
        if (object2 instanceof Message[]) {
            Message[] messageArray = (Message[])object2;
            return ErrorStackUtil.newErrorStack(ErrorStackUtil.vmMessageToLocalizableMessage(messageArray));
        }
        return null;
    }

    private static LocalizableMessage[] vmMessageToLocalizableMessage(Message[] messageArray) {
        if (messageArray == null) {
            return null;
        }
        LocalizableMessage[] localizableMessageArray = new LocalizableMessage[messageArray.length];
        for (int i = 0; i < messageArray.length; ++i) {
            Message message = messageArray[i];
            LocalizableMessageImpl localizableMessageImpl = new LocalizableMessageImpl();
            if (message.argument != null) {
                KeyAnyValue[] keyAnyValueArray = new KeyAnyValue[message.argument.length];
                for (int j = 0; j < message.argument.length; ++j) {
                    KeyAnyValueImpl keyAnyValueImpl = new KeyAnyValueImpl();
                    keyAnyValueImpl.setKey(Integer.toString(j + 1));
                    keyAnyValueImpl.setValue(message.argument[j]);
                    keyAnyValueArray[j] = keyAnyValueImpl;
                }
                localizableMessageImpl.setArg(keyAnyValueArray);
            }
            localizableMessageImpl.setKey(message.getId());
            localizableMessageImpl.setMessage(message.getText());
            localizableMessageArray[i] = localizableMessageImpl;
        }
        return localizableMessageArray;
    }

    private static ErrorStack newErrorStack(LocalizableMessage[] localizableMessageArray) {
        if (localizableMessageArray == null) {
            return new ErrorStack();
        }
        ArrayUtil.reverse((Object[])localizableMessageArray);
        for (LocalizableMessage localizableMessage : localizableMessageArray) {
            ErrorStackUtil.localizeMessage(localizableMessage);
        }
        return new ErrorStack(localizableMessageArray);
    }

    private static void localizeMessage(LocalizableMessage localizableMessage) {
        String string = localizableMessage.getKey();
        String string2 = LocalizationUtil.getLocalizedMessage((String)string, (KeyAnyValue[])localizableMessage.getArg());
        if (string2 != null && !string2.equals(string)) {
            localizableMessage.setMessage(string2);
        }
    }
}

