/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.error;

import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.error.ErrorReportUtil;
import com.vmware.vsphere.client.error.xml.XmlArray;
import com.vmware.vsphere.client.error.xml.XmlAttribute;
import com.vmware.vsphere.client.error.xml.XmlElement;
import com.vmware.vsphere.client.error.xml.XmlText;
import java.util.ArrayList;
import java.util.List;

@XmlElement(value="Message")
public class StackMessage {
    private LocalizableMessage _m;

    public StackMessage(LocalizableMessage localizableMessage) {
        this._m = localizableMessage;
    }

    @XmlElement(value="Id")
    public String getId() {
        return this._m.getKey();
    }

    @XmlArray(value="ArgumentList")
    public List<Argument> getArguments() {
        if (this._m.getArg() == null) {
            return null;
        }
        ArrayList<Argument> arrayList = new ArrayList<Argument>();
        for (KeyAnyValue keyAnyValue : this._m.getArg()) {
            arrayList.add(new Argument(keyAnyValue));
        }
        return arrayList;
    }

    public void toLogDataString(StringBuilder stringBuilder) {
        stringBuilder.append(this.getId());
        stringBuilder.append(": ");
        int n = 0;
        if (this._m.getArg() == null) {
            return;
        }
        for (KeyAnyValue keyAnyValue : this._m.getArg()) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            ++n;
            if (keyAnyValue == null) {
                stringBuilder.append(String.format("#%d = <NULL>", n));
                continue;
            }
            String string = keyAnyValue.getKey();
            if (StringUtil.isNullOrEmpty((String)string)) {
                string = String.format("#%d", n);
            }
            stringBuilder.append(string);
            stringBuilder.append(" = ");
            stringBuilder.append(ErrorReportUtil.formatForDisplay(keyAnyValue.getValue()));
        }
        stringBuilder.append("\n");
    }

    @XmlElement(value="Argument")
    public static class Argument {
        private String _key;
        private String _value;

        @XmlAttribute(value="Key")
        public String getKey() {
            return this._key;
        }

        @XmlText
        public String getValue() {
            return this._value;
        }

        public Argument(KeyAnyValue keyAnyValue) {
            this._key = keyAnyValue.getKey();
            this._value = ErrorReportUtil.formatForServer(keyAnyValue.getValue());
        }
    }
}

