/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.export;

import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.metadata.MetadataService;
import com.vmware.vise.reporting.DataSource;
import com.vmware.vise.reporting.ReportDef;
import com.vmware.vise.reporting.ReportGenerator;
import com.vmware.vise.reporting.service.DownloadService;
import com.vmware.vise.reporting.service.data.Downloadable;
import com.vmware.vise.reporting.service.data.FileDownloadable;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vsphere.client.export.ExportListSpec;
import com.vmware.vsphere.client.export.ExportSpec;
import com.vmware.vsphere.client.export.LabelSpec;
import com.vmware.vsphere.client.export.RenderSpec;
import com.vmware.vsphere.client.export.ReportDeletionSpec;
import com.vmware.vsphere.client.export.datagrid.DatagridDataSource;
import com.vmware.vsphere.client.export.datagrid.DatagridRenderSpec;
import com.vmware.vsphere.client.export.datagrid.DatagridReportDef;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import javax.management.OperationsException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExportFileMutationProvider
implements MutationProvider {
    public static final int DEFAULT_VIRTUAL_PAGE_SIZE = 100;
    public static final int DEFAULT_VIRTUAL_PAGE_OFFSET = 0;
    private static final Log _logger = LogFactory.getLog(ExportFileMutationProvider.class);
    private DataService _dataService;
    private MetadataService _metadataService;
    private ReportGenerator _reportGenerator;
    private DownloadService _downloadService;

    public ExportFileMutationProvider(DataService dataService, MetadataService metadataService, ReportGenerator reportGenerator, DownloadService downloadService) {
        this._dataService = dataService;
        this._metadataService = metadataService;
        this._reportGenerator = reportGenerator;
        this._downloadService = downloadService;
    }

    public OperationResult add(ExportSpec exportSpec) {
        DataSource dataSource = this.getDataSource(exportSpec);
        return this.generateFile(exportSpec.renderSpec, dataSource);
    }

    public OperationResult add(ExportListSpec exportListSpec) {
        DataSource dataSource = this.getDataSource(exportListSpec.items);
        DatagridRenderSpec datagridRenderSpec = this.createRenderSpec(exportListSpec);
        return this.generateFile(datagridRenderSpec, dataSource);
    }

    public OperationResult remove(URI uRI, ReportDeletionSpec reportDeletionSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = uRI;
        try {
            String string = reportDeletionSpec.reportObjectRef;
            if (!string.equals(DefaultUriSchemeUtil.getId((URI)uRI))) {
                throw new OperationsException("The URL of this report does not match the file on the server.");
            }
            if (!this._downloadService.deleteDownloadable(string)) {
                throw new OperationsException("Report deletion has failed.");
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"ExportMutationProvider.remove failed:", (Throwable)exception);
        }
        return operationResult;
    }

    private OperationResult generateFile(RenderSpec renderSpec, DataSource dataSource) {
        ReportDef reportDef = this.getReportDef(renderSpec);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("REPORT_DATA_SOURCE", dataSource);
        hashMap.put("com_vmware_reporting_FORMAT", renderSpec.format.toString());
        hashMap.put("REPORT_LOCALE", ResourceUtil.getLocale());
        File file = this._reportGenerator.generate(reportDef, hashMap);
        FileDownloadable fileDownloadable = new FileDownloadable(file);
        OperationResult operationResult = new OperationResult();
        String string = this._downloadService.createUrl((Downloadable)fileDownloadable);
        operationResult.result = string;
        URI uRI = DefaultUriSchemeUtil.createUri((String)Downloadable.class.getSimpleName(), (String)string);
        operationResult.entity = uRI;
        return operationResult;
    }

    private DatagridRenderSpec createRenderSpec(ExportListSpec exportListSpec) {
        LabelSpec[] labelSpecArray = new LabelSpec[exportListSpec.columns.length];
        for (int i = 0; i < exportListSpec.columns.length; ++i) {
            LabelSpec labelSpec = new LabelSpec();
            labelSpec.name = exportListSpec.columns[i].title;
            labelSpec.property = exportListSpec.columns[i].propertyName;
            labelSpecArray[i] = labelSpec;
        }
        DatagridRenderSpec datagridRenderSpec = new DatagridRenderSpec();
        datagridRenderSpec.format = exportListSpec.format;
        datagridRenderSpec.labels = labelSpecArray;
        return datagridRenderSpec;
    }

    private ReportDef getReportDef(RenderSpec renderSpec) {
        DatagridReportDef datagridReportDef = null;
        if (renderSpec instanceof DatagridRenderSpec) {
            LabelSpec[] labelSpecArray = renderSpec.labels;
            DatagridReportDef datagridReportDef2 = new DatagridReportDef();
            datagridReportDef2.init(labelSpecArray);
            datagridReportDef = datagridReportDef2;
        }
        return datagridReportDef;
    }

    private DataSource getDataSource(ExportSpec exportSpec) {
        QuerySpec querySpec = new QuerySpec();
        querySpec.resourceSpec = exportSpec.resourceSpec;
        QuerySpec[] querySpecArray = new QuerySpec[]{querySpec};
        DatagridDataSource datagridDataSource = null;
        if (exportSpec.renderSpec instanceof DatagridRenderSpec) {
            DatagridDataSource datagridDataSource2 = new DatagridDataSource();
            datagridDataSource2.requestData(this._dataService, this._metadataService, querySpecArray, 100, 0);
            datagridDataSource = datagridDataSource2;
        }
        return datagridDataSource;
    }

    private DataSource getDataSource(ResultItem[] resultItemArray) {
        DatagridDataSource datagridDataSource = null;
        if (!ArrayUtil.isNullOrEmpty((Object[])resultItemArray)) {
            datagridDataSource = new DatagridDataSource();
            datagridDataSource.buildDataFromResultItems(this._metadataService, resultItemArray);
        }
        return datagridDataSource;
    }
}

