/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.extension;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionManager;
import com.vmware.vise.extensionfw.IExtensionInfoMetadataParser;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.XMLUtil;
import com.vmware.vise.util.io.StreamUtil;
import com.vmware.vsphere.client.extension.ClassInfo;
import java.io.Closeable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExtensionMetadataParser
implements IExtensionInfoMetadataParser {
    private static final Log _logger = LogFactory.getLog(ExtensionMetadataParser.class);
    private static final Map<String, ClassInfo> _javaClassByFlexClassName = new HashMap<String, ClassInfo>();

    public ExtensionMetadataParser(List<ClassInfo> list) {
        for (ClassInfo classInfo : list) {
            _javaClassByFlexClassName.put(classInfo.flexClassname, classInfo);
        }
    }

    public void initialize() {
        ExtensionManager.getInstance().setExtensionInfoMetadataParser((IExtensionInfoMetadataParser)this);
    }

    public void parse(Iterable<ExtensionInfo> iterable, Map<String, PropertyInfo> map) {
        for (ExtensionInfo extensionInfo : iterable) {
            if (extensionInfo.getMetadata() != null || StringUtil.isNullOrEmpty((String)extensionInfo.getMetadataXmlStr())) continue;
            ExtensionMetadataParser.parse(extensionInfo, map);
        }
    }

    private static void parse(ExtensionInfo extensionInfo, Map<String, PropertyInfo> map) {
        if (map == null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Document document = XMLUtil.parseXml((String)extensionInfo.getMetadataXmlStr());
        NodeList nodeList = document.getDocumentElement().getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            String string = node.getNodeName();
            String string2 = node.getTextContent();
            Object object = string2;
            if (map.containsKey(string)) {
                PropertyInfo propertyInfo = map.get(string);
                if (propertyInfo.type.equals(Boolean.class.getSimpleName())) {
                    object = Boolean.parseBoolean(string2);
                } else if (!propertyInfo.type.equals(String.class.getSimpleName())) {
                    String string3 = "<" + propertyInfo.name + ">";
                    String string4 = "</" + propertyInfo.name + ">";
                    int n2 = extensionInfo.getMetadataXmlStr().indexOf(string3) + string3.length();
                    int n3 = extensionInfo.getMetadataXmlStr().indexOf(string4);
                    string2 = extensionInfo.getMetadataXmlStr().substring(n2, n3);
                    object = ExtensionMetadataParser.deserializeComplexMetadata(extensionInfo, propertyInfo, string2);
                }
            }
            hashMap.put(string, (String)object);
        }
        extensionInfo.setMetadata(hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object deserializeComplexMetadata(ExtensionInfo extensionInfo, PropertyInfo propertyInfo, String string) {
        Object object;
        ClassInfo classInfo = _javaClassByFlexClassName.get(propertyInfo.type);
        if (classInfo == null) {
            return string;
        }
        StringReader stringReader = null;
        try {
            Object object2;
            stringReader = new StringReader(string);
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{classInfo.clazz});
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            object = object2 = unmarshaller.unmarshal((Source)new StreamSource(stringReader));
        }
        catch (Exception exception) {
            String string2;
            try {
                _logger.error((Object)("Error when unmarshalling metadata for extension id - " + extensionInfo.getId()), (Throwable)exception);
                string2 = string;
            }
            catch (Throwable throwable) {
                StreamUtil.close(stringReader);
                throw throwable;
            }
            StreamUtil.close((Closeable)stringReader);
            return string2;
        }
        StreamUtil.close((Closeable)stringReader);
        return object;
    }
}

