/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.history.impl;

import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.store.PersistenceService;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.history.HistoryItemPushSpec;
import com.vmware.vsphere.client.history.HistoryResultItem;
import com.vmware.vsphere.client.history.HistoryService;
import com.vmware.vsphere.client.history.impl.RecentItemsPersistenceStore;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HistoryServiceImpl
implements HistoryService {
    private static final String ICON_PROPERTY = "primaryIconId";
    private static final String NAME_PROPERTY = "name";
    private static final Log _logger = LogFactory.getLog(HistoryServiceImpl.class);
    private PersistenceService _persistenceService;
    private DataService _dataService;

    public PersistenceService getPersistenceService() {
        return this._persistenceService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this._persistenceService = persistenceService;
    }

    public DataService getDataService() {
        return this._dataService;
    }

    public void setDataService(DataService dataService) {
        this._dataService = dataService;
    }

    @Override
    public OperationResult addHistoryItems(HistoryItemPushSpec historyItemPushSpec) {
        OperationResult operationResult = new OperationResult();
        if (historyItemPushSpec.historyItems == null || historyItemPushSpec.historyItems.length == 0) {
            _logger.warn((Object)"No history items were provided in input.");
            return operationResult;
        }
        try {
            RecentItemsPersistenceStore recentItemsPersistenceStore = RecentItemsPersistenceStore.getInstance(this._persistenceService);
            for (int i = historyItemPushSpec.historyItems.length - 1; i >= 0; --i) {
                String string;
                if (historyItemPushSpec.historyItems[i] == null || (string = QueryUtil.getReferenceUid((Object)historyItemPushSpec.historyItems[i])) == null) continue;
                recentItemsPersistenceStore.push(string);
            }
            recentItemsPersistenceStore.commitChanges();
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage());
            operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
        }
        return operationResult;
    }

    @Override
    public OperationResult getHistoryItems() {
        HistoryResultItem[] historyResultItemArray;
        HistoryResultItem historyResultItem;
        Object object;
        OperationResult operationResult = new OperationResult();
        RecentItemsPersistenceStore recentItemsPersistenceStore = RecentItemsPersistenceStore.getInstance(this._persistenceService);
        String[] stringArray = recentItemsPersistenceStore.getList();
        if (stringArray.length == 0) {
            operationResult.result = new HistoryResultItem[0];
            return operationResult;
        }
        HashMap<String, HistoryResultItem> hashMap = new HashMap<String, HistoryResultItem>();
        ArrayList<HistoryResultItem> arrayList = new ArrayList<HistoryResultItem>(stringArray.length);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            object = QueryUtil.getReference((String)stringArray[i]);
            if (object == null) continue;
            historyResultItem = new HistoryResultItem();
            historyResultItem.objectRef = object;
            arrayList2.add(object);
            arrayList.add(historyResultItem);
            hashMap.put(stringArray[i], historyResultItem);
        }
        if (arrayList2.size() == 0) {
            operationResult.result = new HistoryResultItem[0];
            return operationResult;
        }
        Constraint constraint = HistoryServiceImpl.createConstraintForObjects(arrayList2.toArray());
        object = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{NAME_PROPERTY, ICON_PROPERTY});
        historyResultItem = null;
        try {
            historyResultItem = QueryUtil.getData((DataService)this._dataService, (QuerySpec)object);
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage());
            arrayList = new ArrayList();
        }
        if (historyResultItem != null) {
            for (ResultItem resultItem : ((ResultSet)historyResultItem).items) {
                HistoryResultItem historyResultItem2 = (HistoryResultItem)((Object)hashMap.get(QueryUtil.getReferenceUid((Object)resultItem.resourceObject)));
                if (historyResultItem2 == null) continue;
                for (PropertyValue propertyValue : resultItem.properties) {
                    if (propertyValue.propertyName == NAME_PROPERTY) {
                        historyResultItem2.name = (String)propertyValue.value;
                        continue;
                    }
                    if (propertyValue.propertyName != ICON_PROPERTY) continue;
                    historyResultItem2.icon = (String)propertyValue.value;
                }
            }
        }
        int n = 0;
        while (n < arrayList.size()) {
            HistoryResultItem historyResultItem3 = (HistoryResultItem)((Object)arrayList.get(n));
            if (StringUtil.isNullOrEmpty((String)historyResultItem3.name)) {
                arrayList.remove(n);
                continue;
            }
            ++n;
        }
        operationResult.result = historyResultItemArray = arrayList.toArray(new HistoryResultItem[arrayList.size()]);
        return operationResult;
    }

    private static Constraint createConstraintForObjects(Object[] objectArray) {
        ArrayList<ObjectIdentityConstraint> arrayList = new ArrayList<ObjectIdentityConstraint>();
        for (Object object : objectArray) {
            arrayList.add(QueryUtil.createObjectIdentityConstraint((Object)object));
        }
        return QueryUtil.createCompositeConstraint((Constraint[])arrayList.toArray(new Constraint[0]), (Conjoiner)Conjoiner.OR);
    }
}

