/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.history.impl;

import com.vmware.vise.store.OperationResult;
import com.vmware.vise.store.PersistenceService;
import com.vmware.vise.store.UserData;
import com.vmware.vise.store.UserDataMetadata;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;

public class RecentItemsPersistenceStore {
    private static final String RECENT_ITEMS_DATA_PATH = "recentitems";
    private static final String RECENT_ITEMS_DATA_UID = "vmware.vsphere.client.settings.recentitems";
    private static final char DELIMITER = '~';
    private int MAX_ITEMS = 10;
    private PersistenceService _persistenceService;
    private ArrayList<String> _list;
    private UserData _userData;

    public static RecentItemsPersistenceStore getInstance(PersistenceService persistenceService) {
        return new RecentItemsPersistenceStore(persistenceService);
    }

    public RecentItemsPersistenceStore(PersistenceService persistenceService) {
        this._persistenceService = persistenceService;
        this._userData = this.getUserHistoryData();
        this._list = new ArrayList();
        if (this._userData != null) {
            Object object = this._userData.value;
            String string = (String)object;
            String[] stringArray = StringUtils.split((String)string, (char)'~');
            Collections.addAll(this._list, stringArray);
        }
    }

    public void push(String string) {
        this._list.remove(string);
        this._list.add(0, string);
    }

    public String[] getList() {
        return this._list.toArray(new String[this._list.size()]);
    }

    public void commitChanges() {
        if (this._list.size() > this.MAX_ITEMS) {
            this._list.subList(this.MAX_ITEMS - 1, this._list.size() - 1).clear();
        }
        this.saveUserHistory(this._list.toArray(new String[this._list.size()]));
    }

    private UserData getUserHistoryData() {
        OperationResult operationResult = this._persistenceService.getUserData(this.getPersistenceUid(RECENT_ITEMS_DATA_UID), null, null);
        if (operationResult.error != null || operationResult == null || operationResult.result == null) {
            return null;
        }
        UserData userData = (UserData)operationResult.result;
        return userData;
    }

    private void saveUserHistory(String[] stringArray) {
        String string = StringUtils.join((Object[])stringArray, (char)'~');
        if (this._userData == null) {
            UserData userData = new UserData();
            UserDataMetadata userDataMetadata = new UserDataMetadata();
            userDataMetadata.uid = this.getPersistenceUid(RECENT_ITEMS_DATA_UID);
            userData.metadata = userDataMetadata;
            this._userData = userData;
        }
        this._userData.value = string;
        this._persistenceService.setUserData(this._userData, false, null);
    }

    private String getPersistenceUid(String string) {
        return "recentitems/" + string;
    }
}

