/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.iconslabels;

import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.DerivedPropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionListener;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginInfo;
import com.vmware.vise.extensionfw.PluginPackageEvent;
import com.vmware.vise.util.BuildProperties;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.XMLUtil;
import com.vmware.vise.util.collection.CollectionUtil;
import com.vmware.vsphere.client.iconslabels.IconsLabelsPropertyParser;
import com.vmware.vsphere.client.iconslabels.model.IconLabelSpec;
import com.vmware.vsphere.client.iconslabels.model.ObjectRepresentationSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class IconsLabelsPropertyProviderAdapter
implements DerivedPropertyProviderAdapter,
ExtensionListener {
    private static final Log _logger = LogFactory.getLog(IconsLabelsPropertyProviderAdapter.class);
    private static final DerivedPropertyInfo[] EMPTY_DERIVED_PROPERTY_INFO_ARR = new DerivedPropertyInfo[0];
    private static final String PRIMARY_ICONID_PROPERTY_NAME = "primaryIconId";
    private static final String LABELIDS_PROPERTY_NAME = "labelIds";
    private static final String DELIMITER = ";";
    private static final String BEG_TYPES_TOKEN = "<types>";
    private static final String END_TYPES_TOKEN = "</types>";
    private static final String BEG_STRING_TOKEN = "<String>";
    private static final String END_STRING_TOKEN = "</String>";
    private static final IconLabelSpec[] EMPTY_ICON_LABEL_SPEC_ARRAY = new IconLabelSpec[0];
    private static final Set<String> VALID_PROPERTIES = new HashSet<String>();
    private static final boolean _isH5Client;
    private final ExtensionService _extensionService;
    private final DataServiceExtensionRegistry _registry;
    private final String _iconlabelExtensionPoint;
    private final String _objTypesExtensionPoint;
    private final AtomicInteger _version = new AtomicInteger(0);
    private final AtomicReference<Pair<Integer, Future<ImmutableDataContainer>>> _dataContainer = new AtomicReference();

    public IconsLabelsPropertyProviderAdapter(ExtensionService extensionService, String string, String string2, DataServiceExtensionRegistry dataServiceExtensionRegistry) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{extensionService, string, string2, dataServiceExtensionRegistry});
        this._registry = dataServiceExtensionRegistry;
        this._extensionService = extensionService;
        this._iconlabelExtensionPoint = string;
        this._objTypesExtensionPoint = string2;
    }

    public void initialize() {
        Callable<ImmutableDataContainer> callable = this.createLoadDataContainerOp(0);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<ImmutableDataContainer> future = executorService.submit(callable);
        executorService.shutdown();
        this._dataContainer.set((Pair<Integer, Future<ImmutableDataContainer>>)new Pair((Object)0, future));
    }

    public void handleEvent(PluginPackageEvent pluginPackageEvent) throws Exception {
        int n = this._version.incrementAndGet();
        _logger.info((Object)("got plugin event, icons update version: " + n));
        Callable<ImmutableDataContainer> callable = this.createLoadDataContainerOp(n);
        FutureTask<ImmutableDataContainer> futureTask = new FutureTask<ImmutableDataContainer>(callable);
        Pair pair = new Pair((Object)n, futureTask);
        boolean bl = false;
        while (!bl) {
            Pair<Integer, Future<ImmutableDataContainer>> pair2 = this._dataContainer.get();
            int n2 = (Integer)pair2.first;
            if (n2 >= n) {
                _logger.info((Object)("Update already running with version: " + n2 + ",skipping update with version: " + n));
                this.getDataContainer();
                return;
            }
            bl = this._dataContainer.compareAndSet(pair2, (Pair<Integer, Future<ImmutableDataContainer>>)pair);
        }
        futureTask.run();
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequestSpec) {
        Object object;
        PropertySpec propertySpec2;
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequestSpec});
        Object[] objectArray = propertyRequestSpec.objects;
        ResultSet resultSet = propertyRequestSpec.properties;
        if (objectArray == null || objectArray.length == 0 || resultSet == null || ((PropertySpec[])resultSet).length == 0) {
            return QueryUtil.EMPTY_RESULT_SET;
        }
        boolean bl = false;
        for (PropertySpec propertySpec2 : resultSet) {
            object = propertySpec2.propertyNames;
            if (object == null) continue;
            for (String string : object) {
                if (!VALID_PROPERTIES.contains(string)) {
                    throw new IllegalArgumentException("Unsupported property request: " + string);
                }
                bl = true;
            }
        }
        if (!bl) {
            return QueryUtil.EMPTY_RESULT_SET;
        }
        ResultSet resultSet2 = new ResultSet();
        ImmutableDataContainer immutableDataContainer = this.getDataContainer();
        if (immutableDataContainer == null) {
            resultSet2.items = QueryUtil.EMPTY_RESULT_ITEM_ARRAY;
            resultSet2.error = new IllegalStateException("Icons adapter not initialized.");
            return resultSet2;
        }
        Map map = Collections.emptyMap();
        propertySpec2 = propertyRequestSpec.derivedPropertyData;
        if (propertySpec2 != null && propertySpec2.getSourcePropertyValuesByObject() != null) {
            map = propertySpec2.getSourcePropertyValuesByObject();
        }
        object = immutableDataContainer.getResultItems(map, objectArray, (PropertySpec[])resultSet);
        resultSet2.items = object.toArray(QueryUtil.EMPTY_RESULT_ITEM_ARRAY);
        return resultSet2;
    }

    public boolean isIconProperty(String string, String string2) {
        Set set = (Set)this.getDataContainer()._iconPropertyNamesByObjectType.get(string);
        if (set == null) {
            return false;
        }
        return set.contains(string2);
    }

    public boolean isLabelProperty(String string, String string2) {
        Set set = (Set)this.getDataContainer()._labelPropertyNamesByObjectType.get(string);
        if (set == null) {
            return false;
        }
        return set.contains(string2);
    }

    private ImmutableDataContainer getDataContainer() {
        Future future = (Future)this._dataContainer.get().second;
        try {
            ImmutableDataContainer immutableDataContainer = (ImmutableDataContainer)future.get();
            return immutableDataContainer;
        }
        catch (InterruptedException interruptedException) {
            _logger.info((Object)"Interrupted while awaiting data container to load.");
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                return null;
            }
            _logger.error((Object)"Failed to load data container: ", throwable);
        }
        return null;
    }

    private Callable<ImmutableDataContainer> createLoadDataContainerOp(final int n) {
        Callable<ImmutableDataContainer> callable = new Callable<ImmutableDataContainer>(){

            @Override
            public ImmutableDataContainer call() throws Exception {
                _logger.info((Object)("Actually running update with version: " + n));
                boolean bl = n == 0;
                ImmutableDataContainer immutableDataContainer = IconsLabelsPropertyProviderAdapter.this.initializeDataContainer(bl);
                _logger.info((Object)("Completed update with version: " + n));
                return immutableDataContainer;
            }
        };
        return callable;
    }

    private ImmutableDataContainer initializeDataContainer(boolean bl) throws Exception {
        ImmutableDataContainer immutableDataContainer = new ImmutableDataContainer(this._extensionService, this._iconlabelExtensionPoint, this._objTypesExtensionPoint);
        ArrayList<DerivedPropertyInfo> arrayList = new ArrayList<DerivedPropertyInfo>();
        for (String string : immutableDataContainer._allTypes) {
            DerivedPropertyInfo derivedPropertyInfo;
            Set set = (Set)immutableDataContainer._iconPropertyNamesByObjectType.get(string);
            Set set2 = (Set)immutableDataContainer._labelPropertyNamesByObjectType.get(string);
            ArrayList<DerivedPropertyInfo> arrayList2 = new ArrayList<DerivedPropertyInfo>(2);
            ArrayList<String> arrayList3 = new ArrayList<String>();
            if (set != null && !set.isEmpty()) {
                derivedPropertyInfo = new DerivedPropertyInfo();
                derivedPropertyInfo.propertyName = PRIMARY_ICONID_PROPERTY_NAME;
                derivedPropertyInfo.sourcePropertyNames = set.toArray(StringUtil.EMPTY_STRING_ARR);
                arrayList2.add(derivedPropertyInfo);
                arrayList3.add(PRIMARY_ICONID_PROPERTY_NAME);
            } else if (this.hasUnconditionalSpecs((Collection)immutableDataContainer._primaryIconSpecsByObjectType.get(string)) || this.hasUnconditionalSpecs((Collection)immutableDataContainer._secondaryIconSpecsByObjectType.get(string))) {
                arrayList3.add(PRIMARY_ICONID_PROPERTY_NAME);
            }
            if (set2 != null && !set2.isEmpty()) {
                derivedPropertyInfo = new DerivedPropertyInfo();
                derivedPropertyInfo.propertyName = LABELIDS_PROPERTY_NAME;
                derivedPropertyInfo.sourcePropertyNames = set2.toArray(StringUtil.EMPTY_STRING_ARR);
                arrayList2.add(derivedPropertyInfo);
                arrayList3.add(LABELIDS_PROPERTY_NAME);
            } else if (this.hasUnconditionalSpecs((Collection)immutableDataContainer._primaryLabelSpecsByObjectType.get(string)) || this.hasUnconditionalSpecs((Collection)immutableDataContainer._secondaryLabelSpecsByObjectType.get(string))) {
                arrayList3.add(LABELIDS_PROPERTY_NAME);
            }
            if (arrayList3.isEmpty()) continue;
            derivedPropertyInfo = new TypeInfo();
            derivedPropertyInfo.derivedProperties = arrayList2.toArray(EMPTY_DERIVED_PROPERTY_INFO_ARR);
            derivedPropertyInfo.properties = arrayList3.toArray(StringUtil.EMPTY_STRING_ARR);
            derivedPropertyInfo.type = string;
            arrayList.add(derivedPropertyInfo);
            if (!_logger.isInfoEnabled()) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Creating Type Info for: " + derivedPropertyInfo.type);
            stringBuilder.append("supported properties: " + arrayList3);
            stringBuilder.append("derived properties: " + arrayList2);
            _logger.info((Object)stringBuilder);
        }
        if (arrayList.isEmpty()) {
            _logger.warn((Object)"Empty type infos. Skipping registration.");
            return immutableDataContainer;
        }
        if (bl) {
            this._registry.registerDataAdapter((PropertyProviderAdapter)this, arrayList.toArray(QueryUtil.EMPTY_TYPE_INFO));
        } else {
            this._registry.reRegisterDataAdapter((PropertyProviderAdapter)this, arrayList.toArray(QueryUtil.EMPTY_TYPE_INFO));
        }
        return immutableDataContainer;
    }

    private boolean hasUnconditionalSpecs(Collection<IconLabelSpec> collection) {
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        for (IconLabelSpec iconLabelSpec : collection) {
            if (iconLabelSpec == null || iconLabelSpec.conditionalProperties != null && iconLabelSpec.conditionalProperties.length != 0 || iconLabelSpec.conditions != null && iconLabelSpec.conditions.length != 0) continue;
            return true;
        }
        return false;
    }

    private static String getIconPropertyFromSpecs(IconLabelSpec[] iconLabelSpecArray) {
        for (int i = 0; i < iconLabelSpecArray.length; ++i) {
            IconLabelSpec iconLabelSpec = iconLabelSpecArray[i];
            if (iconLabelSpec == null) continue;
            return iconLabelSpec.iconId;
        }
        _logger.warn((Object)"No icon property found");
        return "";
    }

    private static String getLabelsPropertyFromSpecs(IconLabelSpec[] iconLabelSpecArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < iconLabelSpecArray.length; ++i) {
            if (StringUtil.isNullOrEmpty((String)iconLabelSpecArray[i].labelId)) continue;
            stringBuilder.append(DELIMITER);
            stringBuilder.append(iconLabelSpecArray[i].labelId);
        }
        String string = stringBuilder.toString();
        if (DELIMITER.equals(stringBuilder.substring(0, DELIMITER.length() - 1))) {
            string = string.substring(DELIMITER.length());
        }
        return string;
    }

    private static IconLabelSpec[] getSpecsSatisfyingProperties(Map<String, List<IconLabelSpec>> map, String string, Map<String, Object> map2) {
        ArrayList<IconLabelSpec> arrayList = new ArrayList<IconLabelSpec>();
        List<IconLabelSpec> list = map.get(string);
        if (list == null) {
            return EMPTY_ICON_LABEL_SPEC_ARRAY;
        }
        for (IconLabelSpec iconLabelSpec : list) {
            boolean bl = IconsLabelsPropertyProviderAdapter.propertiesSatisfyConditionalProperties(iconLabelSpec.conditionalProperties, map2);
            boolean bl2 = IconsLabelsPropertyProviderAdapter.propertiesSatisfyConditions(iconLabelSpec.conditions, map2);
            if (!bl || !bl2) continue;
            arrayList.add(iconLabelSpec);
        }
        return arrayList.toArray(EMPTY_ICON_LABEL_SPEC_ARRAY);
    }

    private static boolean propertiesSatisfyConditionalProperties(String[] stringArray, Map<String, Object> map) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (IconsLabelsPropertyProviderAdapter.conditionalPropertySatisfied(stringArray[i], map)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean conditionalPropertySatisfied(String string, Map<String, Object> map) {
        if (StringUtil.isNullOrEmpty((String)string) || map == null || map.size() == 0) {
            return false;
        }
        boolean bl = string.charAt(0) == '!';
        Object object = map.get(IconsLabelsPropertyProviderAdapter.removeNegationOperatorIfNeeded(string));
        boolean bl2 = false;
        if (object instanceof Boolean) {
            bl2 = (Boolean)object;
        } else if (object instanceof String) {
            String string2 = (String)object;
            bl2 = Boolean.valueOf(string2);
        } else if (object != null) {
            bl2 = true;
        }
        if (bl) {
            return !bl2;
        }
        return bl2;
    }

    private static boolean propertiesSatisfyConditions(PropertyConstraint[] propertyConstraintArray, Map<String, Object> map) {
        if (propertyConstraintArray != null) {
            for (int i = 0; i < propertyConstraintArray.length; ++i) {
                if (IconsLabelsPropertyProviderAdapter.conditionSatisfied(propertyConstraintArray[i], map)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean conditionSatisfied(PropertyConstraint propertyConstraint, Map<String, Object> map) {
        String string;
        String string2;
        if (propertyConstraint.comparator == null || StringUtil.isNullOrEmpty((String)propertyConstraint.propertyName) || map == null || map.size() == 0) {
            return false;
        }
        Object object = map.get(propertyConstraint.propertyName);
        Object object2 = propertyConstraint.comparableValue;
        Comparator comparator = propertyConstraint.comparator;
        return Comparator.EQUALS == comparator ? IconsLabelsPropertyProviderAdapter.compareValues(object, object2) == 0 : (Comparator.SMALLER == comparator ? IconsLabelsPropertyProviderAdapter.compareValues(object, object2) < 0 : (Comparator.GREATER == comparator ? IconsLabelsPropertyProviderAdapter.compareValues(object, object2) > 0 : (Comparator.NOT_EQUALS == comparator ? IconsLabelsPropertyProviderAdapter.compareValues(object, object2) != 0 : Comparator.CONTAINS == comparator && object instanceof String && object2 instanceof String && (string2 = (String)object).indexOf(string = (String)object2) >= 0)));
    }

    private static int compareValues(Object object, Object object2) {
        int n = 0;
        if (object instanceof Comparable && object instanceof Comparable && object.getClass() == object2.getClass()) {
            n = ((Comparable)object).compareTo(object2);
        }
        n = object == null || object2 == null ? (object == object2 ? 0 : (object == null ? -1 : 1)) : object.toString().compareToIgnoreCase(object2.toString());
        return n;
    }

    private static String getPackageIdFromExtensionInfo(ExtensionInfo extensionInfo, ExtensionService extensionService) throws Exception {
        IdVersionPair idVersionPair = extensionInfo.getPluginRef();
        PluginInfo pluginInfo = extensionService.getPluginInfo(idVersionPair);
        IdVersionPair idVersionPair2 = pluginInfo.getPackageRef();
        if (idVersionPair2 == null) {
            return "";
        }
        String string = idVersionPair2.getId();
        return string;
    }

    private static List<String> getTypesFromObjectTypeInfoXml(String string) {
        int n;
        List<String> list = new ArrayList<String>();
        boolean bl = string.contains(BEG_STRING_TOKEN);
        int n2 = string.indexOf(BEG_TYPES_TOKEN);
        int n3 = n = bl ? string.indexOf(END_TYPES_TOKEN) : string.lastIndexOf(END_TYPES_TOKEN);
        if (n2 == -1 || n == -1) {
            return list;
        }
        if (bl) {
            String string2 = string.substring(n2 + BEG_TYPES_TOKEN.length(), n);
            list = IconsLabelsPropertyProviderAdapter.parseTypes(string2, BEG_STRING_TOKEN, END_STRING_TOKEN);
        } else {
            String string3 = string.substring(n2, n + END_TYPES_TOKEN.length());
            list = IconsLabelsPropertyProviderAdapter.parseTypes(string3, BEG_TYPES_TOKEN, END_TYPES_TOKEN);
        }
        return list;
    }

    private static List<String> parseTypes(String string, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Pattern pattern = Pattern.compile(string2 + "(.+?)" + string3);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            arrayList.add(matcher.group(1));
        }
        return arrayList;
    }

    private static String getBundleNameFromExtensionInfo(ExtensionInfo extensionInfo, ExtensionService extensionService) throws Exception {
        IdVersionPair idVersionPair = extensionInfo.getPluginRef();
        PluginInfo pluginInfo = extensionService.getPluginInfo(idVersionPair);
        return pluginInfo.getDefaultBundle();
    }

    private static void addSpecsToSpecByObjectTypeMaps(Map<String, List<IconLabelSpec>> map, Map<String, List<IconLabelSpec>> map2, String string, IconLabelSpec[] iconLabelSpecArray) {
        for (IconLabelSpec iconLabelSpec : iconLabelSpecArray) {
            List<IconLabelSpec> list;
            if (iconLabelSpec == null) continue;
            if (!StringUtil.isNullOrEmpty((String)iconLabelSpec.iconId)) {
                list = map.get(string);
                if (list == null) {
                    list = new ArrayList<IconLabelSpec>();
                    map.put(string, list);
                }
                list.add(iconLabelSpec);
            }
            if (StringUtil.isNullOrEmpty((String)iconLabelSpec.labelId)) continue;
            list = map2.get(string);
            if (list == null) {
                list = new ArrayList<IconLabelSpec>();
                map2.put(string, list);
            }
            list.add(iconLabelSpec);
        }
    }

    private static Set<String> extractPropertyNames(List<IconLabelSpec> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (IconLabelSpec iconLabelSpec : list) {
            if (iconLabelSpec.conditionalProperties != null) {
                for (String string : iconLabelSpec.conditionalProperties) {
                    hashSet.add(IconsLabelsPropertyProviderAdapter.removeNegationOperatorIfNeeded(string));
                }
                continue;
            }
            if (iconLabelSpec.conditions == null) continue;
            for (String string : iconLabelSpec.conditions) {
                hashSet.add(((PropertyConstraint)string).propertyName);
            }
        }
        return hashSet;
    }

    private static String removeNegationOperatorIfNeeded(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return string;
        }
        if (string.charAt(0) == '!') {
            return string.substring(1);
        }
        return string;
    }

    private static ObjectRepresentationSpec transformIconLabelIds(ObjectRepresentationSpec objectRepresentationSpec, String string) {
        if (objectRepresentationSpec.specCollection == null) {
            _logger.error((Object)("Invalid null icon/label specCollection for objectType " + objectRepresentationSpec.objectType + " in " + string));
            return objectRepresentationSpec;
        }
        for (IconLabelSpec iconLabelSpec : objectRepresentationSpec.specCollection) {
            iconLabelSpec.iconId = IconsLabelsPropertyProviderAdapter.getFullyQualifiedResouceId(iconLabelSpec.iconId, string, true);
            iconLabelSpec.labelId = IconsLabelsPropertyProviderAdapter.getFullyQualifiedResouceId(iconLabelSpec.labelId, string, false);
        }
        return objectRepresentationSpec;
    }

    private static String getFullyQualifiedResouceId(String string, String string2, boolean bl) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return string;
        }
        int n = string.indexOf("{");
        int n2 = string.indexOf("}");
        String string3 = string;
        if (n == -1 || n2 == -1) {
            return string;
        }
        string3 = string.substring(n + 1, n2);
        String[] stringArray = string3.split(":");
        if (stringArray.length == 2) {
            if (_isH5Client && bl) {
                string3 = stringArray[0] + "-" + stringArray[1];
            }
        } else if (stringArray.length == 1 && string2 != null) {
            string3 = string2 + (_isH5Client && bl ? "-" : ":") + string3;
        } else {
            _logger.error((Object)("Invalid resource id expression: " + string));
        }
        return string3;
    }

    static {
        VALID_PROPERTIES.add(PRIMARY_ICONID_PROPERTY_NAME);
        VALID_PROPERTIES.add(LABELIDS_PROPERTY_NAME);
        _isH5Client = BuildProperties.isH5Client();
    }

    private static class ImmutableDataContainer {
        private final Map<String, Set<String>> _iconPropertyNamesByObjectType;
        private final Map<String, Set<String>> _labelPropertyNamesByObjectType;
        private final Set<String> _allTypes;
        private final Map<String, List<IconLabelSpec>> _primaryIconSpecsByObjectType;
        private final Map<String, List<IconLabelSpec>> _secondaryIconSpecsByObjectType;
        private final Map<String, List<IconLabelSpec>> _primaryLabelSpecsByObjectType;
        private final Map<String, List<IconLabelSpec>> _secondaryLabelSpecsByObjectType;

        ImmutableDataContainer(ExtensionService extensionService, String string, String string2) throws Exception {
            Map<String, String> map = ImmutableDataContainer.initializePackageIdByObjectTypeMap(extensionService, string2);
            HashMap<String, List<IconLabelSpec>> hashMap = new HashMap<String, List<IconLabelSpec>>();
            HashMap<String, List<IconLabelSpec>> hashMap2 = new HashMap<String, List<IconLabelSpec>>();
            HashMap<String, List<IconLabelSpec>> hashMap3 = new HashMap<String, List<IconLabelSpec>>();
            HashMap<String, List<IconLabelSpec>> hashMap4 = new HashMap<String, List<IconLabelSpec>>();
            ImmutableDataContainer.buildSpecsByObjectTypeMaps(extensionService, string, map, hashMap, hashMap2, hashMap3, hashMap4);
            this._primaryIconSpecsByObjectType = CollectionUtil.getUnmodifiableMapOfLists(hashMap);
            this._secondaryIconSpecsByObjectType = CollectionUtil.getUnmodifiableMapOfLists(hashMap2);
            this._primaryLabelSpecsByObjectType = CollectionUtil.getUnmodifiableMapOfLists(hashMap3);
            this._secondaryLabelSpecsByObjectType = CollectionUtil.getUnmodifiableMapOfLists(hashMap4);
            Map<String, Set<String>> map2 = ImmutableDataContainer.buildPropertyNamesByObjectType(hashMap);
            Map<String, Set<String>> map3 = ImmutableDataContainer.buildPropertyNamesByObjectType(hashMap2);
            ArrayList<Map<String, Set<String>>> arrayList = new ArrayList<Map<String, Set<String>>>(2);
            arrayList.add(map2);
            arrayList.add(map3);
            this._iconPropertyNamesByObjectType = CollectionUtil.getUnmodifiableMapOfSets((Map)CollectionUtil.mergeSets(arrayList));
            Map<String, Set<String>> map4 = ImmutableDataContainer.buildPropertyNamesByObjectType(hashMap3);
            Map<String, Set<String>> map5 = ImmutableDataContainer.buildPropertyNamesByObjectType(hashMap4);
            ArrayList<Map<String, Set<String>>> arrayList2 = new ArrayList<Map<String, Set<String>>>(2);
            arrayList2.add(map4);
            arrayList2.add(map5);
            this._labelPropertyNamesByObjectType = CollectionUtil.getUnmodifiableMapOfSets((Map)CollectionUtil.mergeSets(arrayList2));
            HashSet hashSet = new HashSet();
            hashSet.addAll(hashMap.keySet());
            hashSet.addAll(hashMap2.keySet());
            hashSet.addAll(hashMap3.keySet());
            hashSet.addAll(hashMap4.keySet());
            this._allTypes = Collections.unmodifiableSet(hashSet);
        }

        private List<ResultItem> getResultItems(Map<Object, Map<String, Object>> map, Object[] objectArray, PropertySpec[] propertySpecArray) {
            ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
            for (Object object : objectArray) {
                ResultItem resultItem;
                Map<String, Object> map2 = map.get(object);
                if (map2 == null) {
                    map2 = Collections.emptyMap();
                }
                if ((resultItem = this.getResultItemWithRequestedProperties(object, map2, propertySpecArray)) == null) continue;
                arrayList.add(resultItem);
            }
            return arrayList;
        }

        private ResultItem getResultItemWithRequestedProperties(Object object, Map<String, Object> map, PropertySpec[] propertySpecArray) {
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = object;
            IconLabelSpec[] iconLabelSpecArray = IconsLabelsPropertyProviderAdapter.getSpecsSatisfyingProperties(this._primaryIconSpecsByObjectType, QueryUtil.getReferenceType((Object)object), map);
            IconLabelSpec[] iconLabelSpecArray2 = IconsLabelsPropertyProviderAdapter.getSpecsSatisfyingProperties(this._secondaryIconSpecsByObjectType, QueryUtil.getReferenceType((Object)object), map);
            IconLabelSpec[] iconLabelSpecArray3 = IconsLabelsPropertyProviderAdapter.getSpecsSatisfyingProperties(this._primaryLabelSpecsByObjectType, QueryUtil.getReferenceType((Object)object), map);
            IconLabelSpec[] iconLabelSpecArray4 = IconsLabelsPropertyProviderAdapter.getSpecsSatisfyingProperties(this._secondaryLabelSpecsByObjectType, QueryUtil.getReferenceType((Object)object), map);
            boolean bl = false;
            ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
            for (PropertySpec propertySpec : propertySpecArray) {
                for (String string : propertySpec.propertyNames) {
                    PropertyValue propertyValue = new PropertyValue();
                    propertyValue.propertyName = string;
                    propertyValue.resourceObject = object;
                    String string2 = null;
                    if (string.compareTo(IconsLabelsPropertyProviderAdapter.PRIMARY_ICONID_PROPERTY_NAME) == 0) {
                        string2 = IconsLabelsPropertyProviderAdapter.getIconPropertyFromSpecs(iconLabelSpecArray);
                        if (StringUtil.isNullOrEmpty((String)string2)) {
                            string2 = IconsLabelsPropertyProviderAdapter.getIconPropertyFromSpecs(iconLabelSpecArray2);
                        }
                    } else if (string.compareTo(IconsLabelsPropertyProviderAdapter.LABELIDS_PROPERTY_NAME) == 0) {
                        String string3 = IconsLabelsPropertyProviderAdapter.getLabelsPropertyFromSpecs(iconLabelSpecArray3);
                        String string4 = IconsLabelsPropertyProviderAdapter.getLabelsPropertyFromSpecs(iconLabelSpecArray4);
                        if (!StringUtil.isNullOrEmpty((String)string3) && !StringUtil.isNullOrEmpty((String)string4)) {
                            string2 = string3 + IconsLabelsPropertyProviderAdapter.DELIMITER + string4;
                        } else {
                            if (!StringUtil.isNullOrEmpty((String)string3)) {
                                string2 = string3;
                            }
                            if (!StringUtil.isNullOrEmpty((String)string4)) {
                                string2 = string4;
                            }
                        }
                    }
                    if (string2 == null) continue;
                    propertyValue.value = string2;
                    arrayList.add(propertyValue);
                    bl = true;
                }
            }
            if (!bl) {
                return null;
            }
            resultItem.properties = arrayList.toArray(QueryUtil.EMPTY_PROPERTY_VALUE_ARRAY);
            return resultItem;
        }

        private static Map<String, String> initializePackageIdByObjectTypeMap(ExtensionService extensionService, String string) throws Exception {
            ExtensionInfo[] extensionInfoArray = extensionService.getAllExtensionInfos(string);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (ExtensionInfo extensionInfo : extensionInfoArray) {
                String string2 = IconsLabelsPropertyProviderAdapter.getPackageIdFromExtensionInfo(extensionInfo, extensionService);
                List list = IconsLabelsPropertyProviderAdapter.getTypesFromObjectTypeInfoXml(extensionInfo.getObjectXmlStr());
                for (String string3 : list) {
                    if (!StringUtil.isNullOrEmpty((String)string3)) {
                        hashMap.put(string3, string2);
                        continue;
                    }
                    _logger.warn((Object)("Empty type in extension: " + extensionInfo.getId() + ", in plugin-package: " + string2));
                }
            }
            return hashMap;
        }

        private static void buildSpecsByObjectTypeMaps(ExtensionService extensionService, String string, Map<String, String> map, Map<String, List<IconLabelSpec>> map2, Map<String, List<IconLabelSpec>> map3, Map<String, List<IconLabelSpec>> map4, Map<String, List<IconLabelSpec>> map5) throws Exception {
            ExtensionInfo[] extensionInfoArray;
            for (ExtensionInfo extensionInfo : extensionInfoArray = extensionService.getAllExtensionInfos(string)) {
                try {
                    String string2;
                    String string3 = extensionInfo.getObjectXmlStr();
                    Element element = XMLUtil.parseXml((String)string3).getDocumentElement();
                    ObjectRepresentationSpec objectRepresentationSpec = IconsLabelsPropertyParser.createObjectFromXml(element, ObjectRepresentationSpec.class);
                    if (objectRepresentationSpec == null) {
                        _logger.warn((Object)("The object is null for the extension: " + extensionInfo.getId()));
                        continue;
                    }
                    String string4 = IconsLabelsPropertyProviderAdapter.getBundleNameFromExtensionInfo(extensionInfo, extensionService);
                    objectRepresentationSpec = IconsLabelsPropertyProviderAdapter.transformIconLabelIds(objectRepresentationSpec, string4);
                    String string5 = IconsLabelsPropertyProviderAdapter.getPackageIdFromExtensionInfo(extensionInfo, extensionService);
                    if (string5.equals(map.get(string2 = objectRepresentationSpec.objectType))) {
                        IconsLabelsPropertyProviderAdapter.addSpecsToSpecByObjectTypeMaps(map2, map4, string2, objectRepresentationSpec.specCollection);
                        continue;
                    }
                    IconsLabelsPropertyProviderAdapter.addSpecsToSpecByObjectTypeMaps(map3, map5, string2, objectRepresentationSpec.specCollection);
                }
                catch (Exception exception) {
                    _logger.error((Object)("Error processing IconLabelSpec in extension " + extensionInfo.getId()), (Throwable)exception);
                }
            }
        }

        private static Map<String, Set<String>> buildPropertyNamesByObjectType(Map<String, List<IconLabelSpec>> map) {
            HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
            for (Map.Entry<String, List<IconLabelSpec>> entry : map.entrySet()) {
                String string = entry.getKey();
                Set set = IconsLabelsPropertyProviderAdapter.extractPropertyNames(entry.getValue());
                if (set == null || set.isEmpty()) continue;
                hashMap.put(string, set);
            }
            return hashMap;
        }
    }
}

