/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.issue.impl;

import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class IssueAdapterBase
implements DataProviderAdapter {
    protected static final String GENERIC_ISSUE_TYPE = "Issue";
    private static final String PROPERTY_NAME_INFO = "info";
    private static final String PROPERTY_NAME_ENTITY = "info.entity";
    private static final Log _logger = LogFactory.getLog(IssueAdapterBase.class);
    protected static final Log _performanceLogger = LogFactory.getLog((String)"PerformanceAuditingLogger");
    private String _specificIssueType;
    private final ThreadPoolExecutor _executor;

    public IssueAdapterBase(String string) {
        this._specificIssueType = string;
        this._executor = null;
    }

    public IssueAdapterBase(String string, ThreadPoolExecutor threadPoolExecutor) {
        this._specificIssueType = string;
        this._executor = threadPoolExecutor;
    }

    public Response getData(RequestSpec requestSpec) {
        Object object;
        ValidationUtil.paramsNotNull((Object[])new Object[]{requestSpec});
        QuerySpec[] querySpecArray = requestSpec.querySpec;
        boolean bl = _performanceLogger.isInfoEnabled();
        long l = 0L;
        long l2 = 0L;
        if (bl) {
            l = System.currentTimeMillis();
        }
        ResultSet[] resultSetArray = this._executor != null && querySpecArray.length > 1 ? this.getResultSetsParallel(querySpecArray) : this.getResultSetsSequential(querySpecArray);
        if (bl && querySpecArray.length > 0) {
            l2 = System.currentTimeMillis();
            object = new StringBuilder("Total time for batch:[");
            ((StringBuilder)object).append(querySpecArray[0].name);
            for (int i = 1; i < querySpecArray.length; ++i) {
                ((StringBuilder)object).append(',').append(querySpecArray[i].name);
            }
            ((StringBuilder)object).append(String.format("] is %d milliseconds", l2 - l));
            _performanceLogger.info(object);
        }
        object = new Response();
        ((Response)object).resultSet = resultSetArray;
        return object;
    }

    private ResultSet[] getResultSetsParallel(QuerySpec[] querySpecArray) {
        final HttpSession httpSession = SessionUtil.getHttpSession();
        final RequestContext requestContext = new RequestContext();
        ResultSet[] resultSetArray = new ResultSet[querySpecArray.length];
        ArrayList<FutureTask<ResultSet>> arrayList = new ArrayList<FutureTask<ResultSet>>(querySpecArray.length);
        for (final QuerySpec querySpec : querySpecArray) {
            FutureTask<ResultSet> futureTask = new FutureTask<ResultSet>(new Callable<ResultSet>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ResultSet call() throws Exception {
                    try {
                        ResultSet resultSet;
                        SessionUtil.setHttpSession((HttpSession)httpSession);
                        boolean bl = _performanceLogger.isInfoEnabled();
                        long l = 0L;
                        long l2 = 0L;
                        if (bl) {
                            l = System.currentTimeMillis();
                        }
                        try {
                            resultSet = IssueAdapterBase.this.processQuerySpec(querySpec, requestContext);
                        }
                        catch (Exception exception) {
                            _logger.error((Object)("Error processing a query spec: " + querySpec.name), (Throwable)exception);
                            resultSet = IssueAdapterBase.this.createErrorResultSet(querySpec, exception);
                        }
                        if (bl) {
                            l2 = System.currentTimeMillis();
                            _performanceLogger.info((Object)String.format("%s: executed in %d ms.", querySpec.name, l2 - l));
                        }
                        ResultSet resultSet2 = resultSet;
                        return resultSet2;
                    }
                    finally {
                        SessionUtil.setHttpSession(null);
                    }
                }
            });
            this._executor.execute(futureTask);
            arrayList.add(futureTask);
        }
        for (int i = 0; i < querySpecArray.length; ++i) {
            FutureTask futureTask = (FutureTask)arrayList.get(i);
            try {
                resultSetArray[i] = (ResultSet)futureTask.get();
                continue;
            }
            catch (InterruptedException | ExecutionException exception) {
                _logger.error((Object)("Error processing query spec: " + Utils.renderQuerySpec((QuerySpec)querySpecArray[i])), (Throwable)exception);
                resultSetArray[i] = this.createErrorResultSet(querySpecArray[i], exception);
            }
        }
        return resultSetArray;
    }

    private ResultSet[] getResultSetsSequential(QuerySpec[] querySpecArray) {
        RequestContext requestContext = new RequestContext();
        ResultSet[] resultSetArray = new ResultSet[querySpecArray.length];
        boolean bl = _performanceLogger.isInfoEnabled();
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < querySpecArray.length; ++i) {
            if (bl) {
                l = System.currentTimeMillis();
            }
            try {
                resultSetArray[i] = this.processQuerySpec(querySpecArray[i], requestContext);
            }
            catch (Exception exception) {
                _logger.error((Object)"Error processing a query spec", (Throwable)exception);
                resultSetArray[i] = this.createErrorResultSet(querySpecArray[i], exception);
            }
            if (!bl) continue;
            l2 = System.currentTimeMillis();
            _performanceLogger.info((Object)String.format("%s: executed in %d ms.", querySpecArray[i].name, l2 - l));
        }
        return resultSetArray;
    }

    public String[] getProvidedTypes() {
        return new String[]{GENERIC_ISSUE_TYPE, this._specificIssueType};
    }

    protected abstract IssueData[] getIssues(QuerySpec var1, RequestContext var2);

    protected ResultItem processResultItem(ResultItem resultItem, IssueData issueData, RequestContext requestContext) {
        return resultItem;
    }

    protected ResultSet processResultSet(ResultSet resultSet, QuerySpec querySpec, RequestContext requestContext) {
        return resultSet;
    }

    protected Object extractEntityFromQuerySpec(QuerySpec querySpec) {
        if (querySpec == null || querySpec.resourceSpec == null || querySpec.resourceSpec.constraint == null || !(querySpec.resourceSpec.constraint instanceof PropertyConstraint)) {
            throw new IllegalArgumentException("Invalid query spec");
        }
        PropertyConstraint propertyConstraint = (PropertyConstraint)querySpec.resourceSpec.constraint;
        if (!Comparator.EQUALS.equals((Object)propertyConstraint.comparator) || !PROPERTY_NAME_ENTITY.equals(propertyConstraint.propertyName)) {
            throw new IllegalArgumentException("Invalid query spec");
        }
        return propertyConstraint.comparableValue;
    }

    private ResultSet processQuerySpec(QuerySpec querySpec, RequestContext requestContext) throws Exception {
        IssueData[] issueDataArray = this.getIssues(querySpec, requestContext);
        ResultSet resultSet = this.createResultSet(querySpec, issueDataArray, requestContext);
        resultSet = this.processResultSet(resultSet, querySpec, requestContext);
        return resultSet;
    }

    private ResultSet createResultSet(QuerySpec querySpec, IssueData[] issueDataArray, RequestContext requestContext) {
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        if (issueDataArray != null && issueDataArray.length != 0) {
            for (int i = 0; i < issueDataArray.length; ++i) {
                ResultItem resultItem = this.createResultItem(issueDataArray[i]);
                if ((resultItem = this.processResultItem(resultItem, issueDataArray[i], requestContext)) == null) continue;
                arrayList.add(resultItem);
            }
        }
        ResultSet resultSet = new ResultSet();
        resultSet.queryName = querySpec.name;
        resultSet.items = arrayList.toArray(new ResultItem[arrayList.size()]);
        resultSet.totalMatchedObjectCount = arrayList.size();
        return resultSet;
    }

    private ResultItem createResultItem(IssueData issueData) {
        if (issueData == null) {
            return null;
        }
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.propertyName = PROPERTY_NAME_INFO;
        propertyValue.value = issueData.issueInfo;
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = this.createIssueRef(issueData.key);
        resultItem.properties = new PropertyValue[]{propertyValue};
        return resultItem;
    }

    private Object createIssueRef(String string) {
        URI uRI = DefaultUriSchemeUtil.createUri((String)this._specificIssueType, (String)string);
        return uRI;
    }

    private ResultSet createErrorResultSet(QuerySpec querySpec, Throwable throwable) {
        ResultSet resultSet = new ResultSet();
        resultSet.queryName = querySpec.name;
        resultSet.totalMatchedObjectCount = 0;
        resultSet.items = new ResultItem[0];
        resultSet.error = MixedUtil.getMethodFault((Throwable)throwable);
        return resultSet;
    }

    protected static class RequestContext {
        public Object context;

        protected RequestContext() {
        }
    }

    protected static class IssueData {
        public String key;
        public IssueInfo issueInfo;
    }
}

