/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.mixed;

import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.mixed.SourceObjectsInfo;
import java.util.ArrayList;

public class SourceObjectsLocator {
    private static String VM_FOLDER_PROP = "vmFolder";
    private static String DC_PROP = "dc";
    private static String PARENT_PROP = "parent";
    private static String RP_PROP = "resourcePool";
    private static String HOST_PROP = "host";
    private static String CLUSTER_PROP = "cluster";
    private DataService _dataService;
    private ManagedObjectReference _entity;

    public SourceObjectsLocator(ManagedObjectReference managedObjectReference, DataService dataService) {
        this._entity = managedObjectReference;
        this._dataService = dataService;
    }

    public SourceObjectsInfo getSourceObjectInfo() throws Exception {
        SourceObjectsInfo sourceObjectsInfo = new SourceObjectsInfo();
        sourceObjectsInfo.hostedObject = this.getHostedObject();
        sourceObjectsInfo.vmFolder = this.getHostedVMFolder();
        return sourceObjectsInfo;
    }

    public ManagedObjectReference getHostedVMFolder() throws Exception {
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)this._entity, VirtualMachine.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)this._entity, VirtualApp.class)) {
            PropertyValue[] propertyValueArray = QueryUtil.getProperties((DataService)this._dataService, (Object)this._entity, (String[])new String[]{VM_FOLDER_PROP, DC_PROP});
            ManagedObjectReference managedObjectReference = null;
            Object[] objectArray = null;
            for (int i = 0; i < propertyValueArray.length; ++i) {
                if (DC_PROP.equals(propertyValueArray[i].propertyName)) {
                    managedObjectReference = (ManagedObjectReference)propertyValueArray[i].value;
                    continue;
                }
                if (!VM_FOLDER_PROP.equals(propertyValueArray[i].propertyName)) continue;
                objectArray = (Object[])propertyValueArray[i].value;
            }
            if (objectArray == null) {
                return null;
            }
            if (objectArray.length == 1) {
                return managedObjectReference;
            }
            return (ManagedObjectReference)objectArray[0];
        }
        return null;
    }

    public ManagedObjectReference getHostedObject() throws Exception {
        ManagedObjectReference managedObjectReference = this.retrieveHostedObject(this._entity, null);
        return managedObjectReference;
    }

    private ManagedObjectReference retrieveHostedObject(ManagedObjectReference managedObjectReference, ManagedObjectReference managedObjectReference2) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, VirtualMachine.class)) {
            arrayList.add(RP_PROP);
            arrayList.add(HOST_PROP);
            arrayList.add(CLUSTER_PROP);
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, ComputeResource.class)) {
            arrayList.add(HOST_PROP);
        } else {
            arrayList.add(PARENT_PROP);
        }
        PropertyValue[] propertyValueArray = QueryUtil.getProperties((DataService)this._dataService, (Object)managedObjectReference, (String[])arrayList.toArray(new String[0]));
        if (propertyValueArray == null || propertyValueArray.length == 0) {
            return null;
        }
        ManagedObjectReference managedObjectReference3 = ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, VirtualMachine.class) ? this.getVmHostedObject(propertyValueArray) : this.getManagedObjectReference(propertyValueArray[0].value);
        boolean bl = ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference3, Folder.class);
        boolean bl2 = ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference3, ResourcePool.class);
        boolean bl3 = ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference3, VirtualApp.class);
        if (bl3 && managedObjectReference2 != null) {
            return managedObjectReference2;
        }
        if (bl || bl2) {
            if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)managedObjectReference3)) {
                return managedObjectReference2 == null ? managedObjectReference3 : managedObjectReference2;
            }
            managedObjectReference3 = managedObjectReference2 == null || !ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference2, (String)managedObjectReference3.getType()) ? this.retrieveHostedObject(managedObjectReference3, managedObjectReference3) : managedObjectReference;
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference3, ComputeResource.class)) {
            managedObjectReference3 = this.retrieveHostedObject(managedObjectReference3, managedObjectReference);
        }
        return managedObjectReference3;
    }

    private ManagedObjectReference getVmHostedObject(PropertyValue[] propertyValueArray) {
        ManagedObjectReference managedObjectReference = null;
        ManagedObjectReference managedObjectReference2 = null;
        ManagedObjectReference managedObjectReference3 = null;
        for (PropertyValue propertyValue : propertyValueArray) {
            if (RP_PROP.equals(propertyValue.propertyName)) {
                managedObjectReference = (ManagedObjectReference)propertyValue.value;
                continue;
            }
            if (HOST_PROP.equals(propertyValue.propertyName)) {
                managedObjectReference2 = (ManagedObjectReference)propertyValue.value;
                continue;
            }
            if (!CLUSTER_PROP.equals(propertyValue.propertyName)) continue;
            managedObjectReference3 = (ManagedObjectReference)propertyValue.value;
        }
        if (managedObjectReference != null) {
            return managedObjectReference;
        }
        if (managedObjectReference3 != null) {
            return managedObjectReference3;
        }
        if (managedObjectReference2 != null) {
            return managedObjectReference2;
        }
        return null;
    }

    private ManagedObjectReference getManagedObjectReference(Object object) {
        if (object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            return (ManagedObjectReference)objectArray[0];
        }
        return (ManagedObjectReference)object;
    }
}

