/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.navigator.impl;

import com.vmware.vim.binding.vim.cdc.AlarmChange;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.liveupdates.LiveUpdatesUtil;
import com.vmware.vise.vim.commons.messaging.AlarmChangeProcessor;
import com.vmware.vise.vim.commons.messaging.NavTreeUpdate;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.commons.messaging.PartialUpdateItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NavTreeAlarmChangeProcessor
implements AlarmChangeProcessor<NavTreeUpdate> {
    private final ConfigurationService _configurationService;

    public NavTreeAlarmChangeProcessor(ConfigurationService configurationService) {
        this._configurationService = configurationService;
    }

    public PartialUpdate<NavTreeUpdate> process(Collection<AlarmChange> collection, String string) {
        PartialUpdate partialUpdate = PartialUpdate.empty();
        if (!LiveUpdatesUtil.navTreeEnabled((ConfigurationService)this._configurationService) && !LiveUpdatesUtil.listsEnabled((ConfigurationService)this._configurationService)) {
            return null;
        }
        partialUpdate.setDestination("/topic/navTree");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (AlarmChange alarmChange : collection) {
            ManagedObjectReference managedObjectReference;
            String string2 = alarmChange.getKind();
            if (!AlarmChange.Kind.triggered.name().equals(string2) && !AlarmChange.Kind.cleared.name().equals(string2) && !AlarmChange.Kind.retriggered.name().equals(string2) || (managedObjectReference = alarmChange.getEntity()) == null) continue;
            arrayList.add(managedObjectReference);
        }
        if (arrayList.isEmpty()) {
            return partialUpdate;
        }
        partialUpdate.updates = this.createNavTreeUpdates(arrayList);
        return partialUpdate;
    }

    private List<PartialUpdateItem<NavTreeUpdate>> createNavTreeUpdates(List<Object> list) {
        ArrayList<PartialUpdateItem<NavTreeUpdate>> arrayList = new ArrayList<PartialUpdateItem<NavTreeUpdate>>();
        for (Object object : list) {
            NavTreeUpdate navTreeUpdate = new NavTreeUpdate(0);
            PartialUpdateItem partialUpdateItem = PartialUpdateItem.of((Object)navTreeUpdate, (Object)object);
            arrayList.add((PartialUpdateItem<NavTreeUpdate>)partialUpdateItem);
        }
        return arrayList;
    }
}

