/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.navigator.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vsphere.client.navigator.QuerySpecChainElement;
import java.util.ArrayList;

public class QueryTransformer {
    private static String SPEC_SUPPORTED_TOKEN = "{objectRef}";

    public static QuerySpec generateReverseQuery(QuerySpecChainElement querySpecChainElement, Object object) {
        QuerySpec querySpec = querySpecChainElement.object;
        if (querySpec == null || querySpec.resourceSpec == null) {
            return null;
        }
        String string = QueryTransformer.extractTargetType(querySpecChainElement.nextObject);
        Constraint constraint = QueryTransformer.reverseConstraint(querySpec.resourceSpec.constraint, object, string);
        if (constraint == null) {
            return null;
        }
        QuerySpec querySpec2 = new QuerySpec();
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = constraint;
        resourceSpec.propertySpecs = querySpec.resourceSpec.propertySpecs;
        querySpec2.resourceSpec = resourceSpec;
        querySpec2.name = querySpec.name;
        querySpec2.options = querySpec.options;
        querySpec2.resultSpec = querySpec.resultSpec;
        return querySpec2;
    }

    public static void assignRelatedObjectToQuery(QuerySpec querySpec, Object object) {
        if (querySpec == null || querySpec.resourceSpec == null) {
            return;
        }
        if (querySpec.resourceSpec.constraint instanceof RelationalConstraint) {
            RelationalConstraint relationalConstraint = (RelationalConstraint)querySpec.resourceSpec.constraint;
            QueryTransformer.assignRelatedObjectToConstraint(relationalConstraint, object);
        }
    }

    public static void assignRelatedObjectToConstraint(RelationalConstraint relationalConstraint, Object object) {
        ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
        objectIdentityConstraint.target = object;
        objectIdentityConstraint.targetType = QueryUtil.getReferenceType((Object)object);
        boolean bl = true;
        while (bl) {
            if (relationalConstraint.constraintOnRelatedObject instanceof RelationalConstraint) {
                relationalConstraint = (RelationalConstraint)relationalConstraint.constraintOnRelatedObject;
                continue;
            }
            if (relationalConstraint.constraintOnRelatedObject == null || relationalConstraint.constraintOnRelatedObject instanceof ObjectIdentityConstraint) {
                relationalConstraint.constraintOnRelatedObject = objectIdentityConstraint;
            }
            bl = false;
        }
    }

    public static Constraint reverseConstraint(Constraint constraint, Object object, String string) {
        ArrayList<RelationalConstraint> arrayList = QueryTransformer.extractRelationalConstraints(constraint);
        for (RelationalConstraint relationalConstraint : arrayList) {
            RelationalConstraint relationalConstraint2 = QueryTransformer.reverseRelationalConstraint(relationalConstraint);
            if (relationalConstraint2 == null) continue;
            relationalConstraint2.targetType = string;
            if (object != null) {
                QueryTransformer.assignRelatedObjectToConstraint(relationalConstraint, object);
            }
            return relationalConstraint2;
        }
        return null;
    }

    public static RelationalConstraint reverseRelationalConstraint(RelationalConstraint relationalConstraint) {
        if (relationalConstraint == null || relationalConstraint.constraintOnRelatedObject == null) {
            return null;
        }
        RelationalConstraint relationalConstraint2 = new RelationalConstraint();
        relationalConstraint2.relation = relationalConstraint.relation;
        relationalConstraint2.targetType = relationalConstraint.targetType;
        relationalConstraint2.constraintOnRelatedObject = relationalConstraint.constraintOnRelatedObject;
        boolean bl = relationalConstraint2.hasInverseRelation = !relationalConstraint.hasInverseRelation;
        if (QueryTransformer.isTokenizedOIC(relationalConstraint2.constraintOnRelatedObject)) {
            relationalConstraint2.constraintOnRelatedObject = null;
            return relationalConstraint2;
        }
        ArrayList<RelationalConstraint> arrayList = QueryTransformer.extractRelationalConstraints(relationalConstraint2.constraintOnRelatedObject);
        if (arrayList == null) {
            return null;
        }
        relationalConstraint2.constraintOnRelatedObject = null;
        for (RelationalConstraint relationalConstraint3 : arrayList) {
            relationalConstraint2.targetType = relationalConstraint3.targetType;
            if ((relationalConstraint3 = QueryTransformer.reverseRelationalConstraint(relationalConstraint3)) == null) continue;
            QueryTransformer.appendToRelationalChain(relationalConstraint3, (Constraint)relationalConstraint2);
            return relationalConstraint3;
        }
        return null;
    }

    private static boolean isTokenizedOIC(Constraint constraint) {
        if (!(constraint instanceof ObjectIdentityConstraint)) {
            return false;
        }
        ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)constraint;
        if (objectIdentityConstraint.target == null) {
            return false;
        }
        return objectIdentityConstraint.target.equals(SPEC_SUPPORTED_TOKEN);
    }

    private static ArrayList<RelationalConstraint> extractRelationalConstraints(Constraint constraint) {
        ArrayList<RelationalConstraint> arrayList = new ArrayList<RelationalConstraint>();
        if (constraint instanceof RelationalConstraint) {
            arrayList.add((RelationalConstraint)constraint);
        } else if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            for (Constraint constraint2 : compositeConstraint.nestedConstraints) {
                ArrayList<RelationalConstraint> arrayList2 = QueryTransformer.extractRelationalConstraints(constraint2);
                arrayList.addAll(arrayList2);
            }
        }
        return arrayList;
    }

    private static void appendToRelationalChain(RelationalConstraint relationalConstraint, Constraint constraint) {
        boolean bl = false;
        while (!bl) {
            if (relationalConstraint.constraintOnRelatedObject == null) {
                relationalConstraint.constraintOnRelatedObject = constraint;
                bl = true;
                continue;
            }
            relationalConstraint = (RelationalConstraint)relationalConstraint.constraintOnRelatedObject;
        }
    }

    private static String extractTargetType(QuerySpecChainElement querySpecChainElement) {
        if (querySpecChainElement != null && querySpecChainElement.object != null && querySpecChainElement.object.resourceSpec != null && querySpecChainElement.object.resourceSpec.constraint != null) {
            return querySpecChainElement.object.resourceSpec.constraint.targetType;
        }
        return null;
    }
}

