/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.task.impl;

import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.TaskFilterSpec;
import com.vmware.vim.binding.vim.TaskHistoryCollector;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.TaskManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vise.util.concurrent.QueuingCachedThreadPool;
import com.vmware.vise.util.concurrent.ThreadPoolFactory;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.util.profiling.ExecutionProfiler;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.task.TaskSearchHelper;
import com.vmware.vsphere.client.task.impl.ClientTaskInfoPostProcessor;
import com.vmware.vsphere.client.task.impl.TaskCollectorData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="vsphere:Task")
public class TaskSearchAdapter
implements DataProviderAdapter {
    private static final String LIVE_UPDATES_CAPABLE_TASKS = "liveUpdatesCapableTasks";
    private static final Log _logger = LogFactory.getLog(TaskSearchAdapter.class);
    private static final ResultItem[] EMPTY_RESULT_ITEM_ARR = new ResultItem[0];
    private static final String[] PROVIDED_TYPES = new String[]{"vsphere:Task"};
    private static final String TASK_SEARCH_ADAPTER_PREFIX = "taskSearchAdapter";
    private static final String POOL_NAME = "task-search-adapter-pool";
    private static final ExecutorService EXECUTOR = ThreadPoolFactory.newQueingCachedThreadPool((int)400, (ThreadFactory)new WorkerThreadFactory("task-search-adapter-pool"), (long)10L, (TimeUnit)TimeUnit.MINUTES, (long)1L, (TimeUnit)TimeUnit.MINUTES, (QueuingCachedThreadPool.TaskExpirationPolicy)QueuingCachedThreadPool.TaskExpirationPolicy.CALLER_RUNS);
    private final DataService _dataService;
    private final ClientTaskInfoPostProcessor _taskPostProcessor;
    private final TaskSearchHelper _taskSearchHelper;

    public TaskSearchAdapter(DataService dataService, ClientTaskInfoPostProcessor clientTaskInfoPostProcessor, TaskSearchHelper taskSearchHelper) {
        this._dataService = dataService;
        this._taskPostProcessor = clientTaskInfoPostProcessor;
        this._taskSearchHelper = taskSearchHelper;
    }

    public Response getData(RequestSpec requestSpec) throws InterruptedException {
        ValidationUtil.paramsNotNull((Object[])new Object[]{requestSpec});
        QuerySpec[] querySpecArray = requestSpec.querySpec;
        ExecutionProfiler executionProfiler = SessionUtil.getExecutionProfiler();
        if (querySpecArray.length == 1) {
            ResultSet[] resultSetArray = new ResultSet[1];
            Response response = new Response();
            response.resultSet = resultSetArray;
            resultSetArray[0] = this.processQuery(querySpecArray[0], executionProfiler);
            return response;
        }
        Response response = this.runQueriesInParallel(querySpecArray, executionProfiler);
        return response;
    }

    private Response runQueriesInParallel(QuerySpec[] querySpecArray, ExecutionProfiler executionProfiler) throws InterruptedException {
        Response response;
        ArrayList arrayList = new ArrayList(querySpecArray.length - 1);
        for (int i = 1; i < querySpecArray.length; ++i) {
            response = this.getCallableResultSet(querySpecArray[i], executionProfiler);
            Future future = EXECUTOR.submit(response);
            arrayList.add(future);
        }
        ResultSet[] resultSetArray = new ResultSet[querySpecArray.length];
        response = new Response();
        response.resultSet = resultSetArray;
        resultSetArray[0] = this.processQuery(querySpecArray[0], executionProfiler);
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                resultSetArray[i + 1] = (ResultSet)((Future)arrayList.get(i)).get();
                continue;
            }
            catch (ExecutionException executionException) {
                TaskSearchAdapter.handleExecutionException("Error running Task Query: ", executionException);
            }
        }
        return response;
    }

    private Callable<ResultSet> getCallableResultSet(final QuerySpec querySpec, final ExecutionProfiler executionProfiler) {
        final SessionUtil.ThreadContext threadContext = SessionUtil.getThreadContext();
        Callable<ResultSet> callable = new Callable<ResultSet>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ResultSet call() throws InterruptedException {
                SessionUtil.ThreadContext threadContext2 = SessionUtil.getThreadContext((boolean)false);
                SessionUtil.setThreadContext((SessionUtil.ThreadContext)threadContext);
                try {
                    ResultSet resultSet;
                    ResultSet resultSet2 = resultSet = TaskSearchAdapter.this.processQuery(querySpec, executionProfiler);
                    return resultSet2;
                }
                finally {
                    SessionUtil.setThreadContext((SessionUtil.ThreadContext)threadContext2);
                }
            }
        };
        return callable;
    }

    public String[] getProvidedTypes() {
        return PROVIDED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet processQuery(QuerySpec querySpec, ExecutionProfiler executionProfiler) throws InterruptedException {
        if (querySpec.resourceSpec == null || querySpec.resourceSpec.propertySpecs == null || querySpec.resourceSpec.propertySpecs.length == 0 || querySpec.resourceSpec.propertySpecs[0].propertyNames == null || querySpec.resourceSpec.propertySpecs[0].propertyNames.length == 0 || !querySpec.resourceSpec.propertySpecs[0].propertyNames[0].equals("info")) {
            return null;
        }
        if (querySpec.options != null && Boolean.FALSE.equals(querySpec.options.get(LIVE_UPDATES_CAPABLE_TASKS))) {
            return new ResultSet();
        }
        ResultSet resultSet = null;
        CopyOnWriteArrayList<Exception> copyOnWriteArrayList = new CopyOnWriteArrayList<Exception>();
        String string = querySpec.name;
        TaskFilter taskFilter = null;
        List<TaskCollectorData> list = null;
        int n = 50;
        if (querySpec.resultSpec.maxResultCount != null && querySpec.resultSpec.maxResultCount > 0) {
            n = querySpec.resultSpec.maxResultCount;
        }
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            String string2 = "taskSearchAdapter." + string + ".filter";
            Object object7 = executionProfiler.startTimer(string2);
            try {
                taskFilter = TaskSearchAdapter.getFilter(querySpec);
                list = TaskSearchAdapter.createTaskCollectors(taskFilter, copyOnWriteArrayList);
            }
            finally {
                executionProfiler.stopTimer(object7);
            }
            Set<String> set = TaskSearchAdapter.getRootTasks(taskFilter);
            List<TaskInfo> list2 = new ArrayList<TaskInfo>();
            String string3 = "taskSearchAdapter." + string + ".search";
            Object object8 = executionProfiler.startTimer(string3);
            try {
                if (taskFilter.recentTasks) {
                    object6 = this.getRecentTaskInfoCallables(taskFilter, list, copyOnWriteArrayList, set, n);
                    object5 = ExecutorUtil.executeTasks(object6, (Executor)EXECUTOR, (long)-1L, null, (boolean)false, (boolean)false, (boolean)true);
                    object4 = object5.iterator();
                    while (object4.hasNext()) {
                        object3 = (ExecutorUtil.TaskResult)object4.next();
                        if (object3.getResult() == null) continue;
                        list2.addAll((Collection)object3.getResult());
                        if (list2.size() > n) {
                            list2 = TaskSearchAdapter.getMostRecentTasks(list2, n);
                        }
                        if ((object2 = object3.getException()) == null) continue;
                        copyOnWriteArrayList.add((Exception)object2);
                    }
                } else {
                    object6 = this.getCollectorTaskInfoCallables(list, taskFilter, copyOnWriteArrayList, set);
                    object5 = ExecutorUtil.executeTasks(object6, (Executor)EXECUTOR);
                    int n2 = (taskFilter.currentPage + 1) * taskFilter.count;
                    object3 = object5.iterator();
                    while (object3.hasNext()) {
                        object2 = (ExecutorUtil.TaskResult)object3.next();
                        if (object2.getResult() == null) continue;
                        list2.addAll((Collection)object2.getResult());
                        if (list2.size() > n2) {
                            list2 = TaskSearchAdapter.getMostRecentTasks(list2, n2);
                        }
                        if ((object = object2.getException()) == null) continue;
                        copyOnWriteArrayList.add((Exception)object);
                    }
                    if (object6.size() > 1) {
                        list2 = TaskSearchAdapter.getRequestedPage(taskFilter, list2);
                    }
                }
            }
            finally {
                executionProfiler.stopTimer(object8);
            }
            object6 = "taskSearchAdapter." + string + ".postProcess";
            object5 = executionProfiler.startTimer((String)object6);
            object4 = this.getClientTaskInfos(list2);
            object3 = TaskSearchAdapter.getUniqueEntities((Map<TaskInfo, ClientTaskInfo>)object4);
            object2 = object4.values();
            try {
                this._taskPostProcessor.process((Collection<ClientTaskInfo>)object2, (Set<ManagedObjectReference>)object3);
            }
            finally {
                executionProfiler.stopTimer(object5);
            }
            object = "taskSearchAdapter." + string + ".search";
            Object object9 = executionProfiler.startTimer((String)object);
            try {
                resultSet = TaskSearchAdapter.createResultSet((Collection<ClientTaskInfo>)object2, querySpec);
                List<ResultItem> list3 = this.getPreviousTasks(taskFilter, (Collection<ClientTaskInfo>)object2, querySpec, executionProfiler);
                if (!list3.isEmpty()) {
                    ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
                    arrayList.addAll(Arrays.asList(resultSet.items));
                    arrayList.addAll(list3);
                    resultSet.items = arrayList.toArray(EMPTY_RESULT_ITEM_ARR);
                }
            }
            finally {
                executionProfiler.stopTimer(object9);
            }
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        catch (Exception exception) {
            _logger.error((Object)"Error processing task adapter query: ", (Throwable)exception);
            copyOnWriteArrayList.add((Exception)MixedUtil.getMethodFault((Throwable)exception));
            resultSet = new ResultSet();
            resultSet.totalMatchedObjectCount = 0;
        }
        if (copyOnWriteArrayList.size() > 0) {
            resultSet.error = new CompositeException(copyOnWriteArrayList);
        }
        return resultSet;
    }

    private List<Callable<List<TaskInfo>>> getRecentTaskInfoCallables(final TaskFilter taskFilter, List<TaskCollectorData> list, final CopyOnWriteArrayList<Exception> copyOnWriteArrayList, final Set<String> set, final int n) {
        ArrayList<Callable<List<TaskInfo>>> arrayList = new ArrayList<Callable<List<TaskInfo>>>(list.size());
        Iterator<TaskCollectorData> iterator = list.iterator();
        while (iterator.hasNext()) {
            TaskCollectorData taskCollectorData;
            final TaskCollectorData taskCollectorData2 = taskCollectorData = iterator.next();
            Callable<List<TaskInfo>> callable = new Callable<List<TaskInfo>>(){

                @Override
                public List<TaskInfo> call() throws Exception {
                    Object object;
                    ResultSet resultSet = TaskSearchAdapter.this.getRecentTasks(taskCollectorData2, copyOnWriteArrayList);
                    if (resultSet.error != null && (object = TaskSearchAdapter.this._taskSearchHelper.filterPermissionExceptions((Exception)MixedUtil.getMethodFault((Throwable)resultSet.error))) != null) {
                        copyOnWriteArrayList.add(object);
                    }
                    object = TaskSearchAdapter.this.getTasksFromResultSet(taskFilter, resultSet, taskCollectorData2, set);
                    List list = TaskSearchAdapter.getMostRecentTasks((List)object, n);
                    return list;
                }
            };
            arrayList.add(callable);
        }
        return arrayList;
    }

    private List<Callable<List<TaskInfo>>> getCollectorTaskInfoCallables(List<TaskCollectorData> list, final TaskFilter taskFilter, final CopyOnWriteArrayList<Exception> copyOnWriteArrayList, final Set<String> set) {
        ArrayList<Callable<List<TaskInfo>>> arrayList = new ArrayList<Callable<List<TaskInfo>>>(list.size());
        final boolean bl = list.size() > 1;
        Iterator<TaskCollectorData> iterator = list.iterator();
        while (iterator.hasNext()) {
            TaskCollectorData taskCollectorData;
            final TaskCollectorData taskCollectorData2 = taskCollectorData = iterator.next();
            Callable<List<TaskInfo>> callable = new Callable<List<TaskInfo>>(){

                @Override
                public List<TaskInfo> call() throws Exception {
                    List list = TaskSearchAdapter.getTaskInfosFromVc(taskFilter, taskCollectorData2, copyOnWriteArrayList, set, bl);
                    return list;
                }
            };
            arrayList.add(callable);
        }
        return arrayList;
    }

    private List<ResultItem> getPreviousTasks(TaskFilter taskFilter, Collection<ClientTaskInfo> collection, QuerySpec querySpec, ExecutionProfiler executionProfiler) throws InterruptedException {
        if (ArrayUtil.isNullOrEmpty((Object[])taskFilter.migrationHistoryList) || collection.size() >= taskFilter.count) {
            return Collections.emptyList();
        }
        ManagedObjectReference managedObjectReference = taskFilter.taskFilterSpec.entity.entity;
        int n = taskFilter.count - collection.size();
        ManagedObjectReference managedObjectReference2 = null;
        for (int i = 0; i < taskFilter.migrationHistoryList.length - 1; ++i) {
            if (!ManagedObjectUtil.areEqual((ManagedObjectReference)managedObjectReference, (ManagedObjectReference)taskFilter.migrationHistoryList[i]).booleanValue()) continue;
            managedObjectReference2 = taskFilter.migrationHistoryList[i + 1];
        }
        if (managedObjectReference2 == null) {
            return Collections.emptyList();
        }
        QuerySpec querySpec2 = this._taskSearchHelper.makeReplacementQuerySpec(querySpec, managedObjectReference2, n);
        ResultSet resultSet = this.processQuery(querySpec2, executionProfiler);
        if (resultSet == null) {
            return Collections.emptyList();
        }
        ResultItem[] resultItemArray = resultSet.items;
        if (resultItemArray == null || resultItemArray.length == 0) {
            return Collections.emptyList();
        }
        List<ResultItem> list = Arrays.asList(resultItemArray);
        return list;
    }

    private static ResultSet createResultSet(Collection<ClientTaskInfo> collection, QuerySpec querySpec) {
        ResultSet resultSet = new ResultSet();
        resultSet.totalMatchedObjectCount = collection.size();
        resultSet.items = new ResultItem[collection.size()];
        int n = 0;
        for (ClientTaskInfo clientTaskInfo : collection) {
            ResultItem resultItem = new ResultItem();
            PropertyValue propertyValue = new PropertyValue();
            propertyValue.propertyName = "info";
            propertyValue.value = clientTaskInfo;
            resultItem.properties = new PropertyValue[]{propertyValue};
            resultItem.resourceObject = clientTaskInfo.taskRef;
            resultSet.items[n++] = resultItem;
        }
        return resultSet;
    }

    private static TaskFilter getFilter(QuerySpec querySpec) {
        Constraint[] constraintArray;
        TaskFilter taskFilter = new TaskFilter();
        int n = taskFilter.count = querySpec.resultSpec.maxResultCount != null ? querySpec.resultSpec.maxResultCount : -1;
        if (taskFilter.count == -1) {
            taskFilter.count = 50;
        }
        taskFilter.taskFilterSpec = new TaskFilterSpec();
        Constraint constraint = querySpec.resourceSpec.constraint;
        if (constraint == null) {
            return taskFilter;
        }
        if (constraint instanceof PropertyConstraint) {
            constraintArray = new PropertyConstraint[]{(PropertyConstraint)constraint};
        } else if (constraint instanceof CompositeConstraint) {
            constraintArray = ((CompositeConstraint)constraint).nestedConstraints;
        } else {
            String string = "Invalid query constraint for TaskDataAdapter: " + constraint.getClass().getName();
            _logger.error((Object)string);
            throw new IllegalArgumentException(string);
        }
        for (Constraint constraint2 : constraintArray) {
            Object object;
            if (!(constraint2 instanceof PropertyConstraint) || !((PropertyConstraint)constraint2).comparator.equals((Object)Comparator.EQUALS)) {
                object = "Invalid query constraint or comparator in TaskDataAdapter: " + constraint2.getClass().getName();
                _logger.error(object);
                continue;
            }
            object = ((PropertyConstraint)constraint2).comparableValue;
            String string = ((PropertyConstraint)constraint2).propertyName;
            if ("info.initiator".equals(string)) {
                taskFilter.taskFilterSpec.userName = (TaskFilterSpec.ByUsername)object;
                continue;
            }
            if ("info.entity".equals(string)) {
                taskFilter.taskFilterSpec.entity = new TaskFilterSpec.ByEntity();
                taskFilter.taskFilterSpec.entity.entity = (ManagedObjectReference)object;
                taskFilter.taskFilterSpec.entity.recursion = TaskFilterSpec.RecursionOption.all;
                continue;
            }
            if ("info.recentTasks".equals(string)) {
                taskFilter.recentTasks = true;
                continue;
            }
            if ("info.activeTasks".equals(string)) {
                taskFilter.taskFilterSpec.state = new TaskInfo.State[]{TaskInfo.State.running, TaskInfo.State.queued};
                taskFilter.activeTasks = true;
                continue;
            }
            if ("info.rootTasks".equals(string)) {
                Object[] objectArray = (Object[])object;
                int n2 = objectArray.length;
                String[] stringArray = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    stringArray[i] = objectArray[i].toString();
                }
                taskFilter.rootTaskKey = stringArray;
                continue;
            }
            if ("info.maxResultsPerSource".equals(string)) {
                taskFilter.count = (Integer)object;
                continue;
            }
            if ("info.currentPage".equals(string)) {
                taskFilter.currentPage = (Integer)object;
                continue;
            }
            if (string.equals("migrationHistoryList")) {
                taskFilter.migrationHistoryList = TaskSearchAdapter.createMORArray((Object[])object);
                continue;
            }
            if (string.equals("requestingPrevPage")) {
                taskFilter.requestingPrevPage = (Boolean)object;
                continue;
            }
            throw new IllegalArgumentException("Invalid property constraint " + string);
        }
        return taskFilter;
    }

    private ResultSet getRecentTasks(TaskCollectorData taskCollectorData, List<Exception> list) {
        QuerySpec querySpec = this._taskSearchHelper.getRecentTasksQuerySpec(taskCollectorData.moRef);
        ResultSet resultSet = null;
        try {
            resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)querySpec);
        }
        catch (Exception exception) {
            list.add(exception);
            return null;
        }
        return resultSet;
    }

    private static List<TaskInfo> getRequestedPage(TaskFilter taskFilter, List<TaskInfo> list) {
        int n = taskFilter.count * taskFilter.currentPage;
        if (list.size() <= n) {
            return Collections.emptyList();
        }
        ArrayList<TaskInfo> arrayList = new ArrayList<TaskInfo>(list.subList(n, list.size()));
        return arrayList;
    }

    private List<TaskInfo> getTasksFromResultSet(TaskFilter taskFilter, ResultSet resultSet, TaskCollectorData taskCollectorData, Set<String> set) {
        ResultItem[] resultItemArray;
        if (resultSet == null) {
            return Collections.emptyList();
        }
        String string = taskFilter.getUsername();
        if (string != null) {
            string = this._taskSearchHelper.getSessionUser(taskCollectorData.moRef);
        }
        if ((resultItemArray = resultSet.items) == null || resultItemArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<TaskInfo> arrayList = new ArrayList<TaskInfo>(resultItemArray.length);
        for (ResultItem resultItem : resultItemArray) {
            TaskInfo taskInfo;
            if (resultItem.properties == null || resultItem.properties.length == 0 || resultItem.properties[0] == null || !(resultItem.properties[0].value instanceof TaskInfo) || !this._taskSearchHelper.taskBelongsToUser(taskInfo = (TaskInfo)resultItem.properties[0].value, string) || !TaskSearchAdapter.taskIncludedInRootFilter(set, taskInfo).booleanValue()) continue;
            arrayList.add(taskInfo);
        }
        return arrayList;
    }

    private static List<TaskInfo> getMostRecentTasks(List<TaskInfo> list, int n) {
        assert (n > 0);
        if (list.isEmpty()) {
            return list;
        }
        TreeMap<Long, TaskInfo> treeMap = new TreeMap<Long, TaskInfo>();
        for (TaskInfo taskInfo : list) {
            Calendar calendar = taskInfo.startTime;
            if (calendar == null) continue;
            long l = calendar.getTimeInMillis();
            if (treeMap.size() < n) {
                treeMap.put(l, taskInfo);
                continue;
            }
            Long l2 = (Long)treeMap.firstKey();
            if (l <= l2) continue;
            treeMap.remove(l2);
            treeMap.put(l, taskInfo);
        }
        return new ArrayList<TaskInfo>(treeMap.values());
    }

    private Map<TaskInfo, ClientTaskInfo> getClientTaskInfos(List<TaskInfo> list) {
        HashMap<TaskInfo, ClientTaskInfo> hashMap = new HashMap<TaskInfo, ClientTaskInfo>(list.size());
        for (TaskInfo taskInfo : list) {
            ClientTaskInfo clientTaskInfo = this._taskSearchHelper.getClientTaskInfo(taskInfo);
            hashMap.put(taskInfo, clientTaskInfo);
        }
        return hashMap;
    }

    private static Set<ManagedObjectReference> getUniqueEntities(Map<TaskInfo, ClientTaskInfo> map) {
        HashSet<ManagedObjectReference> hashSet = new HashSet<ManagedObjectReference>();
        for (TaskInfo object : map.keySet()) {
            if (object.entity != null) {
                hashSet.add(object.entity);
            }
            if (object.result == null || !(object.result instanceof ManagedObjectReference)) continue;
            hashSet.add((ManagedObjectReference)object.result);
        }
        for (Map.Entry entry : map.entrySet()) {
            TaskInfo taskInfo = (TaskInfo)entry.getKey();
            ClientTaskInfo clientTaskInfo = (ClientTaskInfo)entry.getValue();
            if (taskInfo.entity == null || clientTaskInfo.entity != null) continue;
            hashSet.remove(taskInfo.entity);
        }
        return hashSet;
    }

    private static Set<String> getRootTasks(TaskFilter taskFilter) {
        String[] stringArray = taskFilter.rootTaskKey;
        if (stringArray == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        Collections.addAll(hashSet, stringArray);
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<TaskInfo> getTaskInfosFromVc(TaskFilter taskFilter, TaskCollectorData taskCollectorData, List<Exception> list, Set<String> set, boolean bl) {
        boolean bl2 = set != null;
        try {
            List<TaskInfo> list2;
            taskCollectorData.collector.reset();
            List<TaskInfo> list3 = list2 = TaskSearchAdapter.getTasksFromCollector(taskFilter, taskCollectorData, set, bl2, bl);
            return list3;
        }
        catch (Exception exception) {
            list.add((Exception)MixedUtil.getMethodFault((Throwable)exception));
            List<TaskInfo> list4 = null;
            return list4;
        }
        finally {
            try {
                taskCollectorData.collector.remove();
            }
            catch (Exception exception) {
                _logger.error((Object)"Error while removing collector", (Throwable)exception);
            }
            taskCollectorData.collector = null;
        }
    }

    private static List<TaskInfo> getTasksFromCollector(TaskFilter taskFilter, TaskCollectorData taskCollectorData, Set<String> set, boolean bl, boolean bl2) {
        TaskInfo[] taskInfoArray = taskCollectorData.collector.getLatestPage();
        List<TaskInfo> list = new ArrayList<TaskInfo>();
        for (int i = 0; i < taskFilter.currentPage && taskInfoArray != null && taskInfoArray.length >= taskFilter.count; ++i) {
            if (bl2 || bl) {
                Collections.addAll(list, taskInfoArray);
            }
            taskInfoArray = taskCollectorData.collector.readPrev(taskFilter.count);
        }
        if (taskInfoArray != null) {
            Collections.addAll(list, taskInfoArray);
        }
        if (set != null) {
            list = TaskSearchAdapter.filterRootTasks(taskCollectorData, taskFilter, list, set, taskInfoArray);
            if (!bl2 && taskFilter.currentPage > 0) {
                list = TaskSearchAdapter.getRequestedPage(taskFilter, list);
            }
        }
        return list;
    }

    private static List<TaskInfo> filterRootTasks(TaskCollectorData taskCollectorData, TaskFilter taskFilter, List<TaskInfo> list, Set<String> set, TaskInfo[] taskInfoArray) {
        List<TaskInfo> list2;
        ArrayList<TaskInfo> arrayList = new ArrayList<TaskInfo>(list.size());
        for (TaskInfo taskInfo : list) {
            if (!TaskSearchAdapter.taskIncludedInRootFilter(set, taskInfo).booleanValue()) continue;
            arrayList.add(taskInfo);
        }
        int n = list.size() - arrayList.size();
        if (n == 0) {
            return list;
        }
        TaskInfo[] taskInfoArray2 = taskInfoArray;
        for (int i = n; i > 0 && taskInfoArray2 != null && taskInfoArray2.length == taskFilter.count && (taskInfoArray2 = taskCollectorData.collector.readPrev(taskFilter.count)) != null; i -= list2.size()) {
            list2 = new ArrayList<TaskInfo>(taskInfoArray2.length);
            for (TaskInfo taskInfo : taskInfoArray2) {
                if (!TaskSearchAdapter.taskIncludedInRootFilter(set, taskInfo).booleanValue()) continue;
                list2.add(taskInfo);
            }
            if (list2.size() > i) {
                list2 = TaskSearchAdapter.getMostRecentTasks(list2, i);
            }
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    private static TaskCollectorData getCollectorForService(VcService vcService, TaskFilter taskFilter, List<Exception> list) {
        TaskCollectorData taskCollectorData = new TaskCollectorData();
        try {
            ServiceInstanceContent serviceInstanceContent = vcService.getServiceInstanceContent();
            taskCollectorData.moRef = serviceInstanceContent.taskManager;
            taskCollectorData.taskManager = (TaskManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)serviceInstanceContent.taskManager);
            if (!taskFilter.recentTasks) {
                ManagedObjectReference managedObjectReference = taskCollectorData.taskManager.createCollector(taskFilter.taskFilterSpec);
                TaskHistoryCollector taskHistoryCollector = (TaskHistoryCollector)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
                taskHistoryCollector.setLatestPageSize(taskFilter.count);
                taskCollectorData.collector = taskHistoryCollector;
            }
            taskCollectorData.vcName = VcServiceUtil.getServiceName((String)vcService.getServiceGuid());
        }
        catch (Exception exception) {
            list.add((Exception)MixedUtil.getMethodFault((Throwable)exception));
            return null;
        }
        return taskCollectorData;
    }

    private static List<TaskCollectorData> createTaskCollectors(TaskFilter taskFilter, List<Exception> list) throws InterruptedException {
        TaskFilterSpec taskFilterSpec = taskFilter.taskFilterSpec;
        if (taskFilterSpec.entity != null && taskFilterSpec.entity.entity != null) {
            VcService vcService = VimSessionUtil.getService((String)taskFilterSpec.entity.entity.getServerGuid());
            TaskCollectorData taskCollectorData = TaskSearchAdapter.getCollectorForService(vcService, taskFilter, list);
            if (taskCollectorData == null) {
                return Collections.emptyList();
            }
            List<TaskCollectorData> list2 = Collections.singletonList(taskCollectorData);
            return list2;
        }
        CopyOnWriteArrayList<Exception> copyOnWriteArrayList = new CopyOnWriteArrayList<Exception>();
        List<TaskCollectorData> list3 = TaskSearchAdapter.getTaskCollectors(taskFilter, copyOnWriteArrayList);
        list.addAll(copyOnWriteArrayList);
        return list3;
    }

    private static List<TaskCollectorData> getTaskCollectors(final TaskFilter taskFilter, final CopyOnWriteArrayList<Exception> copyOnWriteArrayList) throws InterruptedException {
        Object object;
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        if (linkedVcGroupRegistry == null) {
            _logger.error((Object)"TaskSearchAdapter not able to retrieve linked VC group registry");
            return Collections.emptyList();
        }
        ArrayList<4> arrayList = new ArrayList<4>();
        LinkedVcGroup[] linkedVcGroupArray = linkedVcGroupRegistry.getUtils().getStartupLinkedVcGroups();
        for (LinkedVcGroup linkedVcGroup : linkedVcGroupArray) {
            object = linkedVcGroup.getVcServices().iterator();
            while (object.hasNext()) {
                VcService vcService;
                final VcService vcService2 = vcService = (VcService)object.next();
                Callable<TaskCollectorData> callable = new Callable<TaskCollectorData>(){

                    @Override
                    public TaskCollectorData call() throws Exception {
                        TaskCollectorData taskCollectorData = TaskSearchAdapter.getCollectorForService(vcService2, taskFilter, copyOnWriteArrayList);
                        return taskCollectorData;
                    }
                };
                arrayList.add(callable);
            }
        }
        List list = ExecutorUtil.executeTasks(arrayList, (Executor)EXECUTOR);
        ArrayList<TaskCollectorData> arrayList2 = new ArrayList<TaskCollectorData>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            LinkedVcGroup linkedVcGroup;
            linkedVcGroup = (ExecutorUtil.TaskResult)iterator.next();
            if (linkedVcGroup.getResult() == null) continue;
            arrayList2.add((TaskCollectorData)linkedVcGroup.getResult());
            object = linkedVcGroup.getException();
            if (object == null) continue;
            copyOnWriteArrayList.add((Exception)object);
        }
        return arrayList2;
    }

    private static ManagedObjectReference[] createMORArray(Object[] objectArray) {
        ManagedObjectReference[] managedObjectReferenceArray = new ManagedObjectReference[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            managedObjectReferenceArray[i] = (ManagedObjectReference)objectArray[i];
        }
        return managedObjectReferenceArray;
    }

    private static Boolean taskIncludedInRootFilter(Set<String> set, TaskInfo taskInfo) {
        if (set == null) {
            return true;
        }
        String string = taskInfo.key;
        String string2 = taskInfo.rootTaskKey;
        boolean bl = set.contains(string) || set.contains(string2);
        return bl;
    }

    private static void handleExecutionException(String string, ExecutionException executionException) throws InterruptedException {
        Throwable throwable = executionException.getCause();
        if (throwable instanceof InterruptedException) {
            throw (InterruptedException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        _logger.error((Object)string, throwable);
    }

    static class TaskFilter {
        int count;
        TaskFilterSpec taskFilterSpec;
        boolean activeTasks;
        boolean recentTasks;
        String[] rootTaskKey;
        int currentPage;
        public ManagedObjectReference[] migrationHistoryList;
        public boolean requestingPrevPage = true;

        TaskFilter() {
        }

        String getUsername() {
            if (this.taskFilterSpec == null) {
                return null;
            }
            TaskFilterSpec.ByUsername byUsername = this.taskFilterSpec.userName;
            if (byUsername != null && byUsername.userList != null && byUsername.userList.length > 0) {
                return this.taskFilterSpec.userName.userList[0];
            }
            return null;
        }
    }
}

