/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.task.messaging;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.core.model.monitor.TaskState;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.commons.messaging.PartialUpdateItem;
import com.vmware.vise.vim.commons.messaging.UpdatesProcessor;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.task.TaskSearchHelper;
import com.vmware.vsphere.client.task.impl.ClientTaskInfoPostProcessor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RecentTasksUpdatesProcessor
implements UpdatesProcessor<ClientTaskInfo> {
    private static final Log _logger = LogFactory.getLog(RecentTasksUpdatesProcessor.class);
    private final TaskSearchHelper _taskSearchHelper;
    private final ClientTaskInfoPostProcessor _taskPostProcessor;
    private final Cache<ManagedObjectReference, String> _serviceNames;

    public RecentTasksUpdatesProcessor(ClientTaskInfoPostProcessor clientTaskInfoPostProcessor, TaskSearchHelper taskSearchHelper) {
        this._taskPostProcessor = clientTaskInfoPostProcessor;
        this._taskSearchHelper = taskSearchHelper;
        this._serviceNames = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();
    }

    public PartialUpdate<ClientTaskInfo> process(String string, PropertyCollector.FilterUpdate filterUpdate) {
        if (!"/topic/recent-tasks".equals(string)) {
            return null;
        }
        PartialUpdate partialUpdate = PartialUpdate.empty();
        PropertyCollector.ObjectUpdate[] objectUpdateArray = filterUpdate.getObjectSet();
        if (objectUpdateArray != null) {
            if (filterUpdate.missingSet != null) {
                _logger.warn((Object)"missing filter set");
            }
            for (PropertyCollector.ObjectUpdate objectUpdate : objectUpdateArray) {
                this.addUpdate((PartialUpdate<ClientTaskInfo>)partialUpdate, objectUpdate);
            }
        }
        this.postProcessUpdates(partialUpdate.updates);
        return partialUpdate;
    }

    public PropertyCollector.FilterSpec createFilterSpec(String string, VcService vcService) {
        if (!"/topic/recent-tasks".equals(string)) {
            return null;
        }
        PropertyCollector.ObjectSpec objectSpec = new PropertyCollector.ObjectSpec();
        objectSpec.setObj(vcService.getServiceInstanceContent().taskManager);
        objectSpec.setSkip(Boolean.valueOf(true));
        PropertyCollector.TraversalSpec traversalSpec = new PropertyCollector.TraversalSpec();
        traversalSpec.setName("traverseTasks");
        traversalSpec.setPath("recentTask");
        traversalSpec.setSkip(Boolean.valueOf(false));
        traversalSpec.setType((TypeName)new TypeNameImpl("TaskManager"));
        objectSpec.selectSet = new PropertyCollector.SelectionSpec[]{traversalSpec};
        PropertyCollector.PropertySpec propertySpec = new PropertyCollector.PropertySpec();
        propertySpec.setType((TypeName)new TypeNameImpl("Task"));
        propertySpec.setAll(Boolean.valueOf(true));
        PropertyCollector.FilterSpec filterSpec = new PropertyCollector.FilterSpec();
        filterSpec.objectSet = new PropertyCollector.ObjectSpec[]{objectSpec};
        filterSpec.propSet = new PropertyCollector.PropertySpec[]{propertySpec};
        return filterSpec;
    }

    private void addUpdate(PartialUpdate<ClientTaskInfo> partialUpdate, PropertyCollector.ObjectUpdate objectUpdate) {
        if (objectUpdate.missingSet != null) {
            _logger.warn((Object)"missing object set");
        }
        if (PropertyCollector.ObjectUpdate.Kind.enter == objectUpdate.kind) {
            Optional<PartialUpdateItem<ClientTaskInfo>> optional2 = this.addNew(partialUpdate, objectUpdate);
            if (optional2.isPresent()) {
                PartialUpdateItem partialUpdateItem = (PartialUpdateItem)optional2.get();
                this.cacheServiceName((PartialUpdateItem<ClientTaskInfo>)partialUpdateItem);
            } else {
                _logger.error((Object)("[LiveRefresh] Failed to create new PartialUpdate for: " + objectUpdate));
            }
        } else if (PropertyCollector.ObjectUpdate.Kind.modify == objectUpdate.kind) {
            this.addDelta(partialUpdate, objectUpdate);
        } else if (PropertyCollector.ObjectUpdate.Kind.leave == objectUpdate.kind) {
            this.addDeleted(partialUpdate, objectUpdate);
        } else {
            _logger.warn((Object)("Unknown object update: " + objectUpdate));
        }
    }

    private void addDeleted(PartialUpdate<ClientTaskInfo> partialUpdate, PropertyCollector.ObjectUpdate objectUpdate) {
        partialUpdate.deleted.add(objectUpdate.getObj());
    }

    private Optional<PartialUpdateItem<ClientTaskInfo>> addNew(PartialUpdate<ClientTaskInfo> partialUpdate, PropertyCollector.ObjectUpdate objectUpdate) {
        for (PropertyCollector.Change change : objectUpdate.getChangeSet()) {
            if (!change.getName().equals("info")) continue;
            ClientTaskInfo clientTaskInfo = this.createNewUpdate(change);
            PartialUpdateItem partialUpdateItem = PartialUpdateItem.of((Object)clientTaskInfo, (Object)clientTaskInfo.taskRef);
            TaskInfo taskInfo = (TaskInfo)change.getVal();
            partialUpdateItem.getMetadata().put("reason", taskInfo.reason);
            partialUpdate.updates.add(partialUpdateItem);
            return Optional.of((Object)partialUpdateItem);
        }
        return Optional.absent();
    }

    private void addDelta(PartialUpdate<ClientTaskInfo> partialUpdate, PropertyCollector.ObjectUpdate objectUpdate) {
        ClientTaskInfo clientTaskInfo = new ClientTaskInfo();
        clientTaskInfo.taskRef = objectUpdate.getObj();
        PartialUpdateItem partialUpdateItem = PartialUpdateItem.deltaOf((Object)clientTaskInfo, (Object)clientTaskInfo.taskRef);
        for (PropertyCollector.Change change : objectUpdate.getChangeSet()) {
            Object object;
            if (change.getName().equals("info.task")) {
                clientTaskInfo.taskRef = change.getVal();
                partialUpdateItem.deltaProperties.add("taskRef");
                continue;
            }
            if (change.getName().equals("info.result")) {
                clientTaskInfo.result = change.getVal();
                if (clientTaskInfo.result != null && clientTaskInfo.result instanceof ManagedObjectReference) {
                    clientTaskInfo.resultType = ((ManagedObjectReference)clientTaskInfo.result).getType();
                }
                partialUpdateItem.deltaProperties.add("result");
                continue;
            }
            if (change.getName().equals("info.error")) {
                clientTaskInfo.error = (Exception)change.getVal();
                partialUpdateItem.deltaProperties.add("error");
                continue;
            }
            if (change.getName().equals("info.entity")) {
                clientTaskInfo.entity = change.getVal();
                partialUpdateItem.deltaProperties.add("entity");
                continue;
            }
            if (change.getName().equals("info.key")) {
                partialUpdateItem.deltaProperties.add("key");
                clientTaskInfo.key = (String)change.getVal();
                continue;
            }
            if (change.getName().equals("info.entityName")) {
                partialUpdateItem.deltaProperties.add("entityName");
                clientTaskInfo.entityName = (String)change.getVal();
                clientTaskInfo.entityType = clientTaskInfo.entity != null ? ((ManagedObjectReference)clientTaskInfo.entity).getType() : null;
                continue;
            }
            if (change.getName().equals("info.state")) {
                partialUpdateItem.deltaProperties.add("state");
                object = (TaskInfo.State)change.getVal();
                clientTaskInfo.state = this.getState((TaskInfo.State)object);
                continue;
            }
            if (change.getName().equals("info.cancelable")) {
                partialUpdateItem.deltaProperties.add("cancelable");
                clientTaskInfo.cancelable = (Boolean)change.getVal();
                continue;
            }
            if (change.getName().equals("info.progress")) {
                partialUpdateItem.deltaProperties.add("progress");
                object = change.getVal();
                clientTaskInfo.progress = object == null ? -1 : (Integer)object;
                continue;
            }
            if (change.getName().equals("info.queueTime")) {
                partialUpdateItem.deltaProperties.add("queueTime");
                clientTaskInfo.queueTime = ((Calendar)change.getVal()).getTime();
                continue;
            }
            if (change.getName().equals("info.startTime")) {
                partialUpdateItem.deltaProperties.add("startTime");
                clientTaskInfo.startTime = ((Calendar)change.getVal()).getTime();
                continue;
            }
            if (change.getName().equals("info.completeTime")) {
                partialUpdateItem.deltaProperties.add("completionTime");
                clientTaskInfo.completionTime = ((Calendar)change.getVal()).getTime();
                continue;
            }
            if (change.getName().equals("info.eventChainId")) {
                partialUpdateItem.deltaProperties.add("eventChainId");
                clientTaskInfo.eventChainId = (Integer)change.getVal();
                continue;
            }
            if (change.getName().equals("info.parentTaskKey")) {
                partialUpdateItem.deltaProperties.add("parentTaskKey");
                clientTaskInfo.parentTaskKey = (String)change.getVal();
                continue;
            }
            if (change.getName().equals("info.rootTaskKey")) {
                partialUpdateItem.deltaProperties.add("rootTaskKey");
                clientTaskInfo.rootTaskKey = (String)change.getVal();
                continue;
            }
            if (!change.getName().equals("info.description")) continue;
        }
        partialUpdate.updates.add(partialUpdateItem);
    }

    private ClientTaskInfo createNewUpdate(PropertyCollector.Change change) {
        TaskInfo taskInfo = (TaskInfo)change.getVal();
        LinkedVcGroupRegistry linkedVcGroupRegistry = (LinkedVcGroupRegistry)SessionUtil.getData((String)"LINKED_VC_GROUP_REGISTRY");
        ClientTaskInfo clientTaskInfo = this._taskSearchHelper.getClientTaskInfo(taskInfo, linkedVcGroupRegistry);
        return clientTaskInfo;
    }

    private TaskState getState(TaskInfo.State state) {
        switch (state) {
            case error: {
                return TaskState.ERROR;
            }
            case queued: {
                return TaskState.QUEUED;
            }
            case running: {
                return TaskState.RUNNING;
            }
            case success: {
                return TaskState.SUCCESS;
            }
        }
        return null;
    }

    private void postProcessUpdates(List<PartialUpdateItem<ClientTaskInfo>> list) {
        if (list.isEmpty()) {
            return;
        }
        ArrayList<ClientTaskInfo> arrayList = new ArrayList<ClientTaskInfo>();
        HashSet<ManagedObjectReference> hashSet = new HashSet<ManagedObjectReference>();
        this.populateTasksToPostProcess(list, arrayList, hashSet);
        List<ClientTaskInfo> list2 = this._taskPostProcessor.process(arrayList, hashSet);
        this.expireSerivceNames(list2);
    }

    private void cacheServiceName(PartialUpdateItem<ClientTaskInfo> partialUpdateItem) {
        if (((ClientTaskInfo)partialUpdateItem.data).service == null) {
            _logger.warn((Object)("[LiveRefresh] Null service name for task: " + ((ClientTaskInfo)partialUpdateItem.data).taskRef));
            return;
        }
        this._serviceNames.put((Object)((ManagedObjectReference)((ClientTaskInfo)partialUpdateItem.data).taskRef), (Object)((ClientTaskInfo)partialUpdateItem.data).service);
    }

    private void expireSerivceNames(List<ClientTaskInfo> list) {
        for (ClientTaskInfo clientTaskInfo : list) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("[LiveRefresh] Expiring service name for: " + clientTaskInfo.taskRef));
            }
            this._serviceNames.invalidate(clientTaskInfo.taskRef);
        }
    }

    private void populateTasksToPostProcess(List<PartialUpdateItem<ClientTaskInfo>> list, List<ClientTaskInfo> list2, Set<ManagedObjectReference> set) {
        for (PartialUpdateItem<ClientTaskInfo> partialUpdateItem : list) {
            ClientTaskInfo clientTaskInfo = (ClientTaskInfo)partialUpdateItem.data;
            String string = (String)this._serviceNames.getIfPresent(clientTaskInfo.taskRef);
            if (string == null) continue;
            clientTaskInfo.service = string;
            if (clientTaskInfo.entity != null) {
                set.add((ManagedObjectReference)clientTaskInfo.entity);
                list2.add(clientTaskInfo);
            }
            if (clientTaskInfo.result == null || !(clientTaskInfo.result instanceof ManagedObjectReference)) continue;
            set.add((ManagedObjectReference)clientTaskInfo.result);
            list2.add(clientTaskInfo);
        }
    }
}

