/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.security;

import com.google.common.base.Predicate;
import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.binding.vim.fault.InvalidLogin;
import com.vmware.vim.binding.vim.fault.NoPermission;
import com.vmware.vim.binding.vim.fault.SSPIChallenge;
import com.vmware.vim.binding.vim.fault.VimFault;
import com.vmware.vim.binding.vim.version.internal.versions;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vim.vmomi.core.exception.CertificateValidationException;
import com.vmware.vise.security.authentication.SecondaryAuthenticationHandler;
import com.vmware.vise.security.spring.DefaultAuthenticationException;
import com.vmware.vise.security.spring.WebAuthenticationDetails;
import com.vmware.vise.usersession.ServerInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.UnsupportedVersionException;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.collection.CollectionUtil;
import com.vmware.vise.util.concurrent.DiagnosticRunnable;
import com.vmware.vise.util.concurrent.DiagnosticThreadPoolExecutor;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vise.util.concurrent.ThreadPoolManager;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.extensions.impl.LinkedVcGroupRegistryImpl;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.commons.vcservice.CompatibilityException;
import com.vmware.vise.vim.commons.vcservice.HostMatchingServiceEndpointExPredicate;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.LoginSpec;
import com.vmware.vise.vim.commons.vcservice.SSPIException;
import com.vmware.vise.vim.commons.vcservice.ServerInfoEx;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.UrlMatchingServiceEndpointExPredicate;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vcservice.VcServiceCompatibilityChecker;
import com.vmware.vise.vim.commons.vcservice.VcSource;
import com.vmware.vise.vim.commons.vcservice.impl.LinkedVcGroupImpl;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vsphere.client.security.Util;
import com.vmware.vsphere.client.security.internal.Config;
import com.vmware.vsphere.client.security.websso.WebssoUtil;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.Authentication;

public class VimAuthenticationHandler
implements SecondaryAuthenticationHandler {
    public static final String SECURITY_FORM_SERVICE_URL_KEY = "j_serviceUrl";
    public static final String SECURITY_FORM_SERVICE_GUID_KEY = "j_serviceGuid";
    public static final String SECURITY_FORM_THUMBPRINT_KEY = "j_thumbprint";
    public static final String SECURITY_FORM_SSPI_TOKEN_KEY = "j_base64SspiToken";
    public static final String SECURITY_FORM_HOST_CLIENT = "j_hostClient";
    public static final String IGNORE_SSL_ERROR = "_ignoreSslError";
    public static final String CONNECTION_ERROR = "connectionError";
    public static final String PERMISSION_ERROR = "permissionError";
    public static final String CERTIFICATE_ERROR = "certificateError=";
    public static final String SSPI_CHALLENGE_ERROR = "sspiChallenge=";
    public static final String VIM_FAULT = "vimFault=";
    private static final Log _logger = LogFactory.getLog(VimAuthenticationHandler.class);
    private final AtomicLong _authenticatedVIMSessions = new AtomicLong(0L);
    private final SsoService _ssoService;
    private final VcSource _vcSource;
    private final ConfigurationService _configService;
    private final boolean _webSsoNotificationsEnabled;
    private final boolean _useUnstableVmodl;
    private final boolean _allowUserWithoutPermissionsLogin;
    private final VcServiceCompatibilityChecker _vcCompatibilityChecker;
    private final SSLConfigurationProvider _sslConfigurationProvider;
    private static final AtomicBoolean _alreadyAssignedConfigServiceToExecutor = new AtomicBoolean(false);
    private static final String POOL_NAME = "vim-authentication-pool";
    private static final DiagnosticThreadPoolExecutor EXECUTOR;

    public VimAuthenticationHandler(ConfigurationService configurationService, SsoService ssoService, VcSource vcSource, @Nullable VcServiceCompatibilityChecker vcServiceCompatibilityChecker, @Nullable SSLConfigurationProvider sSLConfigurationProvider) {
        this._configService = configurationService;
        this._ssoService = ssoService;
        this._vcSource = vcSource;
        this._vcCompatibilityChecker = vcServiceCompatibilityChecker;
        this._sslConfigurationProvider = sSLConfigurationProvider;
        String string = configurationService.getProperty("use.unstable.vmodl");
        this._useUnstableVmodl = StringUtil.parseBoolean((String)string, (boolean)false);
        String string2 = configurationService.getProperty("websso.handleLogoutNotifications");
        this._webSsoNotificationsEnabled = StringUtil.parseBoolean((String)string2, (boolean)false);
        String string3 = configurationService.getProperty("allow.user.without.permissions.login");
        this._allowUserWithoutPermissionsLogin = StringUtil.parseBoolean((String)string3, (boolean)false);
        if (this._configService != null && !_alreadyAssignedConfigServiceToExecutor.getAndSet(true)) {
            EXECUTOR.useConfigurationService(this._configService);
        }
    }

    public void authenticate(Authentication authentication) throws Exception {
        Object object;
        Object object22;
        Object object3;
        String string;
        HttpSession httpSession = this.getSession(authentication);
        HttpServletRequest httpServletRequest = this.getRequest(authentication);
        if (_logger.isInfoEnabled()) {
            string = SessionUtil.getHashedSessionId((HttpSession)httpSession);
            _logger.info((Object)("Logging in to LinkedVcGroupRegistry for session " + string));
        }
        string = this.createLoginSpec(authentication);
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry((HttpSession)httpSession);
        if (VimAuthenticationHandler.isSingleServerLogin((LoginSpec)string)) {
            this.authenticateToSingleServer((LoginSpec)string, httpServletRequest, linkedVcGroupRegistry);
            this.setupSessionData(httpServletRequest, httpSession, linkedVcGroupRegistry);
            return;
        }
        List<ServerInfoEx> list = this.getVcsWithEndpoints();
        if (_logger.isDebugEnabled()) {
            object3 = SessionUtil.getHashedSessionId((HttpSession)httpSession);
            _logger.debug((Object)String.format("Connecting to %s vcs - %s", list.size(), object3));
        }
        object3 = new ArrayList(list.size());
        for (Object object22 : list) {
            DiagnosticRunnable diagnosticRunnable = new DiagnosticRunnable((ServerInfoEx)object22, (LoginSpec)string, httpServletRequest, linkedVcGroupRegistry){
                final /* synthetic */ ServerInfoEx val$sInfo;
                final /* synthetic */ LoginSpec val$spec;
                final /* synthetic */ HttpServletRequest val$request;
                final /* synthetic */ LinkedVcGroupRegistry val$registry;
                {
                    this.val$sInfo = serverInfoEx;
                    this.val$spec = loginSpec;
                    this.val$request = httpServletRequest;
                    this.val$registry = linkedVcGroupRegistry;
                }

                public void run() {
                    VimAuthenticationHandler.this.connectAndLoginToVcServer(this.val$sInfo, this.val$spec, this.val$request, this.val$registry);
                }

                public String toString() {
                    return "connectAndLoginToVcServer:" + this.val$sInfo.serviceUrl;
                }
            };
            object3.add(diagnosticRunnable);
        }
        try {
            if (object3 != null && object3.size() > 0) {
                ExecutorUtil.executeTasks((Collection)object3, (Executor)EXECUTOR, (long)3L, (TimeUnit)TimeUnit.MINUTES);
                object3 = null;
            }
            if (_logger.isInfoEnabled()) {
                object = SessionUtil.getHashedSessionId((HttpSession)httpSession);
                _logger.info((Object)("LinkedVcGroupRegistry login complete " + (String)object));
            }
            object = linkedVcGroupRegistry.getUtils().getStartupLinkedVcGroups();
            if (_logger.isDebugEnabled()) {
                object22 = SessionUtil.getHashedSessionId((HttpSession)httpSession);
                _logger.debug((Object)(((Object[])object).length + " linked vc group(s) found in the session " + (String)object22));
            }
            if (!this._allowUserWithoutPermissionsLogin && ArrayUtil.isNullOrEmpty((Object[])object) && this.isUserWithoutPermissionsAttemptToLogin(httpSession)) {
                SessionUtil.setData((String)"userHasNoPermissionsForAllServers", (Object)true, (HttpSession)httpSession);
                throw new DefaultAuthenticationException(Util.getLocalizedString("error.notHavePermissions", new String[0]), null);
            }
        }
        catch (InterruptedException interruptedException) {
            object22 = SessionUtil.getHashedSessionId((HttpSession)httpSession);
            _logger.error((Object)("Error during LinkedVcGroupRegistry login " + (String)object22), (Throwable)interruptedException);
        }
        catch (TimeoutException timeoutException) {
            object22 = SessionUtil.getHashedSessionId((HttpSession)httpSession);
            _logger.error((Object)("Timed out during LinkedVcGroupRegistry login: " + (String)object22 + ". Will proceed anyway."), (Throwable)timeoutException);
        }
        this.setInstallationId();
        this.setupSessionData(httpServletRequest, httpSession, linkedVcGroupRegistry);
        object = SessionUtil.getSessionInfo((HttpSession)httpSession);
        _logger.info((Object)("VIM authentication successful for " + (String)object));
    }

    private boolean isUserWithoutPermissionsAttemptToLogin(HttpSession httpSession) {
        List list = (List)SessionUtil.getData((String)"SERVER_INFO", (HttpSession)httpSession);
        if (list == null || list.isEmpty()) {
            return false;
        }
        boolean bl = true;
        for (ServerInfoEx serverInfoEx : list) {
            if (serverInfoEx.errorCode == "noPermission") continue;
            bl = false;
            break;
        }
        return bl;
    }

    private void setInstallationId() {
        String string = this._configService.getProperty("installation.id");
        if (string != null && string.length() > 0) {
            return;
        }
        String string2 = this._vcSource.getServiceIdOfLocalVc();
        if (string2 != null && string2.length() > 0) {
            string = "h5c-" + string2;
        }
        if (string != null && string.length() > 0) {
            this._configService.addProperty("installation.id", string);
        }
    }

    private List<ServerInfoEx> getVcsWithEndpoints() {
        List list;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("VC source is of type: " + this._vcSource.getClass().getSimpleName()));
        }
        if (CollectionUtil.isNullOrEmpty((Collection)(list = this._vcSource.getVcs()))) {
            _logger.warn((Object)("VcSource of type: " + this._vcSource.getClass().getSimpleName() + ", returned no VCs"));
            return Collections.emptyList();
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("VC source returned " + list.size() + " VCs"));
        }
        ArrayList<ServerInfoEx> arrayList = new ArrayList<ServerInfoEx>(list.size());
        for (ServerInfoEx serverInfoEx : list) {
            boolean bl;
            boolean bl2 = bl = serverInfoEx.endpoints != null && serverInfoEx.endpoints.length > 0;
            if (bl || this.isVc55(serverInfoEx)) {
                arrayList.add(serverInfoEx);
                continue;
            }
            _logger.warn((Object)("Found a VC containing 0 service endpoints: " + serverInfoEx.serviceUrl));
        }
        return arrayList;
    }

    private boolean isVc55(ServerInfoEx serverInfoEx) {
        if (serverInfoEx.serviceUrl == null) {
            return false;
        }
        if (serverInfoEx.vmodlVersion != null && VcServiceUtil.isOPVcOrLater((Class)serverInfoEx.vmodlVersion) && !VcServiceUtil.is60VcOrLater((Class)serverInfoEx.vmodlVersion)) {
            return true;
        }
        return serverInfoEx.version != null && VcServiceUtil.isOPVcOrLaterByVersion((String)serverInfoEx.version) && !VcServiceUtil.is60VcOrLaterByVersion((String)serverInfoEx.version);
    }

    public void logout(HttpSession httpSession) {
        LinkedVcGroup[] linkedVcGroupArray;
        String string;
        if (_logger.isInfoEnabled()) {
            string = SessionUtil.getHashedSessionId((HttpSession)httpSession);
            linkedVcGroupArray = SessionUtil.getHashedClientId((HttpSession)httpSession);
            _logger.info((Object)("Logging out for session " + string + " (clientId " + (String)linkedVcGroupArray + ")"));
        }
        string = VimSessionUtil.removeLinkedVcGroupRegistry((HttpSession)httpSession);
        SessionUtil.removeData((String)"USER_NAME", (HttpSession)httpSession);
        if (string == null) {
            _logger.warn((Object)"linked vc group registry is null");
            return;
        }
        linkedVcGroupArray = string.getLinkedVcGroups();
        if (linkedVcGroupArray != null) {
            for (LinkedVcGroup linkedVcGroup : linkedVcGroupArray) {
                try {
                    linkedVcGroup.logout();
                }
                catch (Exception exception) {
                    _logger.warn((Object)"Ignoring exception upon logout: ", (Throwable)exception);
                }
            }
        }
        _logger.info((Object)(this._authenticatedVIMSessions.decrementAndGet() + " authenticated VIM session(s)."));
    }

    public void successfulAuthentication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Authentication authentication) {
        HttpSession httpSession = httpServletRequest.getSession();
        String string = SessionUtil.getClientId((HttpSession)httpSession);
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry((HttpSession)httpSession);
        if (linkedVcGroupRegistry instanceof LinkedVcGroupRegistryImpl) {
            ((LinkedVcGroupRegistryImpl)linkedVcGroupRegistry).setClientId(string);
        }
    }

    private HttpServletRequest getRequest(Authentication authentication) {
        WebAuthenticationDetails webAuthenticationDetails = (WebAuthenticationDetails)authentication.getDetails();
        return webAuthenticationDetails.getRequest();
    }

    private HttpSession getSession(Authentication authentication) {
        HttpServletRequest httpServletRequest = this.getRequest(authentication);
        return httpServletRequest.getSession();
    }

    private LoginSpec createLoginSpec(Authentication authentication) {
        String string = (String)authentication.getPrincipal();
        String string2 = (String)authentication.getCredentials();
        WebAuthenticationDetails webAuthenticationDetails = (WebAuthenticationDetails)authentication.getDetails();
        HttpServletRequest httpServletRequest = webAuthenticationDetails.getRequest();
        String string3 = ResourceUtil.getLocale((HttpServletRequest)httpServletRequest).toString();
        String string4 = webAuthenticationDetails.getParameter(SECURITY_FORM_SERVICE_URL_KEY);
        String string5 = webAuthenticationDetails.getParameter(SECURITY_FORM_SSPI_TOKEN_KEY);
        String string6 = webAuthenticationDetails.getParameter("sessionTicket");
        boolean bl = Boolean.parseBoolean(webAuthenticationDetails.getParameter(IGNORE_SSL_ERROR));
        boolean bl2 = !StringUtil.isNullOrEmpty((String)string4);
        PrivateKey privateKey = null;
        if (this._ssoService != null) {
            privateKey = this._ssoService.getHokPrivateKey();
        }
        LoginSpec loginSpec = new LoginSpec();
        loginSpec.ssoDomain = SsoDomain.getLocal();
        loginSpec.userName = string;
        loginSpec.password = string2;
        loginSpec.base64SspiToken = string5;
        loginSpec.locale = string3;
        loginSpec.privateKey = privateKey;
        loginSpec.cloneSessionTicket = string6;
        loginSpec.isSingleServerLogin = bl2;
        loginSpec.ignoreSslThumbprint = bl;
        if (VimAuthenticationHandler.isSingleServerLogin(loginSpec)) {
            loginSpec.serviceUrl = string4;
            loginSpec.serviceGuid = webAuthenticationDetails.getParameter(SECURITY_FORM_SERVICE_GUID_KEY);
            loginSpec.thumbprint = webAuthenticationDetails.getParameter(SECURITY_FORM_THUMBPRINT_KEY);
        }
        return loginSpec;
    }

    private void authenticateToSingleServer(LoginSpec loginSpec, HttpServletRequest httpServletRequest, LinkedVcGroupRegistry linkedVcGroupRegistry) throws Exception {
        ServerInfoEx serverInfoEx = new ServerInfoEx();
        serverInfoEx.serviceUrl = loginSpec.serviceUrl;
        serverInfoEx.serviceGuid = loginSpec.serviceGuid;
        serverInfoEx.thumbprint = loginSpec.thumbprint;
        this.connectAndLoginToVcServer(serverInfoEx, loginSpec, httpServletRequest, linkedVcGroupRegistry);
    }

    private LoginSpec createLoginSpec(ServerInfoEx serverInfoEx, LoginSpec loginSpec, HttpSession httpSession) {
        if (VimAuthenticationHandler.isSingleServerLogin(loginSpec)) {
            return loginSpec;
        }
        LoginSpec loginSpec2 = VcServiceUtil.createVcLoginSpec((ServerInfoEx)serverInfoEx, (SSLConfigurationProvider)this._sslConfigurationProvider);
        loginSpec2.userName = loginSpec.userName;
        loginSpec2.password = loginSpec.password;
        loginSpec2.base64SspiToken = loginSpec.base64SspiToken;
        loginSpec2.tokenProvider = AuthSessionUtil.getSsoTokenProvider((HttpSession)httpSession);
        loginSpec2.privateKey = loginSpec.privateKey;
        loginSpec2.locale = loginSpec.locale;
        loginSpec2.isSingleServerLogin = loginSpec.isSingleServerLogin;
        loginSpec2.ignoreSslThumbprint = loginSpec.ignoreSslThumbprint;
        if (this._useUnstableVmodl) {
            _logger.warn((Object)("Set unstable VMODL version " + versions.VIM_VERSION_NEWEST.getCanonicalName() + ", as is defined in webclient.properties."));
            loginSpec2.vmodlVersion = versions.VIM_VERSION_NEWEST;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("LoginSpec: serviceUrl=" + loginSpec2.serviceUrl + ", serviceGuid=" + loginSpec2.serviceGuid + ", vmodlVersion=" + (loginSpec2.vmodlVersion != null ? loginSpec2.vmodlVersion.getName() : null) + " (ServerInfoEx version=" + serverInfoEx.version + ")"));
        }
        return loginSpec2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectAndLoginToVcServer(ServerInfoEx serverInfoEx, LoginSpec loginSpec, HttpServletRequest httpServletRequest, LinkedVcGroupRegistry linkedVcGroupRegistry) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Commencing connectAndLogin to linked group: " + serverInfoEx.serviceUrl));
        }
        HttpSession httpSession = httpServletRequest.getSession();
        boolean bl = false;
        int n = 0;
        String string = serverInfoEx.serviceUrl;
        String string2 = loginSpec.userName;
        LoginSpec loginSpec2 = null;
        LinkedVcGroupImpl linkedVcGroupImpl = null;
        List list = serverInfoEx.peers;
        ArrayList arrayList = null;
        try {
            String string3;
            Object object2;
            Exception exception = null;
            do {
                try {
                    string = serverInfoEx.serviceUrl;
                    loginSpec2 = this.createLoginSpec(serverInfoEx, loginSpec, httpServletRequest.getSession());
                    linkedVcGroupImpl = new LinkedVcGroupImpl(loginSpec2, this._vcCompatibilityChecker, this._configService, this._sslConfigurationProvider, arrayList);
                }
                catch (Exception exception2) {
                    exception = exception2;
                    int n2 = n++;
                    if (list == null || n2 >= list.size()) {
                        _logger.error((Object)("Failed to create a linked group by using startup VC " + string + ". There are no remaining peers to try as a startup VC."), (Throwable)exception2);
                        break;
                    }
                    if (serverInfoEx.endpoints != null) {
                        object2 = null;
                        if (ExceptionUtil.isCausedByAnyOf((Throwable)exception2, (Class[])new Class[]{UnknownHostException.class, NoRouteToHostException.class})) {
                            try {
                                string3 = new URI(string).getHost();
                                object2 = (ServiceEndpointEx[])ArrayUtil.retainAll((Object[])serverInfoEx.endpoints, (Predicate)new HostMatchingServiceEndpointExPredicate(string3));
                            }
                            catch (URISyntaxException uRISyntaxException) {
                                _logger.error((Object)("Failed to extract the host from VC URL " + string), (Throwable)uRISyntaxException);
                            }
                        } else if (ExceptionUtil.isCausedByAnyOf((Throwable)exception2, (Class[])new Class[]{SocketException.class, SocketTimeoutException.class, ConnectException.class, SSLException.class})) {
                            object2 = (ServiceEndpointEx[])ArrayUtil.retainAll((Object[])serverInfoEx.endpoints, (Predicate)new UrlMatchingServiceEndpointExPredicate(string));
                        }
                        if (object2 != null) {
                            if (arrayList == null) {
                                arrayList = new ArrayList(7);
                            }
                            Collections.addAll(arrayList, object2);
                        }
                    }
                    serverInfoEx = (ServerInfoEx)list.get(n2);
                    _logger.error((Object)("Failed to create a linked group by using startup VC " + string + ". Will try using VC " + serverInfoEx.serviceUrl + " as a startup VC."), (Throwable)exception2);
                }
            } while (linkedVcGroupImpl == null);
            if (linkedVcGroupImpl == null && exception != null) {
                throw exception;
            }
            Collection collection = linkedVcGroupImpl.getIncompatibleVcs();
            if (collection.size() > 0) {
                for (Object object2 : collection) {
                    string3 = object2.getVcService();
                    ServerInfoEx serverInfoEx2 = VcServiceUtil.toServerInfoEx((VcService)string3, null);
                    serverInfoEx2.errorCode = "compatibilityError";
                    this.addServerInfoToSession((ServerInfo)serverInfoEx2, httpSession);
                }
            }
            string2 = loginSpec2.userName;
            LinkedVcGroupRegistry linkedVcGroupRegistry2 = linkedVcGroupRegistry;
            synchronized (linkedVcGroupRegistry2) {
                if (this.isServerAlreadyProcessed(loginSpec, (LinkedVcGroup)linkedVcGroupImpl, linkedVcGroupRegistry)) {
                    if (_logger.isDebugEnabled()) {
                        object2 = SessionUtil.getHashedSessionId((HttpSession)httpSession);
                        _logger.debug((Object)String.format("VC %s is already processed, so filtering it - %s", string, object2));
                    }
                    return;
                }
                linkedVcGroupRegistry.getUtils().addStartupLinkedVcGroup((LinkedVcGroup)linkedVcGroupImpl);
            }
            bl = true;
            linkedVcGroupImpl.login();
        }
        catch (Exception exception) {
            Object object;
            Exception exception3;
            if (exception instanceof ExecutionException && exception.getCause() instanceof Exception) {
                exception3 = (Exception)exception.getCause();
            }
            if (VimAuthenticationHandler.isSingleServerLogin(loginSpec)) {
                this.throwAuthException(exception3);
            }
            _logger.error((Object)("Connection failure to vc " + string), (Throwable)exception3);
            if (bl && !(exception3 instanceof InvalidLogin) && !(exception3 instanceof SSPIException) && !(exception3 instanceof NoPermission)) {
                return;
            }
            String string4 = "connectError";
            if (exception3 instanceof CertificateValidationException) {
                string4 = "sslError";
            } else if (exception3 instanceof CompatibilityException || exception3 instanceof UnsupportedVersionException) {
                if (linkedVcGroupImpl != null) {
                    linkedVcGroupRegistry.removeLinkedVcGroup((LinkedVcGroup)linkedVcGroupImpl);
                }
                string4 = "compatibilityError";
                if (serverInfoEx.peers != null) {
                    for (ServerInfoEx serverInfoEx3 : serverInfoEx.peers) {
                        ServerInfoEx serverInfoEx4 = serverInfoEx3.clone();
                        serverInfoEx4.errorCode = string4;
                        this.addServerInfoToSession((ServerInfo)serverInfoEx4, httpSession);
                    }
                }
            } else if (exception3 instanceof InvalidLogin) {
                if (linkedVcGroupImpl != null) {
                    linkedVcGroupRegistry.removeLinkedVcGroup((LinkedVcGroup)linkedVcGroupImpl);
                }
                string4 = "invalidCredentials";
            } else if (exception3 instanceof SSPIException) {
                if (linkedVcGroupImpl != null) {
                    linkedVcGroupRegistry.removeLinkedVcGroup((LinkedVcGroup)linkedVcGroupImpl);
                }
                string4 = "sspiError";
            } else if (exception3 instanceof NoPermission) {
                _logger.warn((Object)("Login to vCenter Server " + string + " failed with NoPermission error for user - " + string2));
                if (linkedVcGroupImpl != null) {
                    linkedVcGroupRegistry.removeLinkedVcGroup((LinkedVcGroup)linkedVcGroupImpl);
                }
                string4 = "noPermission";
            } else if (linkedVcGroupImpl != null && (object = linkedVcGroupImpl.getStartUpVcService()) != null) {
                string4 = object.getConnectionInfo().getErrorCode();
            }
            object = serverInfoEx.clone();
            ((ServerInfoEx)object).errorCode = string4;
            this.addServerInfoToSession((ServerInfo)object, httpSession);
        }
    }

    private void addServerInfoToSession(ServerInfo serverInfo, HttpSession httpSession) {
        Object object;
        List<Object> list = (ArrayList<ServerInfo>)SessionUtil.getData((String)"SERVER_INFO", (HttpSession)httpSession);
        if (list == null && (object = SessionUtil.setDataIfAbsent((String)"SERVER_INFO", list = new ArrayList<ServerInfo>(), (HttpSession)httpSession)) != null) {
            List list2 = (List)object;
            list = list2;
        }
        list.add(serverInfo);
    }

    private void setupSessionData(HttpServletRequest httpServletRequest, HttpSession httpSession, LinkedVcGroupRegistry linkedVcGroupRegistry) {
        String string = SessionUtil.getHashedSessionId((HttpSession)httpSession);
        _logger.info((Object)("Authentication successful for session : " + string));
        _logger.info((Object)(this._authenticatedVIMSessions.incrementAndGet() + " authenticated VIM session(s)."));
        String string2 = (String)SessionUtil.getData((String)"USER_NAME", (HttpSession)httpSession);
        if (!StringUtil.isNullOrEmpty((String)string2)) {
            return;
        }
        String string3 = null;
        if (this._webSsoNotificationsEnabled) {
            string3 = WebssoUtil.getWebSsoSessionIndex((HttpServletRequest)httpServletRequest);
        }
        if (!StringUtil.isNullOrWhitespace(string3)) {
            SessionUtil.initClientDataContainerAndAssociateSessionWithClientId((HttpSession)httpSession, (String)string3);
        } else {
            SessionUtil.generateAndSaveClientId((HttpSession)httpSession);
        }
        SessionUtil.setData((String)"LINKED_VC_GROUP_REGISTRY", (Object)linkedVcGroupRegistry, (HttpSession)httpSession);
        LinkedVcGroup[] linkedVcGroupArray = linkedVcGroupRegistry.getLinkedVcGroups();
        if (linkedVcGroupArray != null && linkedVcGroupArray.length >= 1) {
            VcService vcService = linkedVcGroupArray[0].getStartUpVcService();
            string2 = vcService.getConnectionInfo().getUserSession().userName;
            SessionUtil.setData((String)"USER_NAME", (Object)string2, (HttpSession)httpSession);
            String string4 = SessionUtil.getHashedClientId((HttpSession)httpSession);
            _logger.info((Object)("Username=" + string2 + " has clientId=" + string4 + ". Use that clientId to track user activities below."));
        }
    }

    private void throwAuthException(Exception exception) {
        String string = CONNECTION_ERROR;
        if (exception instanceof SSPIChallenge) {
            SSPIChallenge sSPIChallenge = (SSPIChallenge)exception;
            string = SSPI_CHALLENGE_ERROR + sSPIChallenge.getBase64Token();
        } else if (exception instanceof NoPermission) {
            string = PERMISSION_ERROR;
        } else if (exception instanceof VimFault || exception instanceof MethodFault || exception instanceof IllegalArgumentException || exception instanceof RuntimeFault) {
            string = VIM_FAULT + exception.getLocalizedMessage();
        } else if (exception instanceof CertificateValidationException) {
            CertificateValidationException certificateValidationException = (CertificateValidationException)exception;
            string = CERTIFICATE_ERROR + certificateValidationException.getThumbprint();
        } else {
            _logger.error((Object)"Error during authentication", (Throwable)exception);
        }
        if (!string.equals(CONNECTION_ERROR)) {
            _logger.error((Object)("Authentication failed - " + string));
        }
        throw new DefaultAuthenticationException(string, null);
    }

    private boolean isServerAlreadyProcessed(LoginSpec loginSpec, LinkedVcGroup linkedVcGroup, LinkedVcGroupRegistry linkedVcGroupRegistry) {
        if (VimAuthenticationHandler.isSingleServerLogin(loginSpec)) {
            return false;
        }
        String string = linkedVcGroup.getStartUpVcService().getServiceGuid();
        for (LinkedVcGroup linkedVcGroup2 : linkedVcGroupRegistry.getLinkedVcGroups()) {
            for (VcService vcService : linkedVcGroup2.getVcServices()) {
                if (!vcService.getServiceGuid().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSingleServerLogin(LoginSpec loginSpec) {
        return loginSpec.isSingleServerLogin;
    }

    static {
        WorkerThreadFactory workerThreadFactory = new WorkerThreadFactory(POOL_NAME);
        SynchronousQueue synchronousQueue = new SynchronousQueue(true);
        EXECUTOR = DiagnosticThreadPoolExecutor.builder((int)0, (int)100, (long)1L, (TimeUnit)TimeUnit.MINUTES, synchronousQueue, (ThreadFactory)workerThreadFactory).name(POOL_NAME).queueWaitTimeThreshold(Config.THREAD_POOL_WARN_QUEUE_WAIT_TIME_THRESHOLD_NANOS, TimeUnit.NANOSECONDS).delayedTaskStepSizeForLoggingAdditionalDiagnostics(Config.THREAD_POOL_WARN_DIAGNOSTICS_DELAYED_TASK_STEP_SIZE).rejectedTaskStepSizeForLoggingAdditionalDiagnostics(Config.THREAD_POOL_WARN_DIAGNOSTICS_REJECTED_TASK_STEP_SIZE).minTimeApartForLoggingAdditionalDiagnostics(Config.THREAD_POOL_WARN_DIAGNOSTICS_MIN_TIME_APART_NANOS, TimeUnit.NANOSECONDS).build();
        ThreadPoolManager.getInstance().register((ExecutorService)EXECUTOR);
    }
}

