/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.security.impl;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.binding.cis.cm.ServiceAttribute;
import com.vmware.vim.binding.cis.cm.ServiceEndPoint;
import com.vmware.vim.binding.cis.cm.ServiceInfo;
import com.vmware.vim.binding.cis.cm.site.Folder;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vise.util.Version;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.vcservice.ServerInfoEx;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.lookup.LookupUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LinkedGroupUtils {
    public static final String VC_ENDPOINT_TYPE = "com.vmware.vim";

    @Deprecated
    public static boolean is2014VcOrLater(String string) {
        return LinkedGroupUtils.is60VcOrLater(string);
    }

    public static boolean is60VcOrLater(String string) {
        return VcServiceUtil.is60VcOrLater((Version)new Version(string));
    }

    public static List<ServerInfoEx> getServerInfosForVcPeers(ServerInfoEx serverInfoEx, List<ServerInfoEx> list) {
        ArrayList<ServerInfoEx> arrayList = new ArrayList<ServerInfoEx>();
        for (ServerInfoEx serverInfoEx2 : list) {
            if (serverInfoEx2 == serverInfoEx || !LinkedGroupUtils.is60VcOrLater(serverInfoEx2.version)) continue;
            arrayList.add(serverInfoEx2);
        }
        return arrayList;
    }

    @Deprecated
    public static ServiceEndpointEx createVcServiceEndpoint(ServiceInfo serviceInfo) {
        ServiceEndPoint serviceEndPoint = LinkedGroupUtils.extractEndpointFromServiceInfo(serviceInfo, VC_ENDPOINT_TYPE);
        if (serviceEndPoint == null) {
            return null;
        }
        SsoDomain ssoDomain = SsoDomain.getLocal();
        Folder folder = serviceInfo.getFolder();
        String string = folder != null ? folder.getId() : null;
        String string2 = serviceInfo.getHostId();
        String string3 = serviceInfo.getServiceId();
        String string4 = LinkedGroupUtils.getServiceAttr(serviceInfo, "com.vmware.vim.vcenter.instanceName");
        String string5 = serviceEndPoint.getUrl().toString();
        String string6 = serviceInfo.getServiceVersion();
        String string7 = serviceEndPoint.getSslTrust()[0];
        ServiceEndpointEx serviceEndpointEx = ServiceEndpointEx.buildVcServiceEndpoint((SsoDomain)ssoDomain, (String)string, (String)string2, (String)string3, (String)string4, (String)string5, (String)string6, (String)string7);
        return serviceEndpointEx;
    }

    public static ServiceEndpointEx createVcServiceEndpoint(LookupService lookupService, ServiceRegistration.Info info) {
        ServiceRegistration.Endpoint endpoint = LookupUtil.getEndpoint((ServiceRegistration.Info)info, (String)VC_ENDPOINT_TYPE);
        if (endpoint == null) {
            return null;
        }
        SsoDomain ssoDomain = (SsoDomain)LookupUtil.getSsoDomain((ServiceRegistration.Info)info).orElse(null);
        if (ssoDomain == null) {
            ssoDomain = SsoDomain.getLocal();
        }
        String string = info.getNodeId();
        String string2 = LookupUtil.getServiceHostId((ServiceRegistration.Info)info);
        String string3 = info.getServiceId();
        String string4 = LookupUtil.getServiceAttribute((ServiceRegistration.Info)info, (String)"com.vmware.vim.vcenter.instanceName");
        String string5 = endpoint.getUrl().toString();
        String string6 = info.getServiceVersion();
        String string7 = endpoint.getSslTrust()[0];
        ServiceEndpointEx serviceEndpointEx = ServiceEndpointEx.buildVcServiceEndpoint((SsoDomain)ssoDomain, (String)string, (String)string2, (String)string3, (String)string4, (String)string5, (String)string6, (String)string7);
        return serviceEndpointEx;
    }

    @Deprecated
    public static void addISEndpoints(ServiceInfo[] serviceInfoArray, Map<String, String> map, List<ServiceEndpointEx> list) {
        for (ServiceInfo serviceInfo : serviceInfoArray) {
            ServiceEndPoint serviceEndPoint = LinkedGroupUtils.extractEndpointFromServiceInfo(serviceInfo, "com.vmware.cis.inventory");
            if (serviceEndPoint == null) continue;
            Folder folder = serviceInfo.getFolder();
            String string = folder != null ? folder.getId() : null;
            String string2 = serviceInfo.getHostId();
            String string3 = serviceInfo.getServiceId();
            String string4 = map.get(string2);
            String string5 = serviceEndPoint.getUrl().toString();
            String string6 = serviceInfo.getServiceVersion();
            String string7 = serviceEndPoint.getSslTrust()[0];
            ServiceEndpointEx serviceEndpointEx = ServiceEndpointEx.buildInventoryServiceEndpoint((SsoDomain)SsoDomain.getLocal(), (String)string, (String)string2, (String)string4, (String)string3, (String)string5, (String)string6, (String)string7);
            list.add(serviceEndpointEx);
        }
    }

    public static void addISEndpoints(LookupService lookupService, ServiceRegistration.Info[] infoArray, Map<String, String> map, List<ServiceEndpointEx> list) {
        for (ServiceRegistration.Info info : infoArray) {
            ServiceRegistration.Endpoint endpoint = LookupUtil.getEndpoint((ServiceRegistration.Info)info, (String)"com.vmware.cis.inventory");
            if (endpoint == null) continue;
            SsoDomain ssoDomain = (SsoDomain)LookupUtil.getSsoDomain((ServiceRegistration.Info)info).orElse(null);
            if (ssoDomain == null) {
                ssoDomain = SsoDomain.getLocal();
            }
            String string = info.getNodeId();
            String string2 = LookupUtil.getServiceHostId((ServiceRegistration.Info)info);
            String string3 = info.getServiceId();
            String string4 = map.get(string);
            String string5 = endpoint.getUrl().toString();
            String string6 = info.getServiceVersion();
            String string7 = endpoint.getSslTrust()[0];
            ServiceEndpointEx serviceEndpointEx = ServiceEndpointEx.buildInventoryServiceEndpoint((SsoDomain)ssoDomain, (String)string, (String)string2, (String)string4, (String)string3, (String)string5, (String)string6, (String)string7);
            list.add(serviceEndpointEx);
        }
    }

    public static String getServiceAttr(ServiceInfo serviceInfo, String string) {
        if (serviceInfo != null && serviceInfo.getServiceAttributes() != null) {
            for (ServiceAttribute serviceAttribute : serviceInfo.getServiceAttributes()) {
                if (!string.equals(serviceAttribute.getKey()) || serviceAttribute.getValue() == null) continue;
                return serviceAttribute.getValue();
            }
        }
        return null;
    }

    public static ServiceEndPoint extractEndpointFromServiceInfo(ServiceInfo serviceInfo, String string) {
        if (serviceInfo.getServiceEndPoints() == null) {
            return null;
        }
        for (ServiceEndPoint serviceEndPoint : serviceInfo.getServiceEndPoints()) {
            if (!string.equals(serviceEndPoint.getEndPointType().getTypeId())) continue;
            return serviceEndPoint;
        }
        return null;
    }
}

